/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

@NotThreadSafe
public class ReverseValueIterator<Concrete extends ReverseValueIterator<Concrete>>
extends Walker<Concrete> {
    static final int NOT_AT_LIMIT = Integer.MIN_VALUE;
    private final ByteSource limit;
    private IterationPosition stack;
    private long next;
    private boolean reportingPrefixes;

    protected ReverseValueIterator(Rebufferer source, long root) {
        super(source, root);
        this.limit = null;
        this.initializeNoRightBound(root, Integer.MIN_VALUE, false);
    }

    protected ReverseValueIterator(Rebufferer source, long root, ByteComparable start, ByteComparable end, boolean admitPrefix) {
        super(source, root);
        ByteSource byteSource = this.limit = start != null ? start.asComparableBytes(BYTE_COMPARABLE_VERSION) : null;
        if (end != null) {
            this.initializeWithRightBound(root, end.asComparableBytes(BYTE_COMPARABLE_VERSION), admitPrefix, this.limit != null);
        } else {
            this.initializeNoRightBound(root, this.limit != null ? this.limit.next() : Integer.MIN_VALUE, admitPrefix);
        }
    }

    void initializeWithRightBound(long root, ByteSource endStream, boolean admitPrefix, boolean hasLimit) {
        int limitByte;
        int childIndex;
        IterationPosition prev = null;
        boolean atLimit = hasLimit;
        this.reportingPrefixes = admitPrefix;
        this.go(root);
        while (true) {
            int s = endStream.next();
            childIndex = this.search(s);
            limitByte = Integer.MIN_VALUE;
            if (atLimit && s > (limitByte = this.limit.next())) {
                atLimit = false;
            }
            if (childIndex < 0) break;
            prev = new IterationPosition(this.position, childIndex, limitByte, prev);
            this.go(this.transition(childIndex));
        }
        childIndex = -1 - childIndex;
        this.stack = new IterationPosition(this.position, childIndex, limitByte, prev);
        this.next = this.advanceNode();
    }

    private void initializeNoRightBound(long root, int limitByte, boolean admitPrefix) {
        this.go(root);
        this.stack = new IterationPosition(root, -1 - this.search(256), limitByte, null);
        this.next = this.advanceNode();
        this.reportingPrefixes = admitPrefix;
    }

    protected long nextPayloadedNode() {
        long toReturn = this.next;
        if (this.next != -1L) {
            this.next = this.advanceNode();
        }
        return toReturn;
    }

    long advanceNode() {
        if (this.stack == null) {
            return -1L;
        }
        this.go(this.stack.node);
        while (true) {
            int transitionByte;
            int childIdx = this.stack.childIndex - 1;
            boolean beyondLimit = true;
            if (childIdx >= 0) {
                transitionByte = this.transitionByte(childIdx);
                boolean bl = beyondLimit = transitionByte < this.stack.limit;
                if (beyondLimit) {
                    assert (this.stack.limit >= 0);
                    this.reportingPrefixes = false;
                }
            } else {
                transitionByte = Integer.MIN_VALUE;
            }
            if (beyondLimit) {
                IterationPosition stackTop = this.stack;
                this.stack = this.stack.prev;
                if (this.payloadFlags() != 0) {
                    if (stackTop.limit == Integer.MIN_VALUE) {
                        return stackTop.node;
                    }
                    if (this.reportingPrefixes) {
                        this.reportingPrefixes = false;
                        return stackTop.node;
                    }
                }
                if (this.stack == null) {
                    return NONE;
                }
                this.go(this.stack.node);
                continue;
            }
            long child = this.transition(childIdx);
            if (child != (long)NONE) {
                this.go(child);
                this.stack.childIndex = childIdx;
                int l = Integer.MIN_VALUE;
                if (transitionByte == this.stack.limit) {
                    l = this.limit.next();
                }
                this.stack = new IterationPosition(child, this.transitionRange(), l, this.stack);
                continue;
            }
            this.stack.childIndex = childIdx;
        }
    }

    static class IterationPosition {
        final long node;
        final int limit;
        final IterationPosition prev;
        int childIndex;

        public IterationPosition(long node, int childIndex, int limit, IterationPosition prev) {
            this.node = node;
            this.childIndex = childIndex;
            this.limit = limit;
            this.prev = prev;
        }
    }
}

