/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class SortedTablePartitionWriter
implements AutoCloseable {
    protected final UnfilteredSerializer unfilteredSerializer;
    private final SerializationHeader header;
    private final SequentialWriter writer;
    private final SerializationHelper helper;
    private final Version version;
    private long previousRowStart;
    private long initialPosition;
    private long headerLength;
    protected long startPosition;
    protected int written;
    protected ClusteringPrefix<?> firstClustering;
    protected ClusteringPrefix<?> lastClustering;
    protected DeletionTime openMarker = DeletionTime.LIVE;
    protected DeletionTime startOpenMarker = DeletionTime.LIVE;
    State state = State.AWAITING_PARTITION_HEADER;

    protected SortedTablePartitionWriter(SerializationHeader header, SequentialWriter writer, Version version) {
        this.header = header;
        this.writer = writer;
        this.unfilteredSerializer = UnfilteredSerializer.serializer;
        this.helper = new SerializationHelper(header);
        this.version = version;
    }

    protected void reset() {
        this.initialPosition = this.writer.position();
        this.startPosition = -1L;
        this.previousRowStart = 0L;
        this.written = 0;
        this.firstClustering = null;
        this.lastClustering = null;
        this.openMarker = DeletionTime.LIVE;
        this.headerLength = -1L;
        this.state = State.AWAITING_PARTITION_HEADER;
    }

    public long getHeaderLength() {
        return this.headerLength;
    }

    public void start(DecoratedKey key, DeletionTime partitionLevelDeletion) throws IOException {
        if (this.state == State.COMPLETED) {
            this.reset();
        }
        Preconditions.checkState((this.state == State.AWAITING_PARTITION_HEADER ? 1 : 0) != 0);
        ByteBufferUtil.writeWithShortLength(key.getKey(), this.writer);
        DeletionTime.getSerializer(this.version).serialize(partitionLevelDeletion, (DataOutputPlus)this.writer);
        if (!this.header.hasStatic()) {
            this.headerLength = this.writer.position() - this.initialPosition;
            this.state = State.AWAITING_ROWS;
            return;
        }
        this.state = State.AWAITING_STATIC_ROW;
    }

    public void addStaticRow(Row staticRow) throws IOException {
        Preconditions.checkState((this.state == State.AWAITING_STATIC_ROW ? 1 : 0) != 0);
        Preconditions.checkState((boolean)staticRow.isStatic());
        UnfilteredSerializer.serializer.serializeStaticRow(staticRow, this.helper, this.writer, this.version.correspondingMessagingVersion());
        this.headerLength = this.writer.position() - this.initialPosition;
        this.state = State.AWAITING_ROWS;
    }

    public void addUnfiltered(Unfiltered unfiltered) throws IOException {
        Preconditions.checkState((this.state == State.AWAITING_ROWS ? 1 : 0) != 0);
        long pos = this.currentPosition();
        if (this.firstClustering == null) {
            this.firstClustering = unfiltered.clustering();
            this.startOpenMarker = this.openMarker;
            this.startPosition = pos;
        }
        long unfilteredPosition = this.writer.position();
        this.unfilteredSerializer.serialize(unfiltered, this.helper, (DataOutputPlus)this.writer, pos - this.previousRowStart, this.version.correspondingMessagingVersion());
        this.lastClustering = unfiltered.clustering();
        this.previousRowStart = pos;
        ++this.written;
        if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            RangeTombstoneMarker marker = (RangeTombstoneMarker)unfiltered;
            this.openMarker = marker.isOpen(false) ? marker.openDeletionTime(false) : DeletionTime.LIVE;
        }
    }

    protected long finish() throws IOException {
        Preconditions.checkState((this.state == State.AWAITING_ROWS ? 1 : 0) != 0);
        this.state = State.COMPLETED;
        long endPosition = this.currentPosition();
        this.unfilteredSerializer.writeEndOfPartition(this.writer);
        return endPosition;
    }

    protected long currentPosition() {
        return this.writer.position() - this.initialPosition;
    }

    public long getInitialPosition() {
        return this.initialPosition;
    }

    private static enum State {
        AWAITING_PARTITION_HEADER,
        AWAITING_STATIC_ROW,
        AWAITING_ROWS,
        COMPLETED;

    }
}

