/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.ObjectSizes;

@ThreadSafe
public class PrimaryKeys
implements Iterable<PrimaryKey> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new PrimaryKeys());
    private static final long SET_ENTRY_OVERHEAD = 36L;
    private final ConcurrentSkipListSet<PrimaryKey> keys = new ConcurrentSkipListSet();

    public long add(PrimaryKey key) {
        return this.keys.add(key) ? 36L : 0L;
    }

    public SortedSet<PrimaryKey> keys() {
        return this.keys;
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    @Override
    public Iterator<PrimaryKey> iterator() {
        return this.keys.iterator();
    }
}

