/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.List;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;

public class KeyRangeListIterator
extends KeyRangeIterator {
    private final PeekingIterator<PrimaryKey> keyQueue;

    public KeyRangeListIterator(PrimaryKey minimumKey, PrimaryKey maximumKey, List<PrimaryKey> keys) {
        super(minimumKey, maximumKey, keys.size());
        this.keyQueue = Iterators.peekingIterator(keys.iterator());
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        while (this.keyQueue.hasNext() && ((PrimaryKey)this.keyQueue.peek()).compareTo(nextKey) < 0) {
            this.keyQueue.next();
        }
    }

    @Override
    public void close() {
    }

    @Override
    protected PrimaryKey computeNext() {
        return this.keyQueue.hasNext() ? (PrimaryKey)this.keyQueue.next() : (PrimaryKey)this.endOfData();
    }
}

