/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.internal.CollatedViewIndexBuilder;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;

public interface Index {
    public static final CollatedViewIndexBuildingSupport INDEX_BUILDER_SUPPORT = new CollatedViewIndexBuildingSupport();

    default public IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    default public IndexBuildingSupport getRecoveryTaskSupport() {
        return this.getBuildTaskSupport();
    }

    default public LoadType getSupportedLoadTypeOnFailure(boolean isInitialBuild) {
        return isInitialBuild ? LoadType.WRITE : LoadType.ALL;
    }

    public Callable<?> getInitializationTask();

    public IndexMetadata getIndexMetadata();

    public Callable<?> getMetadataReloadTask(IndexMetadata var1);

    public void register(IndexRegistry var1);

    default public void unregister(IndexRegistry registry) {
        registry.unregisterIndex(this, new Group.Key(this));
    }

    public Optional<ColumnFamilyStore> getBackingTable();

    default public Callable<?> getBlockingFlushTask(Memtable baseCfs) {
        return this.getBlockingFlushTask();
    }

    public Callable<?> getBlockingFlushTask();

    public Callable<?> getInvalidateTask();

    public Callable<?> getTruncateTask(long var1);

    default public Callable<?> getPreJoinTask(boolean hadBootstrap) {
        return null;
    }

    public boolean shouldBuildBlocking();

    default public boolean isSSTableAttached() {
        return false;
    }

    default public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker) {
        return null;
    }

    public boolean dependsOn(ColumnMetadata var1);

    public boolean supportsExpression(ColumnMetadata var1, Operator var2);

    default public boolean filtersMultipleContains() {
        return true;
    }

    public AbstractType<?> customExpressionValueType();

    public RowFilter getPostIndexQueryFilter(RowFilter var1);

    default public Comparator<ByteBuffer> getPostQueryOrdering(Restriction restriction, QueryOptions options) {
        return null;
    }

    public long getEstimatedResultRows();

    default public boolean isQueryable(Status status) {
        return true;
    }

    public void validate(PartitionUpdate var1, ClientState var2) throws InvalidRequestException;

    default public Set<Component> getComponents() {
        return Collections.emptySet();
    }

    public Indexer indexerFor(DecoratedKey var1, RegularAndStaticColumns var2, long var3, WriteContext var5, IndexTransaction.Type var6, Memtable var7);

    default public void validate(ReadCommand command) throws InvalidRequestException {
    }

    public Searcher searcherFor(ReadCommand var1);

    public static enum Status {
        UNKNOWN,
        FULL_REBUILD_STARTED,
        BUILD_FAILED,
        BUILD_SUCCEEDED,
        DROPPED;

    }

    public static interface QueryPlan
    extends Comparable<QueryPlan> {
        public Set<Index> getIndexes();

        @Nonnull
        default public Index getFirst() {
            return this.getIndexes().iterator().next();
        }

        default public long getEstimatedResultRows() {
            return this.getIndexes().stream().mapToLong(Index::getEstimatedResultRows).min().orElseThrow(AssertionError::new);
        }

        default public boolean shouldEstimateInitialConcurrency() {
            return true;
        }

        @Override
        default public int compareTo(QueryPlan other) {
            int results = Long.compare(this.getEstimatedResultRows(), other.getEstimatedResultRows());
            if (results != 0) {
                return results;
            }
            return Integer.compare(this.getIndexes().size(), other.getIndexes().size());
        }

        default public void validate(ReadCommand command) throws InvalidRequestException {
            this.getIndexes().forEach(i -> i.validate(command));
        }

        public Searcher searcherFor(ReadCommand var1);

        default public Function<PartitionIterator, PartitionIterator> postProcessor(ReadCommand command) {
            return partitions -> partitions;
        }

        public RowFilter postIndexQueryFilter();

        default public boolean supportsReplicaFilteringProtection(RowFilter rowFilter) {
            return true;
        }

        default public boolean isTopK() {
            return false;
        }
    }

    public static interface Group {
        public Set<Index> getIndexes();

        default public void addIndex(Index index) {
        }

        default public void removeIndex(Index index) {
        }

        public boolean containsIndex(Index var1);

        default public boolean isSingleton() {
            return true;
        }

        public Indexer indexerFor(Predicate<Index> var1, DecoratedKey var2, RegularAndStaticColumns var3, long var4, WriteContext var6, IndexTransaction.Type var7, Memtable var8);

        @Nullable
        public QueryPlan queryPlanFor(RowFilter var1);

        public SSTableFlushObserver getFlushObserver(Descriptor var1, LifecycleNewTracker var2, TableMetadata var3);

        default public boolean handles(IndexTransaction.Type type) {
            return true;
        }

        default public void invalidate() {
        }

        public Set<Component> getComponents();

        default public boolean validateSSTableAttachedIndexes(Collection<SSTableReader> sstables, boolean throwOnIncomplete, boolean validateChecksum) {
            return true;
        }

        public static class Key {
            private final Object object;

            public Key(Object object) {
                this.object = object;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Objects.equals(this.object, key.object);
            }

            public int hashCode() {
                return Objects.hash(this.object);
            }
        }
    }

    public static interface Searcher {
        public ReadCommand command();

        public UnfilteredPartitionIterator search(ReadExecutionController var1);

        default public PartitionIterator filterReplicaFilteringProtection(PartitionIterator fullResponse) {
            return this.command().rowFilter().filter(fullResponse, this.command().metadata(), this.command().nowInSec());
        }
    }

    public static interface Indexer {
        default public void begin() {
        }

        default public void partitionDelete(DeletionTime deletionTime) {
        }

        default public void rangeTombstone(RangeTombstone tombstone) {
        }

        default public void insertRow(Row row) {
        }

        default public void updateRow(Row oldRowData, Row newRowData) {
        }

        default public void removeRow(Row row) {
        }

        default public void finish() {
        }
    }

    public static class CollatedViewIndexBuildingSupport
    implements IndexBuildingSupport {
        @Override
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstables, boolean isFullRebuild) {
            return new CollatedViewIndexBuilder(cfs, indexes, new ReducingKeyIterator(sstables), sstables);
        }
    }

    public static interface IndexBuildingSupport {
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore var1, Set<Index> var2, Collection<SSTableReader> var3, boolean var4);
    }

    public static enum LoadType {
        READ,
        WRITE,
        ALL,
        NOOP;


        public boolean supportsWrites() {
            return this == ALL || this == WRITE;
        }

        public boolean supportsReads() {
            return this == ALL || this == READ;
        }
    }
}

