/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnfilteredValidation {
    private static final Logger logger = LoggerFactory.getLogger(UnfilteredValidation.class);
    private static final NoSpamLogger nospam1m = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);

    public static void maybeValidateUnfiltered(Unfiltered unfiltered, TableMetadata metadata, DecoratedKey key, SSTableReader sstable) {
        Config.CorruptedTombstoneStrategy strat = DatabaseDescriptor.getCorruptedTombstoneStrategy();
        if (strat != Config.CorruptedTombstoneStrategy.disabled && unfiltered != null && !unfiltered.isEmpty()) {
            boolean hasInvalidDeletions = false;
            try {
                hasInvalidDeletions = unfiltered.hasInvalidDeletions();
            }
            catch (Throwable t) {
                nospam1m.error("Could not check if Unfiltered in {} had any invalid deletions", sstable, t);
            }
            if (hasInvalidDeletions) {
                Object content;
                try {
                    content = unfiltered.toString(metadata, true);
                }
                catch (Throwable t) {
                    content = "Could not get string representation: " + t.getMessage();
                }
                UnfilteredValidation.handleInvalid(metadata, key, sstable, (String)content);
            }
        }
    }

    public static void handleInvalid(TableMetadata metadata, DecoratedKey key, SSTableReader sstable, String invalidContent) {
        Object keyString;
        Config.CorruptedTombstoneStrategy strat = DatabaseDescriptor.getCorruptedTombstoneStrategy();
        try {
            keyString = metadata.partitionKeyType.getString(key.getKey());
        }
        catch (Throwable t) {
            keyString = "[corrupt token=" + key.getToken() + "]";
        }
        if (strat == Config.CorruptedTombstoneStrategy.exception) {
            String msg = String.format("Key %s in %s.%s is invalid in %s: %s", keyString, metadata.keyspace, metadata.name, sstable, invalidContent);
            sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)new MarshalException(msg), sstable.getFilename());
        }
        if (strat == Config.CorruptedTombstoneStrategy.warn) {
            String msgTemplate = String.format("Key {} in %s.%s is invalid in %s: {}", metadata.keyspace, metadata.name, sstable);
            nospam1m.warn(msgTemplate, keyString, invalidContent);
        }
    }
}

