/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.UDFDataType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;

public final class FunctionArguments
implements Arguments {
    private static final FunctionArguments EMPTY = new FunctionArguments(ProtocolVersion.CURRENT, new ArgumentDeserializer[0]);
    private final ArgumentDeserializer[] deserializers;
    private final ProtocolVersion version;
    private final Object[] arguments;

    public static FunctionArguments newInstanceForUdf(ProtocolVersion version, List<UDFDataType> argTypes) {
        int size = argTypes.size();
        if (size == 0) {
            return FunctionArguments.emptyInstance(version);
        }
        ArgumentDeserializer[] deserializers = new ArgumentDeserializer[size];
        for (int i = 0; i < size; ++i) {
            deserializers[i] = argTypes.get(i).getArgumentDeserializer();
        }
        return new FunctionArguments(version, deserializers);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    public static FunctionArguments newNoopInstance(ProtocolVersion version, int numberOfArguments) {
        Object[] deserializers = new ArgumentDeserializer[numberOfArguments];
        Arrays.fill(deserializers, ArgumentDeserializer.NOOP_DESERIALIZER);
        return new FunctionArguments(version, (ArgumentDeserializer[])deserializers);
    }

    public static FunctionArguments emptyInstance(ProtocolVersion version) {
        if (version == ProtocolVersion.CURRENT) {
            return EMPTY;
        }
        return new FunctionArguments(version, new ArgumentDeserializer[0]);
    }

    public static FunctionArguments newInstanceForNativeFunction(ProtocolVersion version, List<AbstractType<?>> argTypes) {
        int size = argTypes.size();
        if (size == 0) {
            return FunctionArguments.emptyInstance(version);
        }
        ArgumentDeserializer[] deserializers = new ArgumentDeserializer[size];
        for (int i = 0; i < size; ++i) {
            deserializers[i] = argTypes.get(i).getArgumentDeserializer();
        }
        return new FunctionArguments(version, deserializers);
    }

    public FunctionArguments(ProtocolVersion version, ArgumentDeserializer ... deserializers) {
        this.version = version;
        this.deserializers = deserializers;
        this.arguments = new Object[deserializers.length];
    }

    @Override
    public void set(int i, ByteBuffer buffer) {
        this.arguments[i] = this.deserializers[i].deserialize(this.version, buffer);
    }

    @Override
    public boolean containsNulls() {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T get(int i) {
        return (T)this.arguments[i];
    }

    @Override
    public int size() {
        return this.arguments.length;
    }
}

