/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.auth.AuthConfig;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.MutualTlsCertificateValidator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class MutualTlsAuthenticator
implements IAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(MutualTlsAuthenticator.class);
    private static final NoSpamLogger nospamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final String VALIDATOR_CLASS_NAME = "validator_class_name";
    private static final String CACHE_NAME = "IdentitiesCache";
    private final IdentityCache identityCache = new IdentityCache();
    private final MutualTlsCertificateValidator certificateValidator;

    public MutualTlsAuthenticator(Map<String, String> parameters) {
        String certificateValidatorClassName = parameters.get(VALIDATOR_CLASS_NAME);
        if (StringUtils.isEmpty((CharSequence)certificateValidatorClassName)) {
            String message = "authenticator.parameters.validator_class_name is not set";
            logger.error(message);
            throw new ConfigurationException(message);
        }
        this.certificateValidator = (MutualTlsCertificateValidator)ParameterizedClass.newInstance(new ParameterizedClass(certificateValidatorClassName), Arrays.asList("", AuthConfig.class.getPackage().getName()));
        this.checkMtlsConfigurationIsValid(DatabaseDescriptor.getRawConfig());
        AuthCacheService.instance.register(this.identityCache);
    }

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public Set<? extends IResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table("system_auth", "roles"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        this.identityCache.warm();
    }

    @Override
    public IAuthenticator.SaslNegotiator newSaslNegotiator(InetAddress clientAddress) {
        return null;
    }

    @Override
    public IAuthenticator.SaslNegotiator newSaslNegotiator(InetAddress clientAddress, Certificate[] certificates) {
        return new CertificateNegotiator(certificates);
    }

    @Override
    public AuthenticatedUser legacyAuthenticate(Map<String, String> credentials) throws AuthenticationException {
        throw new AuthenticationException("mTLS authentication is not supported for CassandraLoginModule");
    }

    private void checkMtlsConfigurationIsValid(Config config) {
        if (!config.client_encryption_options.getEnabled().booleanValue() || !config.client_encryption_options.require_client_auth) {
            String msg = "MutualTlsAuthenticator requires client_encryption_options.enabled to be true & client_encryption_options.require_client_auth to be true";
            logger.error(msg);
            throw new ConfigurationException(msg);
        }
    }

    static class IdentityCache
    extends AuthCache<String, String> {
        IdentityCache() {
            super(MutualTlsAuthenticator.CACHE_NAME, DatabaseDescriptor::setCredentialsValidity, DatabaseDescriptor::getCredentialsValidity, DatabaseDescriptor::setCredentialsUpdateInterval, DatabaseDescriptor::getCredentialsUpdateInterval, DatabaseDescriptor::setCredentialsCacheMaxEntries, DatabaseDescriptor::getCredentialsCacheMaxEntries, DatabaseDescriptor::setCredentialsCacheActiveUpdate, DatabaseDescriptor::getCredentialsCacheActiveUpdate, identity -> DatabaseDescriptor.getRoleManager().roleForIdentity((String)identity), () -> DatabaseDescriptor.getRoleManager().authorizedIdentities(), () -> true, (k, v) -> v == null);
        }
    }

    @VisibleForTesting
    class CertificateNegotiator
    implements IAuthenticator.SaslNegotiator {
        private final Certificate[] clientCertificateChain;

        private CertificateNegotiator(Certificate[] clientCertificateChain) {
            this.clientCertificateChain = clientCertificateChain;
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            return null;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!MutualTlsAuthenticator.this.certificateValidator.isValidCertificate(this.clientCertificateChain)) {
                String message = "Invalid or not supported certificate";
                nospamLogger.error(message, new Object[0]);
                throw new AuthenticationException(message);
            }
            String identity = MutualTlsAuthenticator.this.certificateValidator.identity(this.clientCertificateChain);
            if (StringUtils.isEmpty((CharSequence)identity)) {
                String msg = "Unable to extract client identity from certificate for authentication";
                nospamLogger.error(msg, new Object[0]);
                throw new AuthenticationException(msg);
            }
            String role = (String)MutualTlsAuthenticator.this.identityCache.get(identity);
            if (role == null) {
                String msg = "Certificate identity '{}' not authorized";
                nospamLogger.error(msg, identity);
                throw new AuthenticationException(MessageFormatter.format((String)msg, (Object)identity).getMessage());
            }
            return new AuthenticatedUser(role);
        }
    }
}

