/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getsstables", description="Print the sstable filenames that own the key")
public class GetSSTables
extends NodeTool.NodeToolCmd {
    @Option(title="hex_format", name={"-hf", "--hex-format"}, description="Specify the key in hexadecimal string format")
    private boolean hexFormat = false;
    @Option(name={"-l", "--show-levels"}, description="If the table is using leveled compaction the level of each sstable will be included in the output (Default: false)")
    private boolean showLevels = false;
    @Arguments(usage="<keyspace> <cfname> <key>", description="The keyspace, the column family, and the key")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() == 3 ? 1 : 0) != 0, (Object)"getsstables requires ks, cf and key args");
        String ks = this.args.get(0);
        String cf = this.args.get(1);
        String key = this.args.get(2);
        if (this.showLevels && probe.isLeveledCompaction(ks, cf)) {
            Map<Integer, Set<String>> sstables = probe.getSSTablesWithLevel(ks, cf, key, this.hexFormat);
            for (Integer level : sstables.keySet()) {
                for (String sstable : sstables.get(level)) {
                    probe.output().out.println(level + ": " + sstable);
                }
            }
        } else {
            List<String> sstables = probe.getSSTables(ks, cf, key, this.hexFormat);
            for (String sstable : sstables) {
                probe.output().out.println(sstable);
            }
        }
    }
}

