/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ScheduledExecutorPlus;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSource;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IVerifier;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.StatsComponent;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CheckedFunction;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.BlockingQueues;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SelfRefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseable;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableReader
extends SSTable
implements UnfilteredSource,
SelfRefCounted<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final boolean TRACK_ACTIVITY = CassandraRelevantProperties.DISABLE_SSTABLE_ACTIVITY_TRACKING.getBoolean();
    private static final ScheduledExecutorPlus syncExecutor = SSTableReader.initSyncExecutor();
    private static final RateLimiter meterSyncThrottle = RateLimiter.create((double)100.0);
    public static final Comparator<SSTableReader> maxTimestampAscending = Comparator.comparingLong(SSTableReader::getMaxTimestamp);
    public static final Comparator<SSTableReader> maxTimestampDescending = maxTimestampAscending.reversed();
    public final UniqueIdentifier instanceId = new UniqueIdentifier();
    public static final Comparator<SSTableReader> firstKeyComparator = (o1, o2) -> o1.getFirst().compareTo(o2.getFirst());
    public static final Ordering<SSTableReader> firstKeyOrdering = Ordering.from(firstKeyComparator);
    public static final Comparator<SSTableReader> lastKeyComparator = (o1, o2) -> o1.getLast().compareTo(o2.getLast());
    public static final Comparator<SSTableReader> idComparator = Comparator.comparing(t -> t.descriptor.id, SSTableIdFactory.COMPARATOR);
    public static final Comparator<SSTableReader> idReverseComparator = idComparator.reversed();
    public static final Comparator<SSTableReader> sizeComparator = (o1, o2) -> Longs.compare((long)o1.onDiskLength(), (long)o2.onDiskLength());
    public final long maxDataAge;
    public final OpenReason openReason;
    protected final FileHandle dfile;
    public final AtomicBoolean isSuspect = new AtomicBoolean(false);
    protected volatile StatsMetadata sstableMetadata;
    public final SerializationHeader header;
    private final InstanceTidier tidy;
    private final Ref<SSTableReader> selfRef;
    private RestorableMeter readMeter;
    private volatile double crcCheckChance;
    protected final DecoratedKey first;
    protected final DecoratedKey last;
    public final AbstractBounds<Token> bounds;

    private static ScheduledExecutorPlus initSyncExecutor() {
        if (DatabaseDescriptor.isClientOrToolInitialized()) {
            return null;
        }
        ScheduledExecutorPlus syncExecutor = ExecutorFactory.Global.executorFactory().scheduled("read-hotness-tracker");
        if (syncExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)((Object)syncExecutor)).setRemoveOnCancelPolicy(true);
        }
        return syncExecutor;
    }

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        long count = -1L;
        if (Iterables.isEmpty(sstables)) {
            return count;
        }
        boolean failed = false;
        ICardinality cardinality = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.openReason == OpenReason.EARLY) continue;
            try {
                CompactionMetadata metadata = StatsComponent.load(sstable.descriptor).compactionMetadata();
                if (metadata == null) {
                    logger.warn("Reading cardinality from Statistics.db failed for {}", (Object)sstable.getFilename());
                    failed = true;
                    break;
                }
                if (cardinality == null) {
                    cardinality = metadata.cardinalityEstimator;
                    continue;
                }
                cardinality = cardinality.merge(new ICardinality[]{metadata.cardinalityEstimator});
            }
            catch (IOException e) {
                logger.warn("Reading cardinality from Statistics.db failed.", (Throwable)e);
                failed = true;
                break;
            }
            catch (CardinalityMergeException e) {
                logger.warn("Cardinality merge failed.", (Throwable)e);
                failed = true;
                break;
            }
        }
        if (cardinality != null && !failed) {
            count = cardinality.cardinality();
        }
        if (count < 0L) {
            count = 0L;
            for (SSTableReader sstable : sstables) {
                count += sstable.estimatedKeys();
            }
        }
        return count;
    }

    public static SSTableReader open(SSTable.Owner owner, Descriptor descriptor) {
        return SSTableReader.open(owner, descriptor, null);
    }

    public static SSTableReader open(SSTable.Owner owner, Descriptor desc, TableMetadataRef metadata) {
        return SSTableReader.open(owner, desc, null, metadata);
    }

    public static SSTableReader open(SSTable.Owner owner, Descriptor descriptor, Set<Component> components, TableMetadataRef metadata) {
        return SSTableReader.open(owner, descriptor, components, metadata, true, false);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, Set<Component> components, ColumnFamilyStore cfs) {
        return SSTableReader.open(cfs, descriptor, components, cfs.metadata, false, true);
    }

    public static SSTableReader openNoValidation(SSTable.Owner owner, Descriptor descriptor, TableMetadataRef metadata) {
        return SSTableReader.open(owner, descriptor, null, metadata, false, true);
    }

    public static SSTableReader openForBatch(SSTable.Owner owner, Descriptor descriptor, Set<Component> components, TableMetadataRef metadata) {
        return SSTableReader.open(owner, descriptor, components, metadata, true, true);
    }

    public static SSTableReader open(SSTable.Owner owner, Descriptor descriptor, Set<Component> components, TableMetadataRef metadata, boolean validate, boolean isOffline) {
        SSTableReaderLoadingBuilder<?, ?> builder = descriptor.getFormat().getReaderFactory().loadingBuilder(descriptor, metadata, components);
        return builder.build(owner, validate, !isOffline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SSTableReader> openAll(SSTable.Owner owner, Set<Map.Entry<Descriptor, Set<Component>>> entries, TableMetadataRef metadata) {
        BlockingQueue<SSTableReader> sstables = BlockingQueues.newBlockingQueue();
        Object executor = ExecutorFactory.Global.executorFactory().pooled("SSTableBatchOpen", FBUtilities.getAvailableProcessors());
        try {
            for (Map.Entry<Descriptor, Set<Component>> entry : entries) {
                Runnable runnable = () -> {
                    SSTableReader sstable;
                    try {
                        sstable = SSTableReader.open(owner, (Descriptor)entry.getKey(), (Set)entry.getValue(), metadata);
                    }
                    catch (CorruptSSTableException ex) {
                        JVMStabilityInspector.inspectThrowable(ex);
                        logger.error("Corrupt sstable {}; skipping table", (Object)entry, (Object)ex);
                        return;
                    }
                    catch (FSError ex) {
                        JVMStabilityInspector.inspectThrowable(ex);
                        logger.error("Cannot read sstable {}; file system error, skipping table", (Object)entry, (Object)ex);
                        return;
                    }
                    sstables.add(sstable);
                };
                executor.submit(runnable);
            }
        }
        finally {
            executor.shutdown();
        }
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        return sstables;
    }

    protected SSTableReader(Builder<?, ?> builder, SSTable.Owner owner) {
        super(builder, owner);
        this.sstableMetadata = builder.getStatsMetadata();
        this.header = builder.getSerializationHeader();
        this.dfile = builder.getDataFile();
        this.maxDataAge = builder.getMaxDataAge();
        this.openReason = builder.getOpenReason();
        this.first = builder.getFirst();
        this.last = builder.getLast();
        this.bounds = this.first == null || this.last == null || AbstractBounds.strictlyWrapsAround(this.first.getToken(), this.last.getToken()) ? null : AbstractBounds.bounds(this.first.getToken(), true, this.last.getToken(), true);
        this.tidy = new InstanceTidier(this.descriptor, owner);
        this.selfRef = new Ref<SSTableReader>(this, this.tidy);
    }

    @Override
    public DecoratedKey getFirst() {
        return this.first;
    }

    @Override
    public DecoratedKey getLast() {
        return this.last;
    }

    @Override
    public AbstractBounds<Token> getBounds() {
        return Objects.requireNonNull(this.bounds, "Bounds were not created because the sstable is out of order");
    }

    public DataIntegrityMetadata.ChecksumValidator maybeGetChecksumValidator() throws IOException {
        if (this.descriptor.fileFor(SSTableFormat.Components.CRC).exists()) {
            return new DataIntegrityMetadata.ChecksumValidator(this.descriptor.fileFor(SSTableFormat.Components.DATA), this.descriptor.fileFor(SSTableFormat.Components.CRC));
        }
        return null;
    }

    public DataIntegrityMetadata.FileDigestValidator maybeGetDigestValidator() throws IOException {
        if (this.descriptor.fileFor(SSTableFormat.Components.DIGEST).exists()) {
            return new DataIntegrityMetadata.FileDigestValidator(this.descriptor.fileFor(SSTableFormat.Components.DATA), this.descriptor.fileFor(SSTableFormat.Components.DIGEST));
        }
        return null;
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.onDiskLength();
        }
        return sum;
    }

    public static long getTotalUncompressedBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.uncompressedLength();
        }
        return sum;
    }

    public boolean equals(Object that) {
        return that instanceof SSTableReader && ((SSTableReader)that).descriptor.equals(this.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public String getFilename() {
        return this.dfile.path();
    }

    public void setupOnline() {
        this.owner().ifPresent(o -> this.setCrcCheckChance(o.getCrcCheckChance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, E extends Exception> R runWithLock(CheckedFunction<Descriptor, R, E> task) throws E {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            return task.apply(this.descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplaced() {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (!this.tidy.isReplaced);
            this.tidy.isReplaced = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplaced() {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            return this.tidy.isReplaced;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnClose(Runnable runOnClose) {
        if (runOnClose == null) {
            return;
        }
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            Runnable existing = this.tidy.runOnClose;
            this.tidy.runOnClose = existing == null ? runOnClose : () -> {
                existing.run();
                runOnClose.run();
            };
        }
    }

    @Override
    protected final <B extends Builder<?, B>> B unbuildTo(B builder, boolean sharedCopy) {
        B b = super.unbuildTo(builder, sharedCopy);
        if (builder.getDataFile() == null) {
            b.setDataFile(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.dfile) : this.dfile);
        }
        b.setStatsMetadata(this.sstableMetadata);
        b.setSerializationHeader(this.header);
        b.setMaxDataAge(this.maxDataAge);
        b.setOpenReason(this.openReason);
        b.setFirst(this.first);
        b.setLast(this.last);
        b.setSuspected(this.isSuspect.get());
        return b;
    }

    public abstract SSTableReader cloneWithRestoredStart(DecoratedKey var1);

    public abstract SSTableReader cloneWithNewStart(DecoratedKey var1);

    public RestorableMeter getReadMeter() {
        return this.readMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeInternalComponent(AutoCloseable closeable) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            boolean removed = this.tidy.closeables.remove(closeable);
            Preconditions.checkState((boolean)removed);
            try {
                closeable.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to close " + closeable, ex);
            }
        }
    }

    public abstract void releaseInMemoryComponents();

    public void validate() {
        if (this.first.compareTo(this.last) > 0 || this.bounds == null) {
            throw new CorruptSSTableException((Throwable)new IllegalStateException(String.format("SSTable first key %s > last key %s", this.first, this.last)), this.getFilename());
        }
    }

    public CompressionMetadata getCompressionMetadata() {
        if (!this.compression) {
            throw new IllegalStateException(this + " is not compressed");
        }
        return this.dfile.compressionMetadata().get();
    }

    public long getCompressionMetadataOffHeapSize() {
        if (!this.compression) {
            return 0L;
        }
        return this.getCompressionMetadata().offHeapSize();
    }

    public abstract long estimatedKeys();

    public abstract long estimatedKeysForRanges(Collection<Range<Token>> var1);

    public abstract boolean isEstimationInformative();

    public abstract Iterable<DecoratedKey> getKeySamples(Range<Token> var1);

    public List<PartitionPositionBounds> getPositionsForRanges(Collection<Range<Token>> ranges) {
        ArrayList<PartitionPositionBounds> positions = new ArrayList<PartitionPositionBounds>();
        for (Range<Token> range : Range.normalize(ranges)) {
            long right;
            PartitionPosition rightBound;
            assert (!range.isWrapAround() || ((Token)range.right).isMinimum());
            Range<PartitionPosition> bounds = Range.makeRowRange(range);
            PartitionPosition leftBound = ((PartitionPosition)bounds.left).compareTo(this.first) > 0 ? (PartitionPosition)bounds.left : this.first.getToken().minKeyBound();
            PartitionPosition partitionPosition = rightBound = ((PartitionPosition)bounds.right).isMinimum() ? this.last.getToken().maxKeyBound() : (PartitionPosition)bounds.right;
            if (leftBound.compareTo(this.last) > 0 || rightBound.compareTo(this.first) < 0) continue;
            long left = this.getPosition(leftBound, Operator.GT);
            if (left == (right = rightBound.compareTo(this.last) > 0 ? this.uncompressedLength() : this.getPosition(rightBound, Operator.GT))) continue;
            assert (left < right) : String.format("Range=%s openReason=%s first=%s last=%s left=%d right=%d", new Object[]{range, this.openReason, this.first, this.last, left, right});
            positions.add(new PartitionPositionBounds(left, right));
        }
        return positions;
    }

    public final long getPosition(PartitionPosition key, Operator op) {
        return this.getPosition(key, op, SSTableReadsListener.NOOP_LISTENER);
    }

    public final long getPosition(PartitionPosition key, Operator op, SSTableReadsListener listener) {
        return this.getPosition(key, op, true, listener);
    }

    public final long getPosition(PartitionPosition key, Operator op, boolean updateStats) {
        return this.getPosition(key, op, updateStats, SSTableReadsListener.NOOP_LISTENER);
    }

    protected long getPosition(PartitionPosition key, Operator op, boolean updateStats, SSTableReadsListener listener) {
        AbstractRowIndexEntry rie = this.getRowIndexEntry(key, op, updateStats, listener);
        return rie != null ? rie.position : -1L;
    }

    @VisibleForTesting
    protected abstract AbstractRowIndexEntry getRowIndexEntry(PartitionPosition var1, Operator var2, boolean var3, SSTableReadsListener var4);

    public UnfilteredRowIterator simpleIterator(FileDataInput file, DecoratedKey key, long dataPosition, boolean tombstoneOnly) {
        return SSTableIdentityIterator.create(this, file, dataPosition, key, tombstoneOnly);
    }

    public abstract KeyReader keyReader() throws IOException;

    public KeyIterator keyIterator() throws IOException {
        return new KeyIterator(this.keyReader(), this.getPartitioner(), this.uncompressedLength(), new ReentrantReadWriteLock());
    }

    public abstract DecoratedKey firstKeyBeyond(PartitionPosition var1);

    public long uncompressedLength() {
        return this.dfile.dataLength();
    }

    public double tokenSpaceCoverage() {
        return this.sstableMetadata.tokenSpaceCoverage;
    }

    public long onDiskLength() {
        return this.dfile.onDiskLength;
    }

    @VisibleForTesting
    public double getCrcCheckChance() {
        return this.crcCheckChance;
    }

    public void setCrcCheckChance(double crcCheckChance) {
        this.crcCheckChance = crcCheckChance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markObsolete(Runnable tidier) {
        if (logger.isTraceEnabled()) {
            logger.trace("Marking {} compacted", (Object)this.getFilename());
        }
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (!this.tidy.isReplaced);
            assert (this.tidy.global.obsoletion == null) : this + " was already marked compacted";
            this.tidy.global.obsoletion = tidier;
            this.tidy.global.stopReadMeterPersistence();
        }
    }

    public boolean isMarkedCompacted() {
        return this.tidy.global.obsoletion != null;
    }

    public void markSuspect() {
        if (logger.isTraceEnabled()) {
            logger.trace("Marking {} as a suspect to be excluded from reads.", (Object)this.getFilename());
        }
        this.isSuspect.getAndSet(true);
    }

    @VisibleForTesting
    public void unmarkSuspect() {
        this.isSuspect.getAndSet(false);
    }

    public boolean isMarkedSuspect() {
        return this.isSuspect.get();
    }

    public ISSTableScanner getScanner(Range<Token> range) {
        if (range == null) {
            return this.getScanner();
        }
        return this.getScanner(Collections.singletonList(range));
    }

    public abstract ISSTableScanner getScanner();

    public abstract ISSTableScanner getScanner(Collection<Range<Token>> var1);

    public abstract ISSTableScanner getScanner(Iterator<AbstractBounds<PartitionPosition>> var1);

    public FileDataInput getFileDataInput(long position) {
        return this.dfile.createReader(position);
    }

    public boolean newSince(long timestampMillis) {
        return this.maxDataAge > timestampMillis;
    }

    public void createLinks(String snapshotDirectoryPath) {
        this.createLinks(snapshotDirectoryPath, null);
    }

    public void createLinks(String snapshotDirectoryPath, RateLimiter rateLimiter) {
        SSTableReader.createLinks(this.descriptor, this.components, snapshotDirectoryPath, rateLimiter);
    }

    public static void createLinks(Descriptor descriptor, Set<Component> components, String snapshotDirectoryPath) {
        SSTableReader.createLinks(descriptor, components, snapshotDirectoryPath, null);
    }

    public static void createLinks(Descriptor descriptor, Set<Component> components, String snapshotDirectoryPath, RateLimiter limiter) {
        for (Component component : components) {
            File sourceFile = descriptor.fileFor(component);
            if (!sourceFile.exists()) continue;
            if (null != limiter) {
                limiter.acquire();
            }
            File targetLink = new File(snapshotDirectoryPath, sourceFile.name());
            FileUtils.createHardLink(sourceFile, targetLink);
        }
    }

    public boolean isRepaired() {
        return this.sstableMetadata.repairedAt != 0L;
    }

    public abstract DecoratedKey keyAtPositionFromSecondaryIndex(long var1) throws IOException;

    public boolean isPendingRepair() {
        return this.sstableMetadata.pendingRepair != ActiveRepairService.NO_PENDING_REPAIR;
    }

    public TimeUUID getPendingRepair() {
        return this.sstableMetadata.pendingRepair;
    }

    public long getRepairedAt() {
        return this.sstableMetadata.repairedAt;
    }

    public boolean isTransient() {
        return this.sstableMetadata.isTransient;
    }

    public boolean intersects(Collection<Range<Token>> ranges) {
        Bounds<Token> range = new Bounds<Token>(this.first.getToken(), this.last.getToken());
        return Iterables.any(ranges, r -> r.intersects(range));
    }

    public EstimatedHistogram getEstimatedPartitionSize() {
        return this.sstableMetadata.estimatedPartitionSize;
    }

    public EstimatedHistogram getEstimatedCellPerPartitionCount() {
        return this.sstableMetadata.estimatedCellPerPartitionCount;
    }

    public double getEstimatedDroppableTombstoneRatio(long gcBefore) {
        return this.sstableMetadata.getEstimatedDroppableTombstoneRatio(gcBefore);
    }

    public double getDroppableTombstonesBefore(long gcBefore) {
        return this.sstableMetadata.getDroppableTombstonesBefore(gcBefore);
    }

    public double getCompressionRatio() {
        return this.sstableMetadata.compressionRatio;
    }

    @Override
    public long getMinTimestamp() {
        return this.sstableMetadata.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.sstableMetadata.maxTimestamp;
    }

    @Override
    public long getMinLocalDeletionTime() {
        return this.sstableMetadata.minLocalDeletionTime;
    }

    public long getMaxLocalDeletionTime() {
        return this.sstableMetadata.maxLocalDeletionTime;
    }

    public boolean mayHaveTombstones() {
        return this.getMinLocalDeletionTime() != Long.MAX_VALUE;
    }

    public int getMinTTL() {
        return this.sstableMetadata.minTTL;
    }

    public int getMaxTTL() {
        return this.sstableMetadata.maxTTL;
    }

    public long getTotalColumnsSet() {
        return this.sstableMetadata.totalColumnsSet;
    }

    public long getTotalRows() {
        return this.sstableMetadata.totalRows;
    }

    public int getAvgColumnSetPerRow() {
        return this.sstableMetadata.totalRows < 0L ? -1 : (this.sstableMetadata.totalRows == 0L ? 0 : (int)(this.sstableMetadata.totalColumnsSet / this.sstableMetadata.totalRows));
    }

    public int getSSTableLevel() {
        return this.sstableMetadata.sstableLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateLevelAndReload(int newLevel) throws IOException {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            this.descriptor.getMetadataSerializer().mutateLevel(this.descriptor, newLevel);
            this.reloadSSTableMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateRepairedAndReload(long newRepairedAt, TimeUUID newPendingRepair, boolean isTransient) throws IOException {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            this.descriptor.getMetadataSerializer().mutateRepairMetadata(this.descriptor, newRepairedAt, newPendingRepair, isTransient);
            this.reloadSSTableMetadata();
        }
    }

    public void reloadSSTableMetadata() throws IOException {
        this.sstableMetadata = StatsComponent.load(this.descriptor).statsMetadata();
    }

    public StatsMetadata getSSTableMetadata() {
        return this.sstableMetadata;
    }

    public RandomAccessReader openDataReader(RateLimiter limiter) {
        assert (limiter != null);
        return this.dfile.createReader(limiter);
    }

    public RandomAccessReader openDataReader() {
        return this.dfile.createReader();
    }

    public void trySkipFileCacheBefore(DecoratedKey key) {
        long position = this.getPosition(key, Operator.GE);
        NativeLibrary.trySkipCache(this.descriptor.fileFor(SSTableFormat.Components.DATA).absolutePath(), 0L, position < 0L ? 0L : position);
    }

    public ChannelProxy getDataChannel() {
        return this.dfile.channel;
    }

    public long getDataCreationTime() {
        return this.descriptor.fileFor(SSTableFormat.Components.DATA).lastModified();
    }

    public void incrementReadCount() {
        if (this.readMeter != null) {
            this.readMeter.mark();
        }
    }

    public EncodingStats stats() {
        return this.sstableMetadata.encodingStats;
    }

    @Override
    public Ref<SSTableReader> tryRef() {
        return this.selfRef.tryRef();
    }

    @Override
    public Ref<SSTableReader> selfRef() {
        return this.selfRef;
    }

    @Override
    public Ref<SSTableReader> ref() {
        return this.selfRef.ref();
    }

    protected List<AutoCloseable> setupInstance(boolean trackHotness) {
        return Collections.singletonList(this.dfile);
    }

    public void setup(boolean trackHotness) {
        assert (this.tidy.closeables == null);
        this.tidy.setup(this, trackHotness &= TRACK_ACTIVITY, this.setupInstance(trackHotness));
        this.readMeter = this.tidy.global.readMeter;
    }

    @VisibleForTesting
    public void overrideReadMeter(RestorableMeter readMeter) {
        this.readMeter = this.tidy.global.readMeter = readMeter;
    }

    public void addTo(Ref.IdentityCollection identities) {
        identities.add(this);
        identities.add(this.tidy.globalRef);
        this.tidy.closeables.forEach(c -> {
            if (c instanceof SharedCloseable) {
                ((SharedCloseable)c).addTo(identities);
            }
        });
    }

    public abstract boolean mayContainAssumingKeyIsInRange(DecoratedKey var1);

    @VisibleForTesting
    public static void resetTidying() {
        GlobalTidy.lookup.clear();
    }

    public static SSTableReader moveAndOpenSSTable(ColumnFamilyStore cfs, Descriptor oldDescriptor, Descriptor newDescriptor, Set<Component> components, boolean copyData) {
        SSTableReader reader;
        if (!oldDescriptor.isCompatible()) {
            throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", oldDescriptor.getFormat().getLatestVersion(), oldDescriptor));
        }
        boolean isLive = cfs.getLiveSSTables().stream().anyMatch(r -> r.descriptor.equals(newDescriptor) || r.descriptor.equals(oldDescriptor));
        if (isLive) {
            String message = String.format("Can't move and open a file that is already in use in the table %s -> %s", oldDescriptor, newDescriptor);
            logger.error(message);
            throw new RuntimeException(message);
        }
        if (newDescriptor.fileFor(SSTableFormat.Components.DATA).exists()) {
            String msg = String.format("File %s already exists, can't move the file there", newDescriptor.fileFor(SSTableFormat.Components.DATA));
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        if (copyData) {
            try {
                logger.info("Hardlinking new SSTable {} to {}", (Object)oldDescriptor, (Object)newDescriptor);
                SSTableReader.hardlink(oldDescriptor, newDescriptor, components);
            }
            catch (FSWriteError ex) {
                logger.warn("Unable to hardlink new SSTable {} to {}, falling back to copying", new Object[]{oldDescriptor, newDescriptor, ex});
                SSTableReader.copy(oldDescriptor, newDescriptor, components);
            }
        } else {
            logger.info("Moving new SSTable {} to {}", (Object)oldDescriptor, (Object)newDescriptor);
            SSTableReader.rename(oldDescriptor, newDescriptor, components);
        }
        try {
            reader = SSTableReader.open(cfs, newDescriptor, components, cfs.metadata);
        }
        catch (Throwable t) {
            logger.error("Aborting import of sstables. {} was corrupt", (Object)newDescriptor);
            throw new RuntimeException(newDescriptor + " is corrupt, can't import", t);
        }
        return reader;
    }

    public static void shutdownBlocking(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, syncExecutor);
        SSTableReader.resetTidying();
    }

    public long bytesOnDisk() {
        return this.bytesOnDisk(false);
    }

    public long logicalBytesOnDisk() {
        return this.bytesOnDisk(true);
    }

    private long bytesOnDisk(boolean logical) {
        long bytes = 0L;
        for (Component component : this.components) {
            bytes += logical && component == SSTableFormat.Components.DATA && this.compression ? this.getCompressionMetadata().dataLength : this.descriptor.fileFor(component).length();
        }
        return bytes;
    }

    @VisibleForTesting
    public void maybePersistSSTableReadMeter() {
        this.tidy.global.maybePersistSSTableReadMeter();
    }

    public abstract IVerifier getVerifier(ColumnFamilyStore var1, OutputHandler var2, boolean var3, IVerifier.Options var4);

    protected void notifySelected(SSTableReadsListener.SelectionReason reason, SSTableReadsListener localListener, Operator op, boolean updateStats, AbstractRowIndexEntry entry) {
        reason.trace(this.descriptor, entry);
        if (localListener != null) {
            localListener.onSSTableSelected(this, reason);
        }
    }

    protected void notifySkipped(SSTableReadsListener.SkippingReason reason, SSTableReadsListener localListener, Operator op, boolean updateStats) {
        reason.trace(this.descriptor);
        if (localListener != null) {
            localListener.onSSTableSkipped(this, reason);
        }
    }

    public static abstract class Builder<R extends SSTableReader, B extends Builder<R, B>>
    extends SSTable.Builder<R, B> {
        private long maxDataAge;
        private StatsMetadata statsMetadata;
        private OpenReason openReason;
        private SerializationHeader serializationHeader;
        private FileHandle dataFile;
        private DecoratedKey first;
        private DecoratedKey last;
        private boolean suspected;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        public B setMaxDataAge(long maxDataAge) {
            Preconditions.checkArgument((maxDataAge >= 0L ? 1 : 0) != 0);
            this.maxDataAge = maxDataAge;
            return (B)this;
        }

        public B setStatsMetadata(StatsMetadata statsMetadata) {
            Preconditions.checkNotNull((Object)statsMetadata);
            this.statsMetadata = statsMetadata;
            return (B)this;
        }

        public B setOpenReason(OpenReason openReason) {
            Preconditions.checkNotNull((Object)((Object)openReason));
            this.openReason = openReason;
            return (B)this;
        }

        public B setSerializationHeader(SerializationHeader serializationHeader) {
            this.serializationHeader = serializationHeader;
            return (B)this;
        }

        public B setDataFile(FileHandle dataFile) {
            this.dataFile = dataFile;
            return (B)this;
        }

        public B setFirst(DecoratedKey first) {
            this.first = first != null ? first.retainable() : null;
            return (B)this;
        }

        public B setLast(DecoratedKey last) {
            this.last = last != null ? last.retainable() : null;
            return (B)this;
        }

        public B setSuspected(boolean suspected) {
            this.suspected = suspected;
            return (B)this;
        }

        public long getMaxDataAge() {
            return this.maxDataAge;
        }

        public StatsMetadata getStatsMetadata() {
            return this.statsMetadata;
        }

        public OpenReason getOpenReason() {
            return this.openReason;
        }

        public SerializationHeader getSerializationHeader() {
            return this.serializationHeader;
        }

        public FileHandle getDataFile() {
            return this.dataFile;
        }

        public DecoratedKey getFirst() {
            return this.first;
        }

        public DecoratedKey getLast() {
            return this.last;
        }

        public boolean isSuspected() {
            return this.suspected;
        }

        protected abstract R buildInternal(SSTable.Owner var1);

        public R build(SSTable.Owner owner, boolean validate, boolean online) {
            R reader = this.buildInternal(owner);
            try {
                if (this.isSuspected()) {
                    ((SSTableReader)reader).markSuspect();
                }
                ((SSTableReader)reader).setup(online);
                if (validate) {
                    ((SSTableReader)reader).validate();
                }
            }
            catch (Error | RuntimeException ex) {
                JVMStabilityInspector.inspectThrowable(ex);
                ((SSTableReader)reader).selfRef().release();
                throw ex;
            }
            return reader;
        }
    }

    public static class IndexesBounds {
        public final int lowerPosition;
        public final int upperPosition;

        public IndexesBounds(int lower, int upper) {
            this.lowerPosition = lower;
            this.upperPosition = upper;
        }

        public final int hashCode() {
            return 31 * this.lowerPosition * this.upperPosition;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof IndexesBounds)) {
                return false;
            }
            IndexesBounds that = (IndexesBounds)o;
            return this.lowerPosition == that.lowerPosition && this.upperPosition == that.upperPosition;
        }
    }

    public static class PartitionPositionBounds {
        public final long lowerPosition;
        public final long upperPosition;

        public PartitionPositionBounds(long lower, long upper) {
            this.lowerPosition = lower;
            this.upperPosition = upper;
        }

        public final int hashCode() {
            int hashCode = (int)this.lowerPosition ^ (int)(this.lowerPosition >>> 32);
            return 31 * (hashCode ^ (int)((long)((int)this.upperPosition) ^ this.upperPosition >>> 32));
        }

        public final boolean equals(Object o) {
            if (!(o instanceof PartitionPositionBounds)) {
                return false;
            }
            PartitionPositionBounds that = (PartitionPositionBounds)o;
            return this.lowerPosition == that.lowerPosition && this.upperPosition == that.upperPosition;
        }
    }

    static final class GlobalTidy
    implements RefCounted.Tidy {
        static final WeakReference<ScheduledFuture<?>> NULL = new WeakReference<Object>(null);
        static final ConcurrentMap<Descriptor, Ref<GlobalTidy>> lookup = new ConcurrentHashMap<Descriptor, Ref<GlobalTidy>>();
        private final Descriptor desc;
        private RestorableMeter readMeter;
        private WeakReference<ScheduledFuture<?>> readMeterSyncFuture = NULL;
        private volatile Runnable obsoletion;

        GlobalTidy(SSTableReader reader) {
            this.desc = reader.descriptor;
        }

        void ensureReadMeter() {
            if (this.readMeter != null) {
                return;
            }
            if (!TRACK_ACTIVITY || SchemaConstants.isLocalSystemKeyspace(this.desc.ksname) || DatabaseDescriptor.isClientOrToolInitialized()) {
                this.readMeter = null;
                this.readMeterSyncFuture = NULL;
                return;
            }
            this.readMeter = SystemKeyspace.getSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.id);
            this.readMeterSyncFuture = new WeakReference(syncExecutor.scheduleAtFixedRate(this::maybePersistSSTableReadMeter, 1L, 5L, TimeUnit.MINUTES));
        }

        void maybePersistSSTableReadMeter() {
            if (this.obsoletion == null && DatabaseDescriptor.getSStableReadRatePersistenceEnabled()) {
                meterSyncThrottle.acquire();
                SystemKeyspace.persistSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.id, this.readMeter);
            }
        }

        private void stopReadMeterPersistence() {
            ScheduledFuture readMeterSyncFutureLocal = (ScheduledFuture)this.readMeterSyncFuture.get();
            if (readMeterSyncFutureLocal != null) {
                readMeterSyncFutureLocal.cancel(true);
                this.readMeterSyncFuture = NULL;
            }
        }

        @Override
        public void tidy() {
            lookup.remove(this.desc);
            if (this.obsoletion != null) {
                this.obsoletion.run();
            }
            for (Component c : this.desc.discoverComponents()) {
                NativeLibrary.trySkipCache(this.desc.fileFor(c).absolutePath(), 0L, 0L);
            }
        }

        @Override
        public String name() {
            return this.desc.toString();
        }

        public static Ref<GlobalTidy> get(SSTableReader sstable) {
            Descriptor descriptor = sstable.descriptor;
            while (true) {
                Ref<GlobalTidy> newRef;
                Ref<GlobalTidy> ref;
                if ((ref = (Ref<GlobalTidy>)lookup.get(descriptor)) == null) {
                    GlobalTidy tidy = new GlobalTidy(sstable);
                    ref = new Ref<GlobalTidy>(tidy, tidy);
                    Ref<GlobalTidy> ex = lookup.putIfAbsent(descriptor, ref);
                    if (ex == null) {
                        return ref;
                    }
                    ref = ex;
                }
                if ((newRef = ref.tryRef()) != null) {
                    return newRef;
                }
                lookup.remove(descriptor, ref);
            }
        }
    }

    protected static final class InstanceTidier
    implements RefCounted.Tidy {
        private final Descriptor descriptor;
        private final WeakReference<SSTable.Owner> owner;
        private List<? extends AutoCloseable> closeables;
        private Runnable runOnClose;
        private boolean isReplaced = false;
        private Ref<GlobalTidy> globalRef;
        private GlobalTidy global;
        private volatile boolean setup;

        public void setup(SSTableReader reader, boolean trackHotness, Collection<? extends AutoCloseable> closeables) {
            this.globalRef = GlobalTidy.get(reader);
            this.global = this.globalRef.get();
            if (trackHotness) {
                this.global.ensureReadMeter();
            }
            this.closeables = new ArrayList<AutoCloseable>(closeables);
            this.setup = true;
        }

        private InstanceTidier(Descriptor descriptor, SSTable.Owner owner) {
            this.descriptor = descriptor;
            this.owner = new WeakReference<SSTable.Owner>(owner);
        }

        @Override
        public void tidy() {
            OpOrder.Barrier barrier;
            if (logger.isTraceEnabled()) {
                logger.trace("Running instance tidier for {} with setup {}", (Object)this.descriptor, (Object)this.setup);
            }
            if (!this.setup) {
                return;
            }
            SSTable.Owner owner = (SSTable.Owner)this.owner.get();
            if (owner != null) {
                barrier = owner.newReadOrderingBarrier();
                barrier.issue();
            } else {
                barrier = null;
            }
            ScheduledExecutors.nonPeriodicTasks.execute(new Runnable(){

                @Override
                public void run() {
                    Throwable closeExceptions;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, before barrier", (Object)descriptor);
                    }
                    if (barrier != null) {
                        barrier.await();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, after barrier", (Object)descriptor);
                    }
                    Throwable exceptions = null;
                    if (runOnClose != null) {
                        try {
                            runOnClose.run();
                        }
                        catch (Error | RuntimeException ex) {
                            logger.error("Failed to run on-close listeners for sstable " + descriptor.baseFile(), ex);
                            exceptions = ex;
                        }
                    }
                    if ((closeExceptions = Throwables.close(null, Iterables.filter(closeables, Objects::nonNull))) != null) {
                        logger.error("Failed to close some sstable components of " + descriptor.baseFile(), closeExceptions);
                        exceptions = Throwables.merge(exceptions, closeExceptions);
                    }
                    try {
                        globalRef.release();
                    }
                    catch (Error | RuntimeException ex) {
                        logger.error("Failed to release the global ref of " + descriptor.baseFile(), ex);
                        exceptions = Throwables.merge(exceptions, ex);
                    }
                    if (exceptions != null) {
                        JVMStabilityInspector.inspectThrowable(exceptions);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, completed", (Object)descriptor);
                    }
                }

                public String toString() {
                    return "Tidy " + descriptor.ksname + "." + descriptor.cfname + "-" + descriptor.id;
                }
            });
        }

        @Override
        public String name() {
            return this.descriptor.toString();
        }
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : 1;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }

    public static enum OpenReason {
        NORMAL,
        EARLY,
        METADATA_CHANGE,
        MOVED_START;

    }

    public static final class UniqueIdentifier {
    }
}

