/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.TimeWindowCompactionController;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class TimeWindowCompactionTask
extends CompactionTask {
    private final boolean ignoreOverlaps;

    public TimeWindowCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, long gcBefore, boolean ignoreOverlaps) {
        super(cfs, txn, gcBefore);
        this.ignoreOverlaps = ignoreOverlaps;
    }

    @Override
    public CompactionController getCompactionController(Set<SSTableReader> toCompact) {
        return new TimeWindowCompactionController(this.cfs, toCompact, this.gcBefore, this.ignoreOverlaps);
    }
}

