/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.selection.AggregateFunctionSelector;
import org.apache.cassandra.cql3.selection.ScalarFunctionSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.selection.TermSelector;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.text.StrBuilder;

abstract class AbstractFunctionSelector<T extends Function>
extends Selector {
    protected final T fun;
    private final Arguments args;
    protected final List<Selector> argSelectors;

    public static Selector.Factory newFactory(final Function fun, final SelectorFactories factories) throws InvalidRequestException {
        if (fun.isAggregate() && factories.doesAggregation()) {
            throw new InvalidRequestException("aggregate functions cannot be used as arguments of aggregate functions");
        }
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return fun.columnName(factories.getColumnNames());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return fun.returnType();
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Selector.Factory factory : factories) {
                    factory.addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get((Object)resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnMetadata)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                fun.addFunctionsTo(functions);
                factories.addFunctionsTo(functions);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                return fun.isAggregate() ? new AggregateFunctionSelector(options.getProtocolVersion(), fun, factories.newInstances(options)) : this.createScalarSelector(options, (ScalarFunction)fun, factories.newInstances(options));
            }

            private Selector createScalarSelector(QueryOptions options, ScalarFunction function, List<Selector> argSelectors) {
                ProtocolVersion version = options.getProtocolVersion();
                int terminalCount = 0;
                ArrayList<ByteBuffer> terminalArgs = new ArrayList<ByteBuffer>(argSelectors.size());
                for (Selector selector : argSelectors) {
                    if (selector.isTerminal()) {
                        ++terminalCount;
                        ByteBuffer output = selector.getOutput(version);
                        RequestValidations.checkBindValueSet(output, "Invalid unset value for argument in call to function %s", fun.name().name);
                        terminalArgs.add(output);
                        continue;
                    }
                    terminalArgs.add(Function.UNRESOLVED);
                }
                if (terminalCount == 0) {
                    return new ScalarFunctionSelector(version, fun, argSelectors);
                }
                ScalarFunction partialFunction = function.partialApplication(version, terminalArgs);
                if (terminalCount == argSelectors.size() && fun.isPure()) {
                    Arguments arguments = partialFunction.newArguments(version);
                    return new TermSelector(partialFunction.execute(arguments), partialFunction.returnType());
                }
                ArrayList<Selector> remainingSelectors = new ArrayList<Selector>(argSelectors.size() - terminalCount);
                for (Selector selector : argSelectors) {
                    if (selector.isTerminal()) continue;
                    remainingSelectors.add(selector);
                }
                return new ScalarFunctionSelector(version, partialFunction, remainingSelectors);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return factories.containsWritetimeSelectorFactory();
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return factories.containsTTLSelectorFactory();
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return fun.isAggregate() || factories.doesAggregation();
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return Iterables.all((Iterable)factories, f -> f.areAllFetchedColumnsKnown());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                for (Selector.Factory factory : factories) {
                    factory.addFetchedColumns(builder);
                }
            }
        };
    }

    protected AbstractFunctionSelector(Selector.Kind kind, ProtocolVersion version, T fun, List<Selector> argSelectors) {
        super(kind);
        this.fun = fun;
        this.argSelectors = argSelectors;
        this.args = fun.newArguments(version);
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        for (Selector selector : this.argSelectors) {
            selector.addFetchedColumns(builder);
        }
    }

    protected void setArg(int i, ByteBuffer value) throws InvalidRequestException {
        RequestValidations.checkBindValueSet(value, "Invalid unset value for argument in call to function %s", this.fun.name().name);
        this.args.set(i, value);
    }

    protected Arguments args() {
        return this.args;
    }

    @Override
    public AbstractType<?> getType() {
        return this.fun.returnType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFunctionSelector)) {
            return false;
        }
        AbstractFunctionSelector s = (AbstractFunctionSelector)o;
        return Objects.equal((Object)this.fun.name(), (Object)s.fun.name()) && Objects.equal(this.fun.argTypes(), s.fun.argTypes()) && Objects.equal(this.argSelectors, s.argSelectors);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fun.name(), this.fun.argTypes(), this.argSelectors});
    }

    public String toString() {
        return new StrBuilder().append((Object)this.fun.name()).append("(").appendWithSeparators(this.argSelectors, ", ").append(")").toString();
    }

    @Override
    protected int serializedSize(int version) {
        int i;
        boolean isPartial = this.fun instanceof PartialScalarFunction;
        T function = isPartial ? ((PartialScalarFunction)this.fun).getFunction() : this.fun;
        FunctionName name = function.name();
        int size = TypeSizes.sizeof(name.keyspace) + TypeSizes.sizeof(name.name);
        List<AbstractType<?>> argTypes = function.argTypes();
        size += TypeSizes.sizeofUnsignedVInt(argTypes.size());
        int m = argTypes.size();
        for (int i2 = 0; i2 < m; ++i2) {
            size += AbstractFunctionSelector.sizeOf(argTypes.get(i2));
        }
        size += TypeSizes.sizeof(isPartial);
        if (isPartial) {
            List<ByteBuffer> partialArguments = ((PartialScalarFunction)this.fun).getPartialArguments();
            size += TypeSizes.sizeofUnsignedVInt(this.computeBitSet(partialArguments));
            int m2 = partialArguments.size();
            for (i = 0; i < m2; ++i) {
                ByteBuffer buffer = partialArguments.get(i);
                if (buffer == Function.UNRESOLVED) continue;
                size += ByteBufferUtil.serializedSizeWithVIntLength(buffer);
            }
        }
        int numberOfRemainingArguments = this.argSelectors.size();
        size += TypeSizes.sizeofUnsignedVInt(numberOfRemainingArguments);
        for (i = 0; i < numberOfRemainingArguments; ++i) {
            size += serializer.serializedSize(this.argSelectors.get(i), version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        int i;
        boolean isPartial = this.fun instanceof PartialScalarFunction;
        T function = isPartial ? ((PartialScalarFunction)this.fun).getFunction() : this.fun;
        FunctionName name = function.name();
        out.writeUTF(name.keyspace);
        out.writeUTF(name.name);
        List<AbstractType<?>> argTypes = function.argTypes();
        int numberOfArguments = argTypes.size();
        out.writeUnsignedVInt32(numberOfArguments);
        for (int i2 = 0; i2 < numberOfArguments; ++i2) {
            AbstractFunctionSelector.writeType(out, argTypes.get(i2));
        }
        out.writeBoolean(isPartial);
        if (isPartial) {
            List<ByteBuffer> partialArguments = ((PartialScalarFunction)this.fun).getPartialArguments();
            out.writeUnsignedVInt32(this.computeBitSet(partialArguments));
            int m = partialArguments.size();
            for (i = 0; i < m; ++i) {
                ByteBuffer buffer = partialArguments.get(i);
                if (buffer == Function.UNRESOLVED) continue;
                ByteBufferUtil.writeWithVIntLength(buffer, out);
            }
        }
        int numberOfRemainingArguments = this.argSelectors.size();
        out.writeUnsignedVInt32(numberOfRemainingArguments);
        for (i = 0; i < numberOfRemainingArguments; ++i) {
            serializer.serialize(this.argSelectors.get(i), out, version);
        }
    }

    private int computeBitSet(List<ByteBuffer> partialArguments) {
        assert (partialArguments.size() <= 32) : "cannot serialize partial function with more than 32 arguments";
        int bitset = 0;
        int m = partialArguments.size();
        for (int i = 0; i < m; ++i) {
            if (partialArguments.get(i) == Function.UNRESOLVED) continue;
            bitset |= 1 << i;
        }
        return bitset;
    }

    protected static abstract class AbstractFunctionSelectorDeserializer
    extends Selector.SelectorDeserializer {
        protected AbstractFunctionSelectorDeserializer() {
        }

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            int i;
            ProtocolVersion protocolVersion = ProtocolVersion.CURRENT;
            FunctionName name = new FunctionName(in.readUTF(), in.readUTF());
            int numberOfArguments = in.readUnsignedVInt32();
            ArrayList argTypes = new ArrayList(numberOfArguments);
            for (int i2 = 0; i2 < numberOfArguments; ++i2) {
                argTypes.add(this.readType(metadata, in));
            }
            Function function = FunctionResolver.get(metadata.keyspace, name, argTypes, metadata.keyspace, metadata.name, null);
            if (function == null) {
                throw new IOException(String.format("Unknown serialized function %s(%s)", name, argTypes.stream().map(p -> p.asCQL3Type().toString()).collect(Collectors.joining(", "))));
            }
            boolean isPartial = in.readBoolean();
            if (isPartial) {
                int bitset = in.readUnsignedVInt32();
                ArrayList<ByteBuffer> partialArguments = new ArrayList<ByteBuffer>(numberOfArguments);
                for (i = 0; i < numberOfArguments; ++i) {
                    boolean isArgumentResolved = this.getRightMostBit(bitset) == 1;
                    ByteBuffer argument = isArgumentResolved ? ByteBufferUtil.readWithVIntLength(in) : Function.UNRESOLVED;
                    partialArguments.add(argument);
                    bitset >>= 1;
                }
                function = ((ScalarFunction)function).partialApplication(protocolVersion, partialArguments);
            }
            int numberOfRemainingArguments = in.readUnsignedVInt32();
            ArrayList<Selector> argSelectors = new ArrayList<Selector>(numberOfRemainingArguments);
            for (i = 0; i < numberOfRemainingArguments; ++i) {
                argSelectors.add(Selector.serializer.deserialize(in, version, metadata));
            }
            return this.newFunctionSelector(protocolVersion, function, argSelectors);
        }

        private int getRightMostBit(int bitset) {
            return bitset & 1;
        }

        protected abstract Selector newFunctionSelector(ProtocolVersion var1, Function var2, List<Selector> var3);
    }
}

