/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.QualifiedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.CassandraException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CQLMetrics;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestsMetricsHolder;
import org.apache.cassandra.metrics.ClientWriteRequestMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaChangeListener;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
implements QueryHandler {
    public static final CassandraVersion CQL_VERSION = new CassandraVersion("3.4.7");
    public static final CassandraVersion NEW_PREPARED_STATEMENT_BEHAVIOUR_SINCE_40 = new CassandraVersion("4.0.2");
    public static final QueryProcessor instance = new QueryProcessor();
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final Cache<MD5Digest, QueryHandler.Prepared> preparedStatements;
    private static final ConcurrentMap<String, QueryHandler.Prepared> internalStatements;
    public static final CQLMetrics metrics;
    private static final AtomicInteger lastMinuteEvictionsCount;
    private volatile boolean newPreparedStatementBehaviour = false;

    private static long capacityToBytes(long cacheSizeMB) {
        return cacheSizeMB * 1024L * 1024L;
    }

    public static int preparedStatementsCount() {
        return preparedStatements.asMap().size();
    }

    public void preloadPreparedStatements() {
        long startTime = Clock.Global.nanoTime();
        int count = SystemKeyspace.loadPreparedStatements((id, query, keyspace) -> {
            try {
                ClientState clientState = ClientState.forInternalCalls();
                if (keyspace != null) {
                    clientState.setKeyspace((String)keyspace);
                }
                QueryHandler.Prepared prepared = QueryProcessor.parseAndPrepare(query, clientState, false);
                preparedStatements.put(id, (Object)prepared);
                if (!prepared.fullyQualified) {
                    preparedStatements.get((Object)QueryProcessor.computeId(query, null), ignored_ -> prepared);
                }
                return true;
            }
            catch (RequestValidationException e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Prepared statement recreation error, removing statement: {} {} {}, error details: {}", new Object[]{id, query, keyspace, e.getMessage()});
                SystemKeyspace.removePreparedStatement(id);
                return false;
            }
        });
        long endTime = Clock.Global.nanoTime();
        logger.info("Preloaded {} prepared statements in {} ms", (Object)count, (Object)TimeUnit.NANOSECONDS.toMillis(endTime - startTime));
    }

    @VisibleForTesting
    public static void clearPreparedStatements(boolean memoryOnly) {
        preparedStatements.invalidateAll();
        if (!memoryOnly) {
            SystemKeyspace.resetPreparedStatements();
        }
    }

    @VisibleForTesting
    public static ConcurrentMap<String, QueryHandler.Prepared> getInternalStatements() {
        return internalStatements;
    }

    @VisibleForTesting
    public static QueryState internalQueryState() {
        return new QueryState(InternalStateInstance.INSTANCE.clientState);
    }

    private QueryProcessor() {
        Schema.instance.registerListener(new StatementInvalidatingListener());
    }

    @VisibleForTesting
    public void evictPrepared(MD5Digest id) {
        preparedStatements.invalidate((Object)id);
        SystemKeyspace.removePreparedStatement(id);
    }

    public HashMap<MD5Digest, QueryHandler.Prepared> getPreparedStatements() {
        return new HashMap<MD5Digest, QueryHandler.Prepared>(preparedStatements.asMap());
    }

    @Override
    public QueryHandler.Prepared getPrepared(MD5Digest id) {
        return (QueryHandler.Prepared)preparedStatements.getIfPresent((Object)id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            throw new InvalidRequestException("Key may not be unset");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of 65535");
        }
    }

    public ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.authorize(clientState);
        statement.validate(clientState);
        ResultMessage result = options.getConsistency() == ConsistencyLevel.NODE_LOCAL ? this.processNodeLocalStatement(statement, queryState, options) : statement.execute(queryState, options, requestTime);
        return result == null ? new ResultMessage.Void() : result;
    }

    private ResultMessage processNodeLocalStatement(CQLStatement statement, QueryState queryState, QueryOptions options) {
        if (!CassandraRelevantProperties.ENABLE_NODELOCAL_QUERIES.getBoolean()) {
            throw new InvalidRequestException("NODE_LOCAL consistency level is highly dangerous and should be used only for debugging purposes");
        }
        if (statement instanceof BatchStatement || statement instanceof ModificationStatement) {
            return this.processNodeLocalWrite(statement, queryState, options);
        }
        if (statement instanceof SelectStatement) {
            return this.processNodeLocalSelect((SelectStatement)statement, queryState, options);
        }
        throw new InvalidRequestException("NODE_LOCAL consistency level can only be used with BATCH, UPDATE, INSERT, DELETE, and SELECT statements");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultMessage processNodeLocalWrite(CQLStatement statement, QueryState queryState, QueryOptions options) {
        ClientWriteRequestMetrics levelMetrics = ClientRequestsMetricsHolder.writeMetricsForLevel(ConsistencyLevel.NODE_LOCAL);
        ClientWriteRequestMetrics globalMetrics = ClientRequestsMetricsHolder.writeMetrics;
        long startTime = Clock.Global.nanoTime();
        try {
            ResultMessage resultMessage = statement.executeLocally(queryState, options);
            return resultMessage;
        }
        finally {
            long latency = Clock.Global.nanoTime() - startTime;
            levelMetrics.addNano(latency);
            globalMetrics.addNano(latency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultMessage processNodeLocalSelect(SelectStatement statement, QueryState queryState, QueryOptions options) {
        ClientRequestMetrics levelMetrics = ClientRequestsMetricsHolder.readMetricsForLevel(ConsistencyLevel.NODE_LOCAL);
        ClientRequestMetrics globalMetrics = ClientRequestsMetricsHolder.readMetrics;
        if (StorageService.instance.isBootstrapMode() && !SchemaConstants.isLocalSystemKeyspace(statement.keyspace())) {
            levelMetrics.unavailables.mark();
            globalMetrics.unavailables.mark();
            throw new IsBootstrappingException();
        }
        long startTime = Clock.Global.nanoTime();
        try {
            ResultMessage.Rows rows = statement.executeLocally(queryState, options);
            return rows;
        }
        finally {
            long latency = Clock.Global.nanoTime() - startTime;
            levelMetrics.addNano(latency);
            globalMetrics.addNano(latency);
        }
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        QueryOptions options = QueryOptions.forInternalCalls(cl, Collections.emptyList());
        CQLStatement statement = instance.parse(queryString, queryState, options);
        return instance.process(statement, queryState, options, requestTime);
    }

    @Override
    public CQLStatement parse(String queryString, QueryState queryState, QueryOptions options) {
        return QueryProcessor.getStatement(queryString, queryState.getClientState().cloneWithKeyspaceIfSet(options.getKeyspace()));
    }

    @Override
    public ResultMessage process(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        return this.process(statement, state, options, requestTime);
    }

    public ResultMessage process(CQLStatement prepared, QueryState queryState, QueryOptions options, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        options.prepare(prepared.getBindVariables());
        if (prepared.getBindVariables().size() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        if (!queryState.getClientState().isInternal) {
            QueryProcessor.metrics.regularStatementsExecuted.inc();
        }
        return this.processStatement(prepared, queryState, options, requestTime);
    }

    public static CQLStatement parseStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        return QueryProcessor.getStatement(queryStr, clientState);
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl, Collections.emptyList());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl, List<ByteBuffer> values) throws RequestExecutionException {
        QueryOptions options;
        QueryState queryState = QueryState.forInternalCalls();
        CQLStatement statement = instance.parse(query, queryState, options = QueryOptions.forInternalCalls(cl, values));
        ResultMessage result = instance.process(statement, queryState, options, Dispatcher.RequestTime.forImmediateExecution());
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    @VisibleForTesting
    public static QueryOptions makeInternalOptions(CQLStatement prepared, Object[] values) {
        return QueryProcessor.makeInternalOptions(prepared, values, ConsistencyLevel.ONE);
    }

    private static QueryOptions makeInternalOptions(CQLStatement prepared, Object[] values, ConsistencyLevel cl) {
        return QueryProcessor.makeInternalOptionsWithNowInSec(prepared, FBUtilities.nowInSeconds(), values, cl);
    }

    public static QueryOptions makeInternalOptionsWithNowInSec(CQLStatement prepared, long nowInSec, Object[] values) {
        return QueryProcessor.makeInternalOptionsWithNowInSec(prepared, nowInSec, values, ConsistencyLevel.ONE);
    }

    private static QueryOptions makeInternalOptionsWithNowInSec(CQLStatement prepared, long nowInSec, Object[] values, ConsistencyLevel cl) {
        if (prepared.getBindVariables().size() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", prepared.getBindVariables().size(), values.length));
        }
        ArrayList<ByteBuffer> boundValues = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            AbstractType<?> type = prepared.getBindVariables().get((int)i).type;
            boundValues.add(value instanceof ByteBuffer || value == null ? (ByteBuffer)value : type.decomposeUntyped(value));
        }
        return QueryOptions.forInternalCallsWithNowInSec(nowInSec, cl, boundValues);
    }

    public static QueryHandler.Prepared prepareInternal(String query) throws RequestValidationException {
        QueryHandler.Prepared prepared = (QueryHandler.Prepared)internalStatements.get(query);
        if (prepared != null) {
            return prepared;
        }
        prepared = QueryProcessor.parseAndPrepare(query, QueryProcessor.internalQueryState().getClientState(), true);
        internalStatements.put(query, prepared);
        return prepared;
    }

    public static QueryHandler.Prepared parseAndPrepare(String query, ClientState clientState, boolean isInternal) throws RequestValidationException {
        CQLStatement.Raw raw = QueryProcessor.parseStatement(query);
        boolean fullyQualified = false;
        String keyspace = null;
        if (raw instanceof QualifiedStatement) {
            QualifiedStatement qualifiedStatement = (QualifiedStatement)raw;
            fullyQualified = qualifiedStatement.isFullyQualified();
            qualifiedStatement.setKeyspace(clientState);
            keyspace = qualifiedStatement.keyspace();
        }
        CQLStatement statement = raw.prepare(clientState);
        statement.validate(clientState);
        if (isInternal) {
            return new QueryHandler.Prepared(statement, "", fullyQualified, keyspace);
        }
        return new QueryHandler.Prepared(statement, query, fullyQualified, keyspace);
    }

    public static UntypedResultSet executeInternal(String query, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        ResultMessage result = prepared.statement.executeLocally(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared.statement, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static Future<UntypedResultSet> executeAsync(InetAddressAndPort address, String query, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        long nowInSec = FBUtilities.nowInSeconds();
        QueryOptions options = QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, nowInSec, values);
        if (prepared.statement instanceof SelectStatement) {
            List<ReadQuery> commands;
            SelectStatement select = (SelectStatement)prepared.statement;
            ReadQuery readQuery = select.getQuery(options, nowInSec);
            if (readQuery instanceof ReadCommand) {
                commands = Collections.singletonList((ReadCommand)readQuery);
            } else if (readQuery instanceof SinglePartitionReadQuery.Group) {
                List<SinglePartitionReadQuery> queries = ((SinglePartitionReadQuery.Group)readQuery).queries;
                queries.forEach(a -> {
                    if (!(a instanceof ReadCommand)) {
                        throw new IllegalArgumentException("Queries found which are not ReadCommand: " + a.getClass());
                    }
                });
                commands = queries;
            } else {
                throw new IllegalArgumentException("Unable to handle; only expected ReadCommands but given " + readQuery.getClass());
            }
            Future<List<List>> future = FutureCombiner.allOf(commands.stream().map(rc -> Message.out(rc.verb(), rc)).map(m -> MessagingService.instance().sendWithResult(m, address)).collect(Collectors.toList()));
            ResultSetBuilder result = new ResultSetBuilder(select.getResultMetadata(), select.getSelection().newSelectors(options), false);
            return future.map(arg_0 -> QueryProcessor.lambda$executeAsync$7(commands, nowInSec, select, options, result, arg_0)).map(UntypedResultSet::create);
        }
        throw new IllegalArgumentException("Unable to execute query; only SELECT supported but given: " + query);
    }

    public static UntypedResultSet execute(String query, ConsistencyLevel cl, Object ... values) throws RequestExecutionException {
        return QueryProcessor.execute(query, cl, QueryProcessor.internalQueryState(), values);
    }

    public static UntypedResultSet executeInternalWithNowInSec(String query, long nowInSec, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        ResultMessage result = prepared.statement.executeLocally(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, nowInSec, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet execute(String query, ConsistencyLevel cl, QueryState state, Object ... values) throws RequestExecutionException {
        try {
            QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
            ResultMessage result = prepared.statement.execute(state, QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, state.getNowInSeconds(), values, cl), Dispatcher.RequestTime.forImmediateExecution());
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet executeInternalWithPaging(String query, int pageSize, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        if (!(prepared.statement instanceof SelectStatement)) {
            throw new IllegalArgumentException("Only SELECTs can be paged");
        }
        SelectStatement select = (SelectStatement)prepared.statement;
        long nowInSec = FBUtilities.nowInSeconds();
        QueryPager pager = select.getQuery(QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, nowInSec, values), nowInSec).getPager(null, ProtocolVersion.CURRENT);
        return UntypedResultSet.create(select, pager, pageSize);
    }

    public static UntypedResultSet executeOnceInternal(String query, Object ... values) {
        return QueryProcessor.executeOnceInternal(QueryProcessor.internalQueryState(), query, values);
    }

    @VisibleForTesting
    public static UntypedResultSet executeOnceInternalWithNowAndTimestamp(long nowInSec, long timestamp, String query, Object ... values) {
        QueryState queryState = new QueryState(InternalStateInstance.INSTANCE.clientState, timestamp, nowInSec);
        return QueryProcessor.executeOnceInternal(queryState, query, values);
    }

    private static UntypedResultSet executeOnceInternal(QueryState queryState, String query, Object ... values) {
        CQLStatement statement = QueryProcessor.parseStatement(query, queryState.getClientState());
        statement.validate(queryState.getClientState());
        ResultMessage result = statement.executeLocally(queryState, QueryProcessor.makeInternalOptionsWithNowInSec(statement, queryState.getNowInSeconds(), values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet executeInternalWithNow(long nowInSec, Dispatcher.RequestTime requestTime, String query, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        assert (prepared.statement instanceof SelectStatement);
        SelectStatement select = (SelectStatement)prepared.statement;
        ResultMessage.Rows result = select.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, nowInSec, values), nowInSec, requestTime);
        assert (result instanceof ResultMessage.Rows);
        return UntypedResultSet.create(result.result);
    }

    public static Map<DecoratedKey, List<Row>> executeInternalRawWithNow(long nowInSec, String query, Object ... values) {
        QueryHandler.Prepared prepared = QueryProcessor.prepareInternal(query);
        assert (prepared.statement instanceof SelectStatement);
        SelectStatement select = (SelectStatement)prepared.statement;
        return select.executeRawInternal(QueryProcessor.makeInternalOptionsWithNowInSec(prepared.statement, nowInSec, values), QueryProcessor.internalQueryState().getClientState(), nowInSec);
    }

    @VisibleForTesting
    public static UntypedResultSet resultify(String query, RowIterator partition) {
        return QueryProcessor.resultify(query, PartitionIterators.singletonIterator(partition));
    }

    @VisibleForTesting
    public static UntypedResultSet resultify(String query, PartitionIterator partitions) {
        try (PartitionIterator iter = partitions;){
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement(query, null);
            ResultSet cqlRows = ss.process(iter, FBUtilities.nowInSeconds(), true, ClientState.forInternalCalls());
            UntypedResultSet untypedResultSet = UntypedResultSet.create(cqlRows);
            return untypedResultSet;
        }
    }

    @Override
    public ResultMessage.Prepared prepare(String query, ClientState clientState, Map<String, ByteBuffer> customPayload) throws RequestValidationException {
        return this.prepare(query, clientState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useNewPreparedStatementBehaviour() {
        if (this.newPreparedStatementBehaviour || DatabaseDescriptor.getForceNewPreparedStatementBehaviour()) {
            return true;
        }
        QueryProcessor queryProcessor = this;
        synchronized (queryProcessor) {
            CassandraVersion minVersion = Gossiper.instance.getMinVersion(DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            if (minVersion != null && minVersion.compareTo(NEW_PREPARED_STATEMENT_BEHAVIOUR_SINCE_40, true) >= 0) {
                logger.info("Fully upgraded to at least {}", (Object)minVersion);
                this.newPreparedStatementBehaviour = true;
            }
            return this.newPreparedStatementBehaviour;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultMessage.Prepared prepare(String queryString, ClientState clientState) {
        boolean safeToReturnCached;
        boolean useNewPreparedStatementBehaviour = this.useNewPreparedStatementBehaviour();
        MD5Digest hashWithoutKeyspace = QueryProcessor.computeId(queryString, null);
        MD5Digest hashWithKeyspace = QueryProcessor.computeId(queryString, clientState.getRawKeyspace());
        QueryHandler.Prepared cachedWithoutKeyspace = (QueryHandler.Prepared)preparedStatements.getIfPresent((Object)hashWithoutKeyspace);
        QueryHandler.Prepared cachedWithKeyspace = (QueryHandler.Prepared)preparedStatements.getIfPresent((Object)hashWithKeyspace);
        boolean bl = safeToReturnCached = cachedWithoutKeyspace != null && cachedWithKeyspace != null;
        if (safeToReturnCached) {
            if (!useNewPreparedStatementBehaviour) return QueryProcessor.createResultMessage(hashWithKeyspace, cachedWithKeyspace);
            if (cachedWithoutKeyspace.fullyQualified) {
                return QueryProcessor.createResultMessage(hashWithoutKeyspace, cachedWithoutKeyspace);
            }
            if (clientState.getRawKeyspace() != null && !cachedWithKeyspace.fullyQualified) {
                return QueryProcessor.createResultMessage(hashWithKeyspace, cachedWithKeyspace);
            }
        } else {
            this.evictPrepared(hashWithKeyspace);
            this.evictPrepared(hashWithoutKeyspace);
        }
        QueryHandler.Prepared prepared = QueryProcessor.parseAndPrepare(queryString, clientState, false);
        CQLStatement statement = prepared.statement;
        int boundTerms = statement.getBindVariables().size();
        if (boundTerms > 65535) {
            throw new InvalidRequestException(String.format("Too many markers(?). %d markers exceed the allowed maximum of %d", boundTerms, 65535));
        }
        if (prepared.fullyQualified) {
            ResultMessage.Prepared qualifiedWithoutKeyspace = QueryProcessor.storePreparedStatement(queryString, null, prepared);
            ResultMessage.Prepared qualifiedWithKeyspace = null;
            if (clientState.getRawKeyspace() != null) {
                qualifiedWithKeyspace = QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared);
            }
            if (useNewPreparedStatementBehaviour || qualifiedWithKeyspace == null) return qualifiedWithoutKeyspace;
            return qualifiedWithKeyspace;
        }
        clientState.warnAboutUseWithPreparedStatements(hashWithKeyspace, clientState.getRawKeyspace());
        ResultMessage.Prepared nonQualifiedWithKeyspace = QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared);
        ResultMessage.Prepared nonQualifiedWithNullKeyspace = QueryProcessor.storePreparedStatement(queryString, null, prepared);
        if (useNewPreparedStatementBehaviour) return nonQualifiedWithKeyspace;
        return nonQualifiedWithNullKeyspace;
    }

    private static MD5Digest computeId(String queryString, String keyspace) {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        return MD5Digest.compute(toHash);
    }

    @VisibleForTesting
    public static ResultMessage.Prepared getStoredPreparedStatement(String queryString, String clientKeyspace) throws InvalidRequestException {
        MD5Digest statementId = QueryProcessor.computeId(queryString, clientKeyspace);
        QueryHandler.Prepared existing = (QueryHandler.Prepared)preparedStatements.getIfPresent((Object)statementId);
        if (existing == null) {
            return null;
        }
        RequestValidations.checkTrue(queryString.equals(existing.rawCQLStatement), "MD5 hash collision: query with the same MD5 hash was already prepared. \n Existing: '%s'", existing.rawCQLStatement);
        return QueryProcessor.createResultMessage(statementId, existing);
    }

    @VisibleForTesting
    private static ResultMessage.Prepared createResultMessage(MD5Digest statementId, QueryHandler.Prepared existing) throws InvalidRequestException {
        ResultSet.PreparedMetadata preparedMetadata = ResultSet.PreparedMetadata.fromPrepared(existing.statement);
        ResultSet.ResultMetadata resultMetadata = ResultSet.ResultMetadata.fromPrepared(existing.statement);
        return new ResultMessage.Prepared(statementId, resultMetadata.getResultMetadataId(), preparedMetadata, resultMetadata);
    }

    @VisibleForTesting
    public static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, QueryHandler.Prepared prepared) throws InvalidRequestException {
        long statementSize = ObjectSizes.measureDeep(prepared.statement);
        if (statementSize > QueryProcessor.capacityToBytes(DatabaseDescriptor.getPreparedStatementsCacheSizeMiB())) {
            throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d MB: %s...", statementSize, DatabaseDescriptor.getPreparedStatementsCacheSizeMiB(), queryString.substring(0, 200)));
        }
        MD5Digest statementId = QueryProcessor.computeId(queryString, keyspace);
        QueryHandler.Prepared previous = (QueryHandler.Prepared)preparedStatements.get((Object)statementId, ignored_ -> prepared);
        if (previous == prepared) {
            SystemKeyspace.writePreparedStatement(keyspace, statementId, queryString);
        }
        ResultSet.PreparedMetadata preparedMetadata = ResultSet.PreparedMetadata.fromPrepared(prepared.statement);
        ResultSet.ResultMetadata resultMetadata = ResultSet.ResultMetadata.fromPrepared(prepared.statement);
        return new ResultMessage.Prepared(statementId, resultMetadata.getResultMetadataId(), preparedMetadata, resultMetadata);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        return this.processPrepared(statement, state, options, requestTime);
    }

    public ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || !statement.getBindVariables().isEmpty()) {
            if (variables.size() != statement.getBindVariables().size()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBindVariables().size(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        QueryProcessor.metrics.preparedStatementsExecuted.inc();
        return this.processStatement(statement, queryState, options, requestTime);
    }

    @Override
    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> customPayload, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        return this.processBatch(statement, state, options, requestTime);
    }

    public ResultMessage processBatch(BatchStatement batch, QueryState queryState, BatchQueryOptions options, Dispatcher.RequestTime requestTime) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState().cloneWithKeyspaceIfSet(options.getKeyspace());
        batch.authorize(clientState);
        batch.validate();
        batch.validate(clientState);
        return batch.execute(queryState, options, requestTime);
    }

    public static CQLStatement getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", (Object)queryStr);
        CQLStatement.Raw statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof QualifiedStatement) {
            ((QualifiedStatement)statement).setKeyspace(clientState);
        }
        Tracing.trace("Preparing statement");
        return statement.prepare(clientState);
    }

    public static <T extends CQLStatement.Raw> T parseStatement(String queryStr, Class<T> klass, String type) throws SyntaxException {
        try {
            CQLStatement.Raw stmt = QueryProcessor.parseStatement(queryStr);
            if (!klass.isAssignableFrom(stmt.getClass())) {
                throw new IllegalArgumentException("Invalid query, must be a " + type + " statement but was: " + stmt.getClass());
            }
            return (T)((CQLStatement.Raw)klass.cast(stmt));
        }
        catch (RequestValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static CQLStatement.Raw parseStatement(String queryStr) throws SyntaxException {
        try {
            return CQLFragmentParser.parseAnyUnhandled(CqlParser::query, queryStr);
        }
        catch (CassandraException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            logger.error(String.format("The statement: [%s] could not be parsed.", queryStr), (Throwable)re);
            throw new SyntaxException(String.format("Failed parsing statement: [%s] reason: %s %s", queryStr, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
        }
    }

    private static int measure(Object key, QueryHandler.Prepared value) {
        return Ints.checkedCast((long)(ObjectSizes.measureDeep(key) + ObjectSizes.measureDeep(value)));
    }

    @VisibleForTesting
    public static void clearInternalStatementsCache() {
        internalStatements.clear();
    }

    @VisibleForTesting
    public static void clearPreparedStatementsCache() {
        preparedStatements.asMap().clear();
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ ResultSet lambda$executeAsync$7(List commands, long nowInSec, SelectStatement select, QueryOptions options, ResultSetBuilder result, List list) {
        i = 0;
        for (Message m : list) {
            rsp = (ReadResponse)m.payload;
            it = UnfilteredPartitionIterators.filter(rsp.makeIterator((ReadCommand)commands.get(i++)), nowInSec);
lbl5:
            // 2 sources

            try {
                while (it.hasNext()) {
                    partition = (RowIterator)it.next();
                    try {
                        select.processPartition(partition, options, result, nowInSec);
                    }
                    finally {
                        if (partition == null) ** GOTO lbl5
                        partition.close();
                    }
                }
            }
            finally {
                if (it == null) continue;
                it.close();
            }
        }
        return result.build();
    }

    static {
        internalStatements = new ConcurrentHashMap<String, QueryHandler.Prepared>();
        metrics = new CQLMetrics();
        lastMinuteEvictionsCount = new AtomicInteger(0);
        preparedStatements = Caffeine.newBuilder().executor((Executor)ImmediateExecutor.INSTANCE).maximumWeight(QueryProcessor.capacityToBytes(DatabaseDescriptor.getPreparedStatementsCacheSizeMiB())).weigher(QueryProcessor::measure).removalListener((key, prepared, cause) -> {
            MD5Digest md5Digest = (MD5Digest)key;
            if (cause.wasEvicted()) {
                QueryProcessor.metrics.preparedStatementsEvicted.inc();
                lastMinuteEvictionsCount.incrementAndGet();
                SystemKeyspace.removePreparedStatement(md5Digest);
            }
        }).build();
        ScheduledExecutors.scheduledTasks.scheduleAtFixedRate(() -> {
            long count = lastMinuteEvictionsCount.getAndSet(0);
            if (count > 0L) {
                logger.warn("{} prepared statements discarded in the last minute because cache limit reached ({} MiB)", (Object)count, (Object)DatabaseDescriptor.getPreparedStatementsCacheSizeMiB());
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        logger.info("Initialized prepared statement caches with {} MiB", (Object)DatabaseDescriptor.getPreparedStatementsCacheSizeMiB());
    }

    private static class StatementInvalidatingListener
    implements SchemaChangeListener {
        private StatementInvalidatingListener() {
        }

        private static void removeInvalidPreparedStatements(String ksName, String cfName) {
            StatementInvalidatingListener.removeInvalidPreparedStatements(internalStatements.values().iterator(), ksName, cfName);
            StatementInvalidatingListener.removeInvalidPersistentPreparedStatements(preparedStatements.asMap().entrySet().iterator(), ksName, cfName);
        }

        private static void removeInvalidPreparedStatementsForFunction(String ksName, String functionName) {
            Predicate matchesFunction = f -> ksName.equals(f.name().keyspace) && functionName.equals(f.name().name);
            Iterator iter = preparedStatements.asMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry pstmt = iter.next();
                if (!Iterables.any(((QueryHandler.Prepared)pstmt.getValue()).statement.getFunctions(), (Predicate)matchesFunction)) continue;
                SystemKeyspace.removePreparedStatement((MD5Digest)pstmt.getKey());
                iter.remove();
            }
            Iterators.removeIf(internalStatements.values().iterator(), statement -> Iterables.any(statement.statement.getFunctions(), (Predicate)matchesFunction));
        }

        private static void removeInvalidPersistentPreparedStatements(Iterator<Map.Entry<MD5Digest, QueryHandler.Prepared>> iterator, String ksName, String cfName) {
            while (iterator.hasNext()) {
                Map.Entry<MD5Digest, QueryHandler.Prepared> entry = iterator.next();
                if (!StatementInvalidatingListener.shouldInvalidate(ksName, cfName, entry.getValue().statement)) continue;
                SystemKeyspace.removePreparedStatement(entry.getKey());
                iterator.remove();
            }
        }

        private static void removeInvalidPreparedStatements(Iterator<QueryHandler.Prepared> iterator, String ksName, String cfName) {
            while (iterator.hasNext()) {
                if (!StatementInvalidatingListener.shouldInvalidate(ksName, cfName, iterator.next().statement)) continue;
                iterator.remove();
            }
        }

        private static boolean shouldInvalidate(String ksName, String cfName, CQLStatement statement) {
            String statementCfName;
            String statementKsName;
            if (statement instanceof ModificationStatement) {
                ModificationStatement modificationStatement = (ModificationStatement)statement;
                statementKsName = modificationStatement.keyspace();
                statementCfName = modificationStatement.table();
            } else if (statement instanceof SelectStatement) {
                SelectStatement selectStatement = (SelectStatement)statement;
                statementKsName = selectStatement.keyspace();
                statementCfName = selectStatement.table();
            } else {
                if (statement instanceof BatchStatement) {
                    BatchStatement batchStatement = (BatchStatement)statement;
                    for (ModificationStatement stmt : batchStatement.getStatements()) {
                        if (!StatementInvalidatingListener.shouldInvalidate(ksName, cfName, stmt)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return ksName.equals(statementKsName) && (cfName == null || cfName.equals(statementCfName));
        }

        @Override
        public void onCreateFunction(UDFunction function) {
            StatementInvalidatingListener.onCreateFunctionInternal(function.name().keyspace, function.name().name, function.argTypes());
        }

        @Override
        public void onCreateAggregate(UDAggregate aggregate) {
            StatementInvalidatingListener.onCreateFunctionInternal(aggregate.name().keyspace, aggregate.name().name, aggregate.argTypes());
        }

        private static void onCreateFunctionInternal(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            if (Schema.instance.getKeyspaceMetadata((String)ksName).userFunctions.get(new FunctionName(ksName, functionName)).size() > 1) {
                StatementInvalidatingListener.removeInvalidPreparedStatementsForFunction(ksName, functionName);
            }
        }

        @Override
        public void onAlterTable(TableMetadata before, TableMetadata after, boolean affectsStatements) {
            logger.trace("Column definitions for {}.{} changed, invalidating related prepared statements", (Object)before.keyspace, (Object)before.name);
            if (affectsStatements) {
                StatementInvalidatingListener.removeInvalidPreparedStatements(before.keyspace, before.name);
            }
        }

        @Override
        public void onAlterFunction(UDFunction before, UDFunction after) {
            StatementInvalidatingListener.removeInvalidPreparedStatementsForFunction(before.name().keyspace, before.name().name);
        }

        @Override
        public void onAlterAggregate(UDAggregate before, UDAggregate after) {
            StatementInvalidatingListener.removeInvalidPreparedStatementsForFunction(before.name().keyspace, before.name().name);
        }

        @Override
        public void onDropKeyspace(KeyspaceMetadata keyspace, boolean dropData) {
            logger.trace("Keyspace {} was dropped, invalidating related prepared statements", (Object)keyspace.name);
            StatementInvalidatingListener.removeInvalidPreparedStatements(keyspace.name, null);
        }

        @Override
        public void onDropTable(TableMetadata table, boolean dropData) {
            logger.trace("Table {}.{} was dropped, invalidating related prepared statements", (Object)table.keyspace, (Object)table.name);
            StatementInvalidatingListener.removeInvalidPreparedStatements(table.keyspace, table.name);
        }

        @Override
        public void onDropFunction(UDFunction function) {
            StatementInvalidatingListener.removeInvalidPreparedStatementsForFunction(function.name().keyspace, function.name().name);
        }

        @Override
        public void onDropAggregate(UDAggregate aggregate) {
            StatementInvalidatingListener.removeInvalidPreparedStatementsForFunction(aggregate.name().keyspace, aggregate.name().name);
        }
    }

    private static enum InternalStateInstance {
        INSTANCE;

        private final ClientState clientState = ClientState.forInternalCalls("system");
    }
}

