/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;

public class GuidGenerator {
    private static final Random myRand;
    private static final SecureRandom mySecureRand;
    private static final String s_id;

    public static String guid() {
        ByteBuffer array = GuidGenerator.guidAsBytes();
        StringBuilder sb = new StringBuilder();
        for (int j = array.position(); j < array.limit(); ++j) {
            int b = array.get(j) & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        return GuidGenerator.convertToStandardFormat(sb.toString());
    }

    public static String guidToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < bytes.length; ++j) {
            int b = bytes[j] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        return GuidGenerator.convertToStandardFormat(sb.toString());
    }

    public static ByteBuffer guidAsBytes(Random random, String hostId, long time) {
        StringBuilder sbValueBeforeMD5 = new StringBuilder();
        long rand = random.nextLong();
        sbValueBeforeMD5.append(hostId).append(":").append(Long.toString(time)).append(":").append(Long.toString(rand));
        String valueBeforeMD5 = sbValueBeforeMD5.toString();
        return ByteBuffer.wrap(MD5Digest.threadLocalMD5Digest().digest(valueBeforeMD5.getBytes()));
    }

    public static ByteBuffer guidAsBytes() {
        return GuidGenerator.guidAsBytes(myRand, s_id, Clock.Global.currentTimeMillis());
    }

    private static String convertToStandardFormat(String valueAfterMD5) {
        String raw = valueAfterMD5.toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append(raw.substring(0, 8)).append("-").append(raw.substring(8, 12)).append("-").append(raw.substring(12, 16)).append("-").append(raw.substring(16, 20)).append("-").append(raw.substring(20));
        return sb.toString();
    }

    static {
        if (!CassandraRelevantProperties.JAVA_SECURITY_EGD.isPresent()) {
            CassandraRelevantProperties.JAVA_SECURITY_EGD.setString("file:/dev/urandom");
        }
        mySecureRand = new SecureRandom();
        long secureInitializer = mySecureRand.nextLong();
        myRand = new Random(secureInitializer);
        try {
            s_id = FBUtilities.getLocalAddressAndPort().toString();
        }
        catch (RuntimeException e) {
            throw new AssertionError((Object)e);
        }
    }
}

