/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.repair.state.JobState;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.TimeUUID;

public class SessionState
extends AbstractState<State, TimeUUID> {
    public final TimeUUID parentRepairSession;
    public final String keyspace;
    public final String[] cfnames;
    public final CommonRange commonRange;
    private final ConcurrentMap<UUID, JobState> jobs = new ConcurrentHashMap<UUID, JobState>();
    public final Phase phase = new Phase();

    public SessionState(Clock clock, TimeUUID parentRepairSession, String keyspace, String[] cfnames, CommonRange commonRange) {
        super(clock, TimeUUID.Generator.nextTimeUUID(), State.class);
        this.parentRepairSession = parentRepairSession;
        this.keyspace = keyspace;
        this.cfnames = cfnames;
        this.commonRange = commonRange;
    }

    public Collection<JobState> getJobs() {
        return this.jobs.values();
    }

    public JobState getJob(UUID id) {
        return (JobState)this.jobs.get(id);
    }

    public Set<UUID> getJobIds() {
        return this.jobs.keySet();
    }

    public Set<InetAddressAndPort> getParticipants() {
        return this.commonRange.endpoints;
    }

    @Override
    public String status() {
        State state = (State)((Object)this.getStatus());
        Completable.Result result = this.getResult();
        if (result != null) {
            return result.kind.name();
        }
        if (state == null) {
            return "init";
        }
        if (state == State.JOBS_START) {
            return state.name() + " " + this.jobs.entrySet().stream().map(e -> e.getKey() + " -> " + ((JobState)e.getValue()).status()).collect(Collectors.toList());
        }
        return state.name();
    }

    public void register(JobState state) {
        this.jobs.put((UUID)state.id, state);
    }

    public final class Phase
    extends AbstractCompletable.BaseSkipPhase {
        public void start() {
            SessionState.this.updateState(State.START);
        }

        public void jobsSubmitted() {
            SessionState.this.updateState(State.JOBS_START);
        }
    }

    public static enum State {
        START,
        JOBS_START;

    }
}

