/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ArrayClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public class ArrayClusteringBound
extends ArrayClusteringBoundOrBoundary
implements ClusteringBound<byte[]> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY));

    public ArrayClusteringBound(ClusteringPrefix.Kind kind, byte[][] values) {
        super(kind, values);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.values) + (long)((byte[][])this.values).length;
    }

    @Override
    public ClusteringBound<byte[]> invert() {
        return ArrayClusteringBound.create(this.kind().invert(), (byte[][])this.values);
    }

    @Override
    public ClusteringBound<ByteBuffer> clone(ByteBufferCloner cloner) {
        return (ClusteringBound)super.clone(cloner);
    }

    public static ArrayClusteringBound create(ClusteringPrefix.Kind kind, byte[][] values) {
        Preconditions.checkArgument((!kind.isBoundary() ? 1 : 0) != 0, (String)"Expected bound clustering kind, got %s", (Object)((Object)kind));
        return new ArrayClusteringBound(kind, values);
    }
}

