/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Vectors {
    private Vectors() {
    }

    private static AbstractType<?> elementsType(AbstractType<?> type) {
        return ((VectorType)type.unwrap()).getElementsType();
    }

    private static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), Vectors.elementsType(column.type));
    }

    public static AssignmentTestable.TestResult testVectorAssignment(ColumnSpecification receiver, List<? extends AssignmentTestable> elements) {
        if (!receiver.type.isVector()) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }
        if (elements.isEmpty()) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        ColumnSpecification valueSpec = Vectors.valueSpecOf(receiver);
        return AssignmentTestable.TestResult.testAll(receiver.ksName, valueSpec, elements);
    }

    public static <T> VectorType<?> getExactVectorTypeIfKnown(List<T> items, java.util.function.Function<T, AbstractType<?>> mapper) {
        Optional<AbstractType> type = items.stream().map(mapper).filter(Objects::nonNull).findFirst();
        return type.isPresent() ? VectorType.getInstance(type.get(), items.size()) : null;
    }

    public static <T> VectorType<?> getPreferredCompatibleType(List<T> items, java.util.function.Function<T, AbstractType<?>> mapper) {
        Set<AbstractType<?>> types = items.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toSet());
        AbstractType<?> type = AssignmentTestable.getCompatibleTypeIfKnown(types);
        return type == null ? null : VectorType.getInstance(type, items.size());
    }

    public static class DelayedValue<T>
    extends Term.NonTerminal {
        private final VectorType<T> type;
        private final List<Term> elements;

        public DelayedValue(VectorType<T> type, List<Term> elements) {
            this.type = type;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return this.elements.stream().anyMatch(Term::containsBindMarker);
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            this.elements.forEach(t -> t.collectMarkerSpecification(boundNames));
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size());
            for (Term t : this.elements) {
                ByteBuffer bytes = t.bindAndGet(options);
                if (bytes == null || bytes == ByteBufferUtil.UNSET_BYTE_BUFFER || this.type.elementType.isNull(bytes)) {
                    throw new InvalidRequestException("null is not supported inside vectors");
                }
                buffers.add(bytes);
            }
            return new Value<T>(this.type, buffers);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements, functions);
        }
    }

    public static class Value<T>
    extends Term.MultiItemTerminal {
        public final VectorType<T> type;
        public final List<ByteBuffer> elements;

        public Value(VectorType<T> type, List<ByteBuffer> elements) {
            this.type = type;
            this.elements = elements;
        }

        @Override
        public ByteBuffer get(ProtocolVersion version) {
            return this.type.decomposeRaw(this.elements);
        }

        @Override
        public List<ByteBuffer> getElements() {
            return this.elements;
        }
    }

    public static class Literal
    extends Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (!receiver.type.isVector()) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            VectorType type = (VectorType)receiver.type;
            if (this.elements.size() != type.dimension) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            ColumnSpecification valueSpec = Vectors.valueSpecOf(receiver);
            return AssignmentTestable.TestResult.testAll(receiver.ksName, valueSpec, this.elements);
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!receiver.type.isVector()) {
                throw new InvalidRequestException(String.format("Invalid vector literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            VectorType type = (VectorType)receiver.type;
            if (this.elements.size() != type.dimension) {
                throw new InvalidRequestException(String.format("Invalid vector literal for %s of type %s; expected %d elements, but given %d", receiver.name, receiver.type.asCQL3Type(), type.dimension, this.elements.size()));
            }
            ColumnSpecification valueSpec = Vectors.valueSpecOf(receiver);
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            boolean allTerminal = true;
            for (Term.Raw rt : this.elements) {
                if (!rt.testAssignment(keyspace, valueSpec).isAssignable()) {
                    throw new InvalidRequestException(String.format("Invalid vector literal for %s: value %s is not of type %s", receiver.name, rt, valueSpec.type.asCQL3Type()));
                }
                Term t = rt.prepare(keyspace, valueSpec);
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(type, values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        @Override
        public String getText() {
            return Lists.listToString(this.elements, Term.Raw::getText);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return Vectors.getExactVectorTypeIfKnown(this.elements, e -> e.getExactTypeIfKnown(keyspace));
        }

        @Override
        public AbstractType<?> getCompatibleTypeIfKnown(String keyspace) {
            return Vectors.getPreferredCompatibleType(this.elements, e -> e.getCompatibleTypeIfKnown(keyspace));
        }
    }
}

