/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.ListMultimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.Operation;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.FBUtilities;

public class FilterTree {
    protected final Operation.BooleanOperator baseOperator;
    protected final ListMultimap<ColumnMetadata, Expression> expressions;
    protected final List<FilterTree> children = new ArrayList<FilterTree>();
    private final boolean isStrict;
    private final QueryContext context;

    FilterTree(Operation.BooleanOperator baseOperator, ListMultimap<ColumnMetadata, Expression> expressions, boolean isStrict, QueryContext context) {
        this.baseOperator = baseOperator;
        this.expressions = expressions;
        this.isStrict = isStrict;
        this.context = context;
    }

    void addChild(FilterTree child) {
        this.children.add(child);
    }

    public boolean restrictsNonStaticRow() {
        for (ColumnMetadata column : this.expressions.keySet()) {
            if (column.isStatic()) continue;
            return true;
        }
        for (FilterTree child : this.children) {
            if (!child.restrictsNonStaticRow()) continue;
            return true;
        }
        return false;
    }

    public boolean isSatisfiedBy(DecoratedKey key, Row row, Row staticRow) {
        boolean result = this.localSatisfiedBy(key, row, staticRow);
        for (FilterTree child : this.children) {
            result = this.baseOperator.apply(result, child.isSatisfiedBy(key, row, staticRow));
        }
        return result;
    }

    private boolean localSatisfiedBy(DecoratedKey key, Row row, Row staticRow) {
        if (row == null) {
            return false;
        }
        long now = FBUtilities.nowInSeconds();
        Operation.BooleanOperator localOperator = this.isStrict || !this.context.hasUnrepairedMatches ? this.baseOperator : Operation.BooleanOperator.OR;
        boolean result = localOperator == Operation.BooleanOperator.AND;
        for (ColumnMetadata column : this.expressions.keySet()) {
            Row localRow = column.kind == ColumnMetadata.Kind.STATIC ? staticRow : row;
            List filters = this.expressions.get((Object)column);
            ListIterator filterIterator = filters.listIterator(filters.size());
            while (filterIterator.hasPrevious()) {
                Expression filter = (Expression)filterIterator.previous();
                if (filter.getIndexTermType().isNonFrozenCollection()) {
                    Iterator<ByteBuffer> valueIterator = filter.getIndexTermType().valuesOf(localRow, now);
                    result = localOperator.apply(result, this.collectionMatch(valueIterator, filter));
                } else {
                    ByteBuffer value = filter.getIndexTermType().valueOf(key, localRow, now);
                    result = localOperator.apply(result, this.singletonMatch(value, filter));
                }
                if (localOperator == Operation.BooleanOperator.AND && !result) {
                    return false;
                }
                if (localOperator != Operation.BooleanOperator.OR || !result) continue;
                return true;
            }
        }
        return result;
    }

    private boolean singletonMatch(ByteBuffer value, Expression filter) {
        return value != null && filter.isSatisfiedBy(value);
    }

    private boolean collectionMatch(Iterator<ByteBuffer> valueIterator, Expression filter) {
        if (valueIterator == null) {
            return false;
        }
        while (valueIterator.hasNext()) {
            ByteBuffer value = valueIterator.next();
            if (value == null || !filter.isSatisfiedBy(value)) continue;
            return true;
        }
        return false;
    }
}

