/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.metrics.AbstractMetrics;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.tracing.Tracing;

public class TableQueryMetrics
extends AbstractMetrics {
    public static final String TABLE_QUERY_METRIC_TYPE = "TableQueryMetrics";
    public final Timer postFilteringReadLatency;
    private final PerQueryMetrics perQueryMetrics;
    private final Counter totalQueryTimeouts;
    private final Counter totalPartitionReads;
    private final Counter totalRowsFiltered;
    private final Counter totalQueriesCompleted;

    public TableQueryMetrics(TableMetadata table) {
        super(table.keyspace, table.name, TABLE_QUERY_METRIC_TYPE);
        this.perQueryMetrics = new PerQueryMetrics(table);
        this.postFilteringReadLatency = CassandraMetricsRegistry.Metrics.timer(this.createMetricName("PostFilteringReadLatency"));
        this.totalPartitionReads = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("TotalPartitionReads"));
        this.totalRowsFiltered = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("TotalRowsFiltered"));
        this.totalQueriesCompleted = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("TotalQueriesCompleted"));
        this.totalQueryTimeouts = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("TotalQueryTimeouts"));
    }

    public void record(QueryContext queryContext) {
        if (queryContext.queryTimedOut) {
            this.totalQueryTimeouts.inc();
        }
        this.perQueryMetrics.record(queryContext);
    }

    @Override
    public void release() {
        super.release();
        this.perQueryMetrics.release();
    }

    private String pluralize(long count, String root, String plural) {
        return count == 1L ? String.format("1 %s", root) : String.format("%d %s%s", count, root, plural);
    }

    public class PerQueryMetrics
    extends AbstractMetrics {
        private final Timer queryLatency;
        private final Histogram sstablesHit;
        private final Histogram segmentsHit;
        private final Histogram partitionReads;
        private final Histogram rowsFiltered;
        private final Histogram balancedTreePostingsNumPostings;
        private final Histogram balancedTreePostingsSkips;
        private final Histogram balancedTreePostingsDecodes;
        private final Histogram postingsSkips;
        private final Histogram postingsDecodes;

        public PerQueryMetrics(TableMetadata table) {
            super(table.keyspace, table.name, "PerQuery");
            this.queryLatency = CassandraMetricsRegistry.Metrics.timer(this.createMetricName("QueryLatency"));
            this.sstablesHit = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("SSTableIndexesHit"), false);
            this.segmentsHit = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("IndexSegmentsHit"), false);
            this.balancedTreePostingsSkips = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("BalancedTreePostingsSkips"), false);
            this.balancedTreePostingsNumPostings = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("BalancedTreePostingsNumPostings"), false);
            this.balancedTreePostingsDecodes = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("BalancedTreePostingsDecodes"), false);
            this.postingsSkips = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("PostingsSkips"), false);
            this.postingsDecodes = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("PostingsDecodes"), false);
            this.partitionReads = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("PartitionReads"), false);
            this.rowsFiltered = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("RowsFiltered"), false);
        }

        private void recordStringIndexCacheMetrics(QueryContext events) {
            this.postingsSkips.update(events.triePostingsSkips);
            this.postingsDecodes.update(events.triePostingsDecodes);
        }

        private void recordNumericIndexCacheMetrics(QueryContext events) {
            this.balancedTreePostingsNumPostings.update(events.balancedTreePostingListsHit);
            this.balancedTreePostingsSkips.update(events.balancedTreePostingsSkips);
            this.balancedTreePostingsDecodes.update(events.balancedTreePostingsDecodes);
        }

        public void record(QueryContext queryContext) {
            long totalQueryTimeNs = queryContext.totalQueryTimeNs();
            this.queryLatency.update(totalQueryTimeNs, TimeUnit.NANOSECONDS);
            long queryLatencyMicros = TimeUnit.NANOSECONDS.toMicros(totalQueryTimeNs);
            this.sstablesHit.update(queryContext.sstablesHit);
            this.segmentsHit.update(queryContext.segmentsHit);
            this.partitionReads.update(queryContext.partitionsRead);
            TableQueryMetrics.this.totalPartitionReads.inc(queryContext.partitionsRead);
            this.rowsFiltered.update(queryContext.rowsFiltered);
            TableQueryMetrics.this.totalRowsFiltered.inc(queryContext.rowsFiltered);
            if (Tracing.isTracing()) {
                Tracing.trace("Index query accessed memtable indexes, {}, and {}, post-filtered {} in {}, and took {} microseconds.", TableQueryMetrics.this.pluralize(queryContext.sstablesHit, "SSTable index", "es"), TableQueryMetrics.this.pluralize(queryContext.segmentsHit, "segment", "s"), TableQueryMetrics.this.pluralize(queryContext.rowsFiltered, "row", "s"), TableQueryMetrics.this.pluralize(queryContext.partitionsRead, "partition", "s"), queryLatencyMicros);
            }
            if (queryContext.trieSegmentsHit > 0L) {
                this.recordStringIndexCacheMetrics(queryContext);
            }
            if (queryContext.balancedTreeSegmentsHit > 0L) {
                this.recordNumericIndexCacheMetrics(queryContext);
            }
            TableQueryMetrics.this.totalQueriesCompleted.inc();
        }
    }
}

