/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.trie;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingsWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentWriter;
import org.apache.cassandra.index.sai.disk.v1.trie.TrieTermsDictionaryWriter;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexEntry;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.commons.lang3.mutable.MutableLong;

@NotThreadSafe
public class LiteralIndexWriter
implements SegmentWriter {
    private final IndexDescriptor indexDescriptor;
    private final IndexIdentifier indexIdentifier;
    private long postingsAdded;

    public LiteralIndexWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) {
        this.indexDescriptor = indexDescriptor;
        this.indexIdentifier = indexIdentifier;
    }

    @Override
    public SegmentMetadata.ComponentMetadataMap writeCompleteSegment(Iterator<IndexEntry> iterator) throws IOException {
        SegmentMetadata.ComponentMetadataMap components = new SegmentMetadata.ComponentMetadataMap();
        try (TrieTermsDictionaryWriter termsDictionaryWriter = new TrieTermsDictionaryWriter(this.indexDescriptor, this.indexIdentifier);
             PostingsWriter postingsWriter = new PostingsWriter(this.indexDescriptor, this.indexIdentifier);){
            long termsOffset = termsDictionaryWriter.getStartOffset();
            long postingsOffset = postingsWriter.getStartOffset();
            while (iterator.hasNext()) {
                IndexEntry indexEntry = iterator.next();
                PostingList postings = indexEntry.postingList;
                try {
                    long offset = postingsWriter.write(postings);
                    termsDictionaryWriter.add(indexEntry.term, offset);
                }
                finally {
                    if (postings == null) continue;
                    postings.close();
                }
            }
            this.postingsAdded = postingsWriter.getTotalPostings();
            MutableLong footerPointer = new MutableLong();
            long termsRoot = termsDictionaryWriter.complete(footerPointer);
            postingsWriter.complete();
            long termsLength = termsDictionaryWriter.getFilePointer() - termsOffset;
            long postingsLength = postingsWriter.getFilePointer() - postingsOffset;
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("footerPointer", footerPointer.getValue().toString());
            components.put(IndexComponent.POSTING_LISTS, -1L, postingsOffset, postingsLength);
            components.put(IndexComponent.TERMS_DATA, termsRoot, termsOffset, termsLength, map);
        }
        return components;
    }

    @Override
    public long getNumberOfRows() {
        return this.postingsAdded;
    }
}

