/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.Date;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.snapshot.TableSnapshot;

public class SnapshotsTable
extends AbstractVirtualTable {
    private static final String NAME = "name";
    private static final String KEYSPACE_NAME = "keyspace_name";
    private static final String TABLE_NAME = "table_name";
    private static final String TRUE_SIZE = "true_size";
    private static final String SIZE_ON_DISK = "size_on_disk";
    private static final String CREATED_AT = "created_at";
    private static final String EXPIRES_AT = "expires_at";
    private static final String EPHEMERAL = "ephemeral";

    SnapshotsTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "snapshots").comment("available snapshots").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME, UTF8Type.instance).addClusteringColumn(KEYSPACE_NAME, UTF8Type.instance).addClusteringColumn(TABLE_NAME, UTF8Type.instance).addRegularColumn(TRUE_SIZE, LongType.instance).addRegularColumn(SIZE_ON_DISK, LongType.instance).addRegularColumn(CREATED_AT, TimestampType.instance).addRegularColumn(EXPIRES_AT, TimestampType.instance).addRegularColumn(EPHEMERAL, BooleanType.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (TableSnapshot tableSnapshot : StorageService.instance.snapshotManager.loadSnapshots()) {
            SimpleDataSet row = result.row(tableSnapshot.getTag(), tableSnapshot.getKeyspaceName(), tableSnapshot.getTableName()).column(TRUE_SIZE, tableSnapshot.computeTrueSizeBytes()).column(SIZE_ON_DISK, tableSnapshot.computeSizeOnDiskBytes()).column(CREATED_AT, new Date(tableSnapshot.getCreatedAt().toEpochMilli()));
            if (tableSnapshot.isExpiring()) {
                row.column(EXPIRES_AT, new Date(tableSnapshot.getExpiresAt().toEpochMilli()));
            }
            row.column(EPHEMERAL, tableSnapshot.isEphemeral());
        }
        return result;
    }
}

