/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.CIDRGroupsMappingLoader;
import org.apache.cassandra.auth.CIDRGroupsMappingManager;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.CIDRAuthorizerMetrics;
import org.apache.cassandra.utils.MonotonicClock;

public class CIDRGroupsMappingCache {
    private volatile CIDRGroupsMappingLoader currentCidrGroupsMappingLoader = null;
    private LoadingCache<InetAddress, Set<String>> ipToCidrGroupsCache;
    private volatile boolean cacheInitialized = false;
    private CIDRGroupsMappingManager cidrGroupsMappingManager;
    private final CIDRAuthorizerMetrics cidrAuthorizerMetrics;

    public CIDRGroupsMappingCache(CIDRGroupsMappingManager cidrGroupsMappingManager, CIDRAuthorizerMetrics cidrAuthorizerMetrics) {
        this.cidrGroupsMappingManager = cidrGroupsMappingManager;
        this.cidrAuthorizerMetrics = cidrAuthorizerMetrics;
        this.ipToCidrGroupsCache = Caffeine.newBuilder().maximumSize((long)DatabaseDescriptor.getIpCacheMaxSize()).executor((Executor)ImmediateExecutor.INSTANCE).build(this::lookupCidrGroupsCacheForIp);
        int cidrGroupsCacheRefreshInterval = DatabaseDescriptor.getCidrGroupsCacheRefreshInterval();
        ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this::reloadCidrGroupsCache, cidrGroupsCacheRefreshInterval, cidrGroupsCacheRefreshInterval, TimeUnit.MINUTES);
    }

    private void loadCidrGroupsCacheInternal() {
        long startTimeNanos = MonotonicClock.Global.approxTime.now();
        this.currentCidrGroupsMappingLoader = new CIDRGroupsMappingLoader(this.cidrGroupsMappingManager);
        this.ipToCidrGroupsCache.invalidateAll();
        this.cidrAuthorizerMetrics.cacheReloadCount.inc();
        this.cidrAuthorizerMetrics.cacheReloadLatency.update(MonotonicClock.Global.approxTime.now() - startTimeNanos, TimeUnit.NANOSECONDS);
    }

    private void reloadCidrGroupsCache() {
        if (this.cacheInitialized) {
            this.loadCidrGroupsCacheInternal();
        }
    }

    public void loadCidrGroupsCache() {
        this.loadCidrGroupsCacheInternal();
        this.cacheInitialized = true;
    }

    private Set<String> lookupCidrGroupsCacheForIp(InetAddress ipAddr) {
        long startTimeNanos = MonotonicClock.Global.approxTime.now();
        Preconditions.checkNotNull((Object)this.currentCidrGroupsMappingLoader);
        Set<String> cidrGroups = this.currentCidrGroupsMappingLoader.lookupCidrGroupsCacheForIp(ipAddr);
        this.cidrAuthorizerMetrics.lookupCidrGroupsForIpLatency.update(MonotonicClock.Global.approxTime.now() - startTimeNanos, TimeUnit.NANOSECONDS);
        return cidrGroups;
    }

    public Set<String> lookupCidrGroupsForIp(InetAddress ipAddr) {
        Preconditions.checkState((boolean)this.cacheInitialized, (Object)"CIDR groups cache not inited");
        return (Set)this.ipToCidrGroupsCache.get((Object)ipAddr);
    }
}

