/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.thresholds;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.reads.thresholds.WarningsSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorWarnings {
    private static final Logger logger = LoggerFactory.getLogger(CoordinatorWarnings.class);
    private static final boolean ENABLE_DEFENSIVE_CHECKS = CassandraRelevantProperties.READS_THRESHOLDS_COORDINATOR_DEFENSIVE_CHECKS_ENABLED.getBoolean();
    private static final Map<ReadCommand, WarningsSnapshot> INIT = Collections.emptyMap();
    private static final FastThreadLocal<Map<ReadCommand, WarningsSnapshot>> STATE = new FastThreadLocal();

    private CoordinatorWarnings() {
    }

    public static void init() {
        logger.trace("CoordinatorTrackWarnings.init()");
        if (STATE.get() != null) {
            if (ENABLE_DEFENSIVE_CHECKS) {
                throw new AssertionError((Object)("CoordinatorTrackWarnings.init called while state is not null: " + STATE.get()));
            }
            return;
        }
        STATE.set(INIT);
    }

    public static void reset() {
        logger.trace("CoordinatorTrackWarnings.reset()");
        STATE.remove();
    }

    public static void update(ReadCommand cmd, WarningsSnapshot snapshot) {
        logger.trace("CoordinatorTrackWarnings.update({}, {})", (Object)cmd.metadata(), (Object)snapshot);
        Map<ReadCommand, WarningsSnapshot> map = CoordinatorWarnings.mutable();
        WarningsSnapshot previous = map.get(cmd);
        WarningsSnapshot update = WarningsSnapshot.merge(previous, snapshot);
        if (update == null) {
            map.remove(cmd);
        } else {
            map.put(cmd, update);
        }
    }

    public static void done() {
        Map<ReadCommand, WarningsSnapshot> map = CoordinatorWarnings.readonly();
        logger.trace("CoordinatorTrackWarnings.done() with state {}", map);
        map.forEach((command, merged) -> {
            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(command.metadata().id);
            if (cfs == null) {
                return;
            }
            String cql = command.toCQLString();
            String loggableTokens = command.loggableTokens();
            CoordinatorWarnings.recordAborts(merged.tombstones, cql, loggableTokens, cfs.metric.clientTombstoneAborts, WarningsSnapshot::tombstoneAbortMessage);
            CoordinatorWarnings.recordWarnings(merged.tombstones, cql, loggableTokens, cfs.metric.clientTombstoneWarnings, WarningsSnapshot::tombstoneWarnMessage);
            CoordinatorWarnings.recordAborts(merged.localReadSize, cql, loggableTokens, cfs.metric.localReadSizeAborts, WarningsSnapshot::localReadSizeAbortMessage);
            CoordinatorWarnings.recordWarnings(merged.localReadSize, cql, loggableTokens, cfs.metric.localReadSizeWarnings, WarningsSnapshot::localReadSizeWarnMessage);
            CoordinatorWarnings.recordAborts(merged.rowIndexReadSize, cql, loggableTokens, cfs.metric.rowIndexSizeAborts, WarningsSnapshot::rowIndexReadSizeAbortMessage);
            CoordinatorWarnings.recordWarnings(merged.rowIndexReadSize, cql, loggableTokens, cfs.metric.rowIndexSizeWarnings, WarningsSnapshot::rowIndexSizeWarnMessage);
        });
        CoordinatorWarnings.clearState();
    }

    private static Map<ReadCommand, WarningsSnapshot> mutable() {
        Map<ReadCommand, WarningsSnapshot> map = (Map<ReadCommand, WarningsSnapshot>)STATE.get();
        if (map == null) {
            if (ENABLE_DEFENSIVE_CHECKS) {
                throw new AssertionError((Object)"CoordinatorTrackWarnings.mutable calling without calling .init() first");
            }
            map = IgnoreMap.get();
        } else if (map == INIT) {
            map = new HashMap<ReadCommand, WarningsSnapshot>();
            STATE.set(map);
        }
        return map;
    }

    private static Map<ReadCommand, WarningsSnapshot> readonly() {
        Map map = (Map)STATE.get();
        if (map == null) {
            if (ENABLE_DEFENSIVE_CHECKS) {
                throw new AssertionError((Object)"CoordinatorTrackWarnings.readonly calling without calling .init() first");
            }
            map = Collections.emptyMap();
        }
        return map;
    }

    private static void clearState() {
        Map map = (Map)STATE.get();
        if (map == null || map == INIT) {
            return;
        }
        STATE.set(INIT);
    }

    private static void recordAborts(WarningsSnapshot.Warnings counter, String cql, String loggableTokens, TableMetrics.TableMeter metric, ToString toString) {
        if (!counter.aborts.instances.isEmpty()) {
            String msg = toString.apply(counter.aborts.instances.size(), counter.aborts.maxValue, cql);
            ClientWarn.instance.warn(msg + " with " + loggableTokens);
            logger.warn(msg);
            metric.mark();
        }
    }

    private static void recordWarnings(WarningsSnapshot.Warnings counter, String cql, String loggableTokens, TableMetrics.TableMeter metric, ToString toString) {
        if (!counter.warnings.instances.isEmpty()) {
            String msg = toString.apply(counter.warnings.instances.size(), counter.warnings.maxValue, cql);
            ClientWarn.instance.warn(msg + " with " + loggableTokens);
            logger.warn(msg);
            metric.mark();
        }
    }

    private static final class IgnoreMap
    extends AbstractMap<Object, Object> {
        private static final IgnoreMap INSTANCE = new IgnoreMap();

        private IgnoreMap() {
        }

        private static <K, V> Map<K, V> get() {
            return INSTANCE;
        }

        @Override
        public Object put(Object key, Object value) {
            return null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }
    }

    @FunctionalInterface
    private static interface ToString {
        public String apply(int var1, long var2, String var4);
    }
}

