/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;

public abstract class SSTableScanner<S extends SSTableReader, E extends AbstractRowIndexEntry, I extends BaseKeyScanningIterator>
implements ISSTableScanner {
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final RandomAccessReader dfile;
    protected final S sstable;
    protected final Iterator<AbstractBounds<PartitionPosition>> rangeIterator;
    protected final ColumnFilter columns;
    protected final DataRange dataRange;
    private final SSTableReadsListener listener;
    protected I iterator;
    protected long startScan = -1L;
    protected long bytesScanned = 0L;

    protected SSTableScanner(S sstable, ColumnFilter columns, DataRange dataRange, Iterator<AbstractBounds<PartitionPosition>> rangeIterator, SSTableReadsListener listener) {
        assert (sstable != null);
        this.dfile = ((SSTableReader)sstable).openDataReader();
        this.sstable = sstable;
        this.columns = columns;
        this.dataRange = dataRange;
        this.rangeIterator = rangeIterator;
        this.listener = listener;
    }

    protected static List<AbstractBounds<PartitionPosition>> makeBounds(SSTableReader sstable, Collection<Range<Token>> tokenRanges) {
        ArrayList<AbstractBounds<PartitionPosition>> boundsList = new ArrayList<AbstractBounds<PartitionPosition>>(tokenRanges.size());
        for (Range<Token> range : Range.normalize(tokenRanges)) {
            SSTableScanner.addRange(sstable, Range.makeRowRange(range), boundsList);
        }
        return boundsList;
    }

    protected static List<AbstractBounds<PartitionPosition>> makeBounds(SSTableReader sstable, DataRange dataRange) {
        ArrayList<AbstractBounds<PartitionPosition>> boundsList = new ArrayList<AbstractBounds<PartitionPosition>>(2);
        SSTableScanner.addRange(sstable, dataRange.keyRange(), boundsList);
        return boundsList;
    }

    protected static AbstractBounds<PartitionPosition> fullRange(SSTableReader sstable) {
        return new Bounds<PartitionPosition>(sstable.getFirst(), sstable.getLast());
    }

    private static void addRange(SSTableReader sstable, AbstractBounds<PartitionPosition> requested, List<AbstractBounds<PartitionPosition>> boundsList) {
        if (requested instanceof Range && ((Range)requested).isWrapAround()) {
            if (((PartitionPosition)requested.right).compareTo(sstable.getFirst()) >= 0) {
                AbstractBounds.Boundary<DecoratedKey> left = new AbstractBounds.Boundary<DecoratedKey>(sstable.getFirst(), true);
                AbstractBounds.Boundary<PartitionPosition> right = requested.rightBoundary();
                if (!AbstractBounds.isEmpty(left, right = AbstractBounds.minRight(right, sstable.getLast(), true))) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
            if (((PartitionPosition)requested.left).compareTo(sstable.getLast()) <= 0) {
                AbstractBounds.Boundary<DecoratedKey> right = new AbstractBounds.Boundary<DecoratedKey>(sstable.getLast(), true);
                AbstractBounds.Boundary<PartitionPosition> left = requested.leftBoundary();
                if (!AbstractBounds.isEmpty(left = AbstractBounds.maxLeft(left, sstable.getFirst(), true), right)) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
        } else {
            assert (!AbstractBounds.strictlyWrapsAround((PartitionPosition)requested.left, (PartitionPosition)requested.right));
            AbstractBounds.Boundary<PartitionPosition> left = requested.leftBoundary();
            AbstractBounds.Boundary<PartitionPosition> right = requested.rightBoundary();
            left = AbstractBounds.maxLeft(left, sstable.getFirst(), true);
            AbstractBounds.Boundary<PartitionPosition> boundary = right = ((PartitionPosition)requested.right).isMinimum() ? new AbstractBounds.Boundary<DecoratedKey>(sstable.getLast(), true) : AbstractBounds.minRight(right, sstable.getLast(), true);
            if (!AbstractBounds.isEmpty(left, right)) {
                boundsList.add(AbstractBounds.bounds(left, right));
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.isClosed.compareAndSet(false, true)) {
                this.markScanned();
                this.doClose();
            }
        }
        catch (IOException e) {
            ((SSTableReader)this.sstable).markSuspect();
            throw new CorruptSSTableException((Throwable)e, ((SSTableReader)this.sstable).getFilename());
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public long getLengthInBytes() {
        return ((SSTableReader)this.sstable).uncompressedLength();
    }

    @Override
    public long getCompressedLengthInBytes() {
        return ((SSTableReader)this.sstable).onDiskLength();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public long getBytesScanned() {
        return this.bytesScanned;
    }

    @Override
    public Set<SSTableReader> getBackingSSTables() {
        return ImmutableSet.of(this.sstable);
    }

    @Override
    public TableMetadata metadata() {
        return ((SSTable)this.sstable).metadata();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return ((AbstractIterator)this.iterator).hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return (UnfilteredRowIterator)((AbstractIterator)this.iterator).next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private I createIterator() {
        this.listener.onScanningStarted((SSTableReader)this.sstable);
        return this.doCreateIterator();
    }

    protected abstract I doCreateIterator();

    private void markScanned() {
        if (this.startScan != -1L) {
            this.bytesScanned += this.dfile.getFilePointer() - this.startScan;
            this.startScan = -1L;
        }
    }

    public String toString() {
        return String.format("%s(dfile=%s sstable=%s)", this.getClass().getSimpleName(), this.dfile, this.sstable);
    }

    public abstract class BaseKeyScanningIterator
    extends AbstractIterator<UnfilteredRowIterator> {
        protected DecoratedKey currentKey;
        protected E currentEntry;
        private LazilyInitializedUnfilteredRowIterator currentRowIterator;

        protected abstract boolean prepareToIterateRow() throws IOException;

        protected abstract UnfilteredRowIterator getRowIterator(E var1, DecoratedKey var2) throws IOException;

        @Override
        protected UnfilteredRowIterator computeNext() {
            if (this.currentRowIterator != null && this.currentRowIterator.isOpen() && this.currentRowIterator.hasNext()) {
                throw new IllegalStateException("The UnfilteredRowIterator returned by the last call to next() was initialized: it must be closed before calling hasNext() or next() again.");
            }
            try {
                SSTableScanner.this.markScanned();
                if (!this.prepareToIterateRow()) {
                    return (UnfilteredRowIterator)this.endOfData();
                }
                this.currentRowIterator = new LazilyInitializedUnfilteredRowIterator(this.currentKey){
                    private final E rowIndexEntry;
                    {
                        this.rowIndexEntry = BaseKeyScanningIterator.this.currentEntry;
                    }

                    @Override
                    protected UnfilteredRowIterator initializeIterator() {
                        try {
                            SSTableScanner.this.startScan = ((AbstractRowIndexEntry)this.rowIndexEntry).position;
                            return BaseKeyScanningIterator.this.getRowIterator(this.rowIndexEntry, this.partitionKey());
                        }
                        catch (IOException | CorruptSSTableException e) {
                            ((SSTableReader)SSTableScanner.this.sstable).markSuspect();
                            throw new CorruptSSTableException((Throwable)e, ((SSTableReader)SSTableScanner.this.sstable).getFilename());
                        }
                    }
                };
                return this.currentRowIterator;
            }
            catch (IOException | CorruptSSTableException e) {
                ((SSTableReader)SSTableScanner.this.sstable).markSuspect();
                throw new CorruptSSTableException((Throwable)e, ((SSTableReader)SSTableScanner.this.sstable).getFilename());
            }
        }
    }
}

