/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.view;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeTermTree {
    private static final Logger logger = LoggerFactory.getLogger(RangeTermTree.class);
    protected final ByteBuffer min;
    protected final ByteBuffer max;
    protected final IndexTermType indexTermType;
    private final IntervalTree<Term, SSTableIndex, Interval<Term, SSTableIndex>> rangeTree;

    private RangeTermTree(ByteBuffer min, ByteBuffer max, IntervalTree<Term, SSTableIndex, Interval<Term, SSTableIndex>> rangeTree, IndexTermType indexTermType) {
        this.min = min;
        this.max = max;
        this.rangeTree = rangeTree;
        this.indexTermType = indexTermType;
    }

    public List<SSTableIndex> search(Expression e) {
        ByteBuffer minTerm = e.lower() == null ? this.min : e.lower().value.encoded;
        ByteBuffer maxTerm = e.upper() == null ? this.max : e.upper().value.encoded;
        return this.rangeTree.search((Term)((Object)Interval.create(new Term(minTerm, this.indexTermType), new Term(maxTerm, this.indexTermType), null)));
    }

    protected static class Term
    implements Comparable<Term> {
        private final ByteBuffer term;
        private final IndexTermType indexTermType;

        Term(ByteBuffer term, IndexTermType indexTermType) {
            this.term = term;
            this.indexTermType = indexTermType;
        }

        @Override
        public int compareTo(Term o) {
            return this.indexTermType.compare(this.term, o.term);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("term", (Object)this.indexTermType.asString(this.term)).toString();
        }
    }

    static class Builder {
        private final IndexTermType indexTermType;
        private ByteBuffer min;
        private ByteBuffer max;
        final List<Interval<Term, SSTableIndex>> intervals = new ArrayList<Interval<Term, SSTableIndex>>();

        protected Builder(IndexTermType indexTermType) {
            this.indexTermType = indexTermType;
        }

        public final void add(SSTableIndex index) {
            this.addIndex(index);
            this.min = this.min == null || index.getIndexTermType().compare(this.min, index.minTerm()) > 0 ? index.minTerm() : this.min;
            this.max = this.max == null || index.getIndexTermType().compare(this.max, index.maxTerm()) < 0 ? index.maxTerm() : this.max;
        }

        public void addIndex(SSTableIndex index) {
            Interval<Term, SSTableIndex> interval = Interval.create(new Term(index.minTerm(), this.indexTermType), new Term(index.maxTerm(), this.indexTermType), index);
            if (logger.isTraceEnabled()) {
                logger.trace(index.getIndexIdentifier().logMessage("Adding index for SSTable {} with minTerm={} and maxTerm={}..."), new Object[]{index.getSSTable().descriptor, this.indexTermType.indexType().compose(index.minTerm()), this.indexTermType.indexType().compose(index.maxTerm())});
            }
            this.intervals.add(interval);
        }

        public RangeTermTree build() {
            return new RangeTermTree(this.min, this.max, IntervalTree.build(this.intervals), this.indexTermType);
        }
    }
}

