/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.plan.StorageAttachedIndexSearcher;
import org.apache.cassandra.index.sai.plan.VectorTopKProcessor;

public class StorageAttachedIndexQueryPlan
implements Index.QueryPlan {
    private final ColumnFamilyStore cfs;
    private final TableQueryMetrics queryMetrics;
    private final RowFilter postIndexFilter;
    private final RowFilter filterOperation;
    private final Set<Index> indexes;
    private final boolean isTopK;

    private StorageAttachedIndexQueryPlan(ColumnFamilyStore cfs, TableQueryMetrics queryMetrics, RowFilter postIndexFilter, RowFilter filterOperation, ImmutableSet<Index> indexes) {
        this.cfs = cfs;
        this.queryMetrics = queryMetrics;
        this.postIndexFilter = postIndexFilter;
        this.filterOperation = filterOperation;
        this.indexes = indexes;
        this.isTopK = indexes.stream().anyMatch(i -> i instanceof StorageAttachedIndex && ((StorageAttachedIndex)i).termType().isVector());
    }

    @Nullable
    public static StorageAttachedIndexQueryPlan create(ColumnFamilyStore cfs, TableQueryMetrics queryMetrics, Set<StorageAttachedIndex> indexes, RowFilter rowFilter) {
        ImmutableSet.Builder selectedIndexesBuilder = ImmutableSet.builder();
        RowFilter preIndexFilter = rowFilter;
        RowFilter postIndexFilter = rowFilter;
        for (RowFilter.Expression expression : rowFilter) {
            if (expression.operator().isIN() || expression.isUserDefined()) {
                if (!preIndexFilter.getExpressions().contains(expression)) continue;
                preIndexFilter = preIndexFilter.without(expression);
                continue;
            }
            if (postIndexFilter.getExpressions().contains(expression)) {
                postIndexFilter = postIndexFilter.without(expression);
            }
            for (StorageAttachedIndex index : indexes) {
                if (!index.supportsExpression(expression.column(), expression.operator())) continue;
                selectedIndexesBuilder.add((Object)index);
            }
        }
        ImmutableSet selectedIndexes = selectedIndexesBuilder.build();
        if (selectedIndexes.isEmpty()) {
            return null;
        }
        return new StorageAttachedIndexQueryPlan(cfs, queryMetrics, postIndexFilter, preIndexFilter, (ImmutableSet<Index>)selectedIndexes);
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getEstimatedResultRows() {
        return Long.MIN_VALUE;
    }

    @Override
    public boolean shouldEstimateInitialConcurrency() {
        return false;
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) {
        return new StorageAttachedIndexSearcher(this.cfs, this.queryMetrics, command, this.filterOperation, DatabaseDescriptor.getRangeRpcTimeout(TimeUnit.MILLISECONDS));
    }

    @Override
    public Function<PartitionIterator, PartitionIterator> postProcessor(ReadCommand command) {
        if (!this.isTopK()) {
            return partitions -> partitions;
        }
        return partitions -> (PartitionIterator)new VectorTopKProcessor(command).filter(partitions);
    }

    @Override
    public RowFilter postIndexQueryFilter() {
        return this.postIndexFilter;
    }

    @Override
    public boolean isTopK() {
        return this.isTopK;
    }
}

