/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.ListMultimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.Operation;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.FBUtilities;

public class FilterTree {
    protected final Operation.BooleanOperator op;
    protected final ListMultimap<ColumnMetadata, Expression> expressions;
    protected final List<FilterTree> children = new ArrayList<FilterTree>();

    FilterTree(Operation.BooleanOperator operation, ListMultimap<ColumnMetadata, Expression> expressions) {
        this.op = operation;
        this.expressions = expressions;
    }

    void addChild(FilterTree child) {
        this.children.add(child);
    }

    public boolean isSatisfiedBy(DecoratedKey key, Unfiltered unfiltered, Row staticRow) {
        boolean result = this.localSatisfiedBy(key, unfiltered, staticRow);
        for (FilterTree child : this.children) {
            result = this.op.apply(result, child.isSatisfiedBy(key, unfiltered, staticRow));
        }
        return result;
    }

    private boolean localSatisfiedBy(DecoratedKey key, Unfiltered unfiltered, Row staticRow) {
        if (unfiltered == null || !unfiltered.isRow()) {
            return false;
        }
        long now = FBUtilities.nowInSeconds();
        boolean result = this.op == Operation.BooleanOperator.AND;
        for (ColumnMetadata column : this.expressions.keySet()) {
            Row row = column.kind == ColumnMetadata.Kind.STATIC ? staticRow : (Row)unfiltered;
            List filters = this.expressions.get((Object)column);
            ListIterator filterIterator = filters.listIterator(filters.size());
            while (filterIterator.hasPrevious()) {
                Expression filter = (Expression)filterIterator.previous();
                if (filter.getIndexTermType().isNonFrozenCollection()) {
                    Iterator<ByteBuffer> valueIterator = filter.getIndexTermType().valuesOf(row, now);
                    result = this.op.apply(result, this.collectionMatch(valueIterator, filter));
                } else {
                    ByteBuffer value = filter.getIndexTermType().valueOf(key, row, now);
                    result = this.op.apply(result, this.singletonMatch(value, filter));
                }
                if (this.op != Operation.BooleanOperator.AND || result) continue;
                return false;
            }
        }
        return result;
    }

    private boolean singletonMatch(ByteBuffer value, Expression filter) {
        return value != null && filter.isSatisfiedBy(value);
    }

    private boolean collectionMatch(Iterator<ByteBuffer> valueIterator, Expression filter) {
        if (valueIterator == null) {
            return false;
        }
        while (valueIterator.hasNext()) {
            ByteBuffer value = valueIterator.next();
            if (value == null || !filter.isSatisfiedBy(value)) continue;
            return true;
        }
        return false;
    }
}

