/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.AbstractGuavaIterator;

public class KeyRangeUnionIterator
extends KeyRangeIterator {
    private final List<KeyRangeIterator> ranges;
    private final List<KeyRangeIterator> candidates;

    private KeyRangeUnionIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges) {
        super(statistics);
        this.ranges = ranges;
        this.candidates = new ArrayList<KeyRangeIterator>(ranges.size());
    }

    @Override
    public PrimaryKey computeNext() {
        this.candidates.clear();
        PrimaryKey candidate = null;
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) continue;
            while (this.next != null && range.hasNext() && ((PrimaryKey)range.peek()).compareTo(this.getCurrent()) == 0) {
                range.next();
            }
            if (!range.hasNext()) continue;
            if (candidate == null) {
                candidate = (PrimaryKey)range.peek();
                this.candidates.add(range);
                continue;
            }
            int cmp = candidate.compareTo((PrimaryKey)range.peek());
            if (cmp == 0) {
                this.candidates.add(range);
                continue;
            }
            if (cmp <= 0) continue;
            this.candidates.clear();
            candidate = (PrimaryKey)range.peek();
            this.candidates.add(range);
        }
        if (this.candidates.isEmpty()) {
            return (PrimaryKey)this.endOfData();
        }
        this.candidates.forEach(AbstractGuavaIterator::next);
        return candidate;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) continue;
            range.skipTo(nextKey);
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.ranges);
    }

    public static Builder builder(int size) {
        return new Builder(size);
    }

    public static KeyRangeIterator build(List<KeyRangeIterator> keys) {
        return new Builder(keys.size()).add(keys).build();
    }

    private static class UnionStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private UnionStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            this.min = KeyRangeIterator.nullSafeMin(this.min, range.getMinimum());
            this.max = KeyRangeIterator.nullSafeMax(this.max, range.getMaximum());
            this.count += range.getCount();
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        protected final List<KeyRangeIterator> rangeIterators;

        Builder(int size) {
            super(new UnionStatistics());
            this.rangeIterators = new ArrayList<KeyRangeIterator>(size);
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getCount() > 0L) {
                this.rangeIterators.add(range);
                this.statistics.update(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            return this;
        }

        @Override
        public int rangeCount() {
            return this.rangeIterators.size();
        }

        @Override
        public void cleanup() {
            FileUtils.closeQuietly(this.rangeIterators);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            if (this.rangeCount() == 1) {
                return this.rangeIterators.get(0);
            }
            return new KeyRangeUnionIterator(this.statistics, this.rangeIterators);
        }
    }
}

