/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRangeIntersectionIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(KeyRangeIntersectionIterator.class);
    private final List<KeyRangeIterator> ranges;

    private KeyRangeIntersectionIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges) {
        super(statistics);
        this.ranges = ranges;
    }

    @Override
    protected PrimaryKey computeNext() {
        int alreadyAvanced = -1;
        PrimaryKey highestKey = this.getCurrent();
        block0: while (highestKey != null && highestKey.compareTo(this.getMaximum()) <= 0) {
            for (int index = 0; index < this.ranges.size(); ++index) {
                if (index == alreadyAvanced) continue;
                KeyRangeIterator range = this.ranges.get(index);
                PrimaryKey nextKey = this.nextOrNull(range, highestKey);
                if (nextKey == null || nextKey.compareTo(highestKey) > 0) {
                    highestKey = nextKey;
                    alreadyAvanced = index;
                    continue block0;
                }
                assert (nextKey.compareTo(highestKey) == 0) : String.format("skipped to an item smaller than the target; iterator: %s, target key: %s, returned key: %s", range, highestKey, nextKey);
            }
            return highestKey;
        }
        return (PrimaryKey)this.endOfData();
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        for (KeyRangeIterator range : this.ranges) {
            if (!range.hasNext()) continue;
            range.skipTo(nextKey);
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.ranges);
    }

    private PrimaryKey nextOrNull(KeyRangeIterator iterator, PrimaryKey minKey) {
        iterator.skipTo(minKey);
        return iterator.hasNext() ? (PrimaryKey)iterator.next() : null;
    }

    public static Builder builder(int size) {
        return new Builder(size);
    }

    @VisibleForTesting
    public static Builder builder(int size, int limit) {
        return new Builder(size, limit);
    }

    @VisibleForTesting
    protected static boolean isDisjoint(KeyRangeIterator a, KeyRangeIterator b) {
        return KeyRangeIntersectionIterator.isDisjointInternal(a.getCurrent(), a.getMaximum(), b);
    }

    private static boolean isDisjointInternal(PrimaryKey min, PrimaryKey max, KeyRangeIterator b) {
        return min == null || max == null || b.getCount() == 0L || min.compareTo(b.getMaximum()) > 0 || b.getCurrent().compareTo(max) > 0;
    }

    static {
        logger.info(String.format("Storage attached index intersection clause limit is %d", CassandraRelevantProperties.SAI_INTERSECTION_CLAUSE_LIMIT.getInt()));
    }

    private static class IntersectionStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private boolean empty = true;

        private IntersectionStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            this.min = KeyRangeIterator.nullSafeMax(this.min, range.getMinimum());
            this.max = KeyRangeIterator.nullSafeMin(this.max, range.getMaximum());
            if (this.empty) {
                this.empty = false;
                this.count = range.getCount();
            } else {
                this.count = Math.min(this.count, range.getCount());
            }
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        private final int limit;
        private boolean isDisjoint;
        protected final List<KeyRangeIterator> rangeIterators;

        Builder(int size) {
            this(size, CassandraRelevantProperties.SAI_INTERSECTION_CLAUSE_LIMIT.getInt());
        }

        Builder(int size, int limit) {
            super(new IntersectionStatistics());
            this.rangeIterators = new ArrayList<KeyRangeIterator>(size);
            this.limit = limit;
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getCount() > 0L) {
                this.rangeIterators.add(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            this.updateStatistics(this.statistics, range);
            return this;
        }

        @Override
        public int rangeCount() {
            return this.rangeIterators.size();
        }

        @Override
        public void cleanup() {
            FileUtils.closeQuietly(this.rangeIterators);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            this.rangeIterators.sort(Comparator.comparingLong(KeyRangeIterator::getCount));
            int initialSize = this.rangeIterators.size();
            if (this.limit >= this.rangeIterators.size() || this.limit <= 0) {
                return this.buildIterator(this.statistics, this.rangeIterators);
            }
            IntersectionStatistics selectiveStatistics = new IntersectionStatistics();
            this.isDisjoint = false;
            for (int i = this.rangeIterators.size() - 1; i >= 0 && i >= this.limit; --i) {
                FileUtils.closeQuietly(this.rangeIterators.remove(i));
            }
            this.rangeIterators.forEach(range -> this.updateStatistics(selectiveStatistics, (KeyRangeIterator)range));
            if (Tracing.isTracing()) {
                Tracing.trace("Selecting {} {} of {} out of {} indexes", this.rangeIterators.size(), this.rangeIterators.size() > 1 ? "indexes with cardinalities" : "index with cardinality", this.rangeIterators.stream().map(KeyRangeIterator::getCount).map(Object::toString).collect(Collectors.joining(", ")), initialSize);
            }
            return this.buildIterator(selectiveStatistics, this.rangeIterators);
        }

        public boolean isDisjoint() {
            return this.isDisjoint;
        }

        private KeyRangeIterator buildIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges) {
            if (this.isDisjoint) {
                FileUtils.closeQuietly(ranges);
                return KeyRangeIterator.empty();
            }
            if (ranges.size() == 1) {
                return ranges.get(0);
            }
            return new KeyRangeIntersectionIterator(statistics, ranges);
        }

        private void updateStatistics(KeyRangeIterator.Builder.Statistics statistics, KeyRangeIterator range) {
            statistics.update(range);
            this.isDisjoint |= KeyRangeIntersectionIterator.isDisjointInternal(statistics.min, statistics.max, range);
        }
    }
}

