/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.IndexWriterConfig;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeRamBuffer;
import org.apache.cassandra.index.sai.disk.v1.bbtree.NumericIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.trie.LiteralIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.vector.OnHeapGraph;
import org.apache.cassandra.index.sai.memory.RAMStringIndexer;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.index.sai.utils.NamedMemoryLimiter;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.lucene.util.BytesRefBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class SegmentBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SegmentBuilder.class);
    public static final long LAST_VALID_SEGMENT_ROW_ID = 0x3FFFFFFEL;
    private static long testLastValidSegmentRowId = -1L;
    private static final AtomicInteger ACTIVE_BUILDER_COUNT = new AtomicInteger(0);
    private static volatile long minimumFlushBytes;
    private final NamedMemoryLimiter limiter;
    private final long lastValidSegmentRowID;
    private boolean flushed = false;
    private boolean active = true;
    private long minSSTableRowId = -1L;
    private long maxSSTableRowId = -1L;
    private long segmentRowIdOffset = 0L;
    private PrimaryKey minKey;
    private PrimaryKey maxKey;
    private ByteBuffer minTerm;
    private ByteBuffer maxTerm;
    final IndexTermType indexTermType;
    long totalBytesAllocated;
    int rowCount = 0;
    int maxSegmentRowId = -1;

    public static int getActiveBuilderCount() {
        return ACTIVE_BUILDER_COUNT.get();
    }

    private SegmentBuilder(IndexTermType indexTermType, NamedMemoryLimiter limiter) {
        this.indexTermType = indexTermType;
        this.limiter = limiter;
        this.lastValidSegmentRowID = testLastValidSegmentRowId >= 0L ? testLastValidSegmentRowId : 0x3FFFFFFEL;
        minimumFlushBytes = limiter.limitBytes() / (long)ACTIVE_BUILDER_COUNT.incrementAndGet();
    }

    public SegmentMetadata flush(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
        assert (!this.flushed) : "Cannot flush an already flushed segment";
        this.flushed = true;
        if (this.getRowCount() == 0) {
            logger.warn(indexIdentifier.logMessage("No rows to index during flush of SSTable {}."), (Object)indexDescriptor.sstableDescriptor);
            return null;
        }
        SegmentMetadata.ComponentMetadataMap indexMetas = this.flushInternal(indexDescriptor, indexIdentifier);
        return new SegmentMetadata(this.segmentRowIdOffset, this.rowCount, this.minSSTableRowId, this.maxSSTableRowId, this.minKey, this.maxKey, this.minTerm, this.maxTerm, indexMetas);
    }

    public long add(ByteBuffer term, PrimaryKey key, long sstableRowId) {
        assert (!this.flushed) : "Cannot add to a flushed segment.";
        assert (sstableRowId >= this.maxSSTableRowId);
        this.minSSTableRowId = this.minSSTableRowId < 0L ? sstableRowId : this.minSSTableRowId;
        this.maxSSTableRowId = sstableRowId;
        assert (this.maxKey == null || this.maxKey.compareTo(key) <= 0);
        if (this.minKey == null) {
            this.minKey = key;
        }
        this.maxKey = key;
        this.minTerm = this.indexTermType.min(term, this.minTerm);
        this.maxTerm = this.indexTermType.max(term, this.maxTerm);
        if (this.rowCount == 0) {
            this.segmentRowIdOffset = sstableRowId;
        }
        ++this.rowCount;
        int segmentRowId = SegmentBuilder.castToSegmentRowId(sstableRowId, this.segmentRowIdOffset);
        this.maxSegmentRowId = Math.max(this.maxSegmentRowId, segmentRowId);
        long bytesAllocated = this.addInternal(term, segmentRowId);
        this.totalBytesAllocated += bytesAllocated;
        return bytesAllocated;
    }

    public static int castToSegmentRowId(long sstableRowId, long segmentRowIdOffset) {
        return Math.toIntExact(sstableRowId - segmentRowIdOffset);
    }

    public long totalBytesAllocated() {
        return this.totalBytesAllocated;
    }

    public boolean hasReachedMinimumFlushSize() {
        return this.totalBytesAllocated >= minimumFlushBytes;
    }

    public long getMinimumFlushBytes() {
        return minimumFlushBytes;
    }

    public long release(IndexIdentifier indexIdentifier) {
        if (this.active) {
            minimumFlushBytes = this.limiter.limitBytes() / (long)ACTIVE_BUILDER_COUNT.getAndDecrement();
            long used = this.limiter.decrement(this.totalBytesAllocated);
            this.active = false;
            return used;
        }
        logger.warn(indexIdentifier.logMessage("Attempted to release storage-attached index segment builder memory after builder marked inactive."));
        return this.limiter.currentBytesUsed();
    }

    public abstract boolean isEmpty();

    protected abstract long addInternal(ByteBuffer var1, int var2);

    protected abstract SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor var1, IndexIdentifier var2) throws IOException;

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean exceedsSegmentLimit(long ssTableRowId) {
        if (this.getRowCount() == 0) {
            return false;
        }
        return ssTableRowId - this.segmentRowIdOffset > this.lastValidSegmentRowID;
    }

    @VisibleForTesting
    public static void updateLastValidSegmentRowId(long lastValidSegmentRowID) {
        testLastValidSegmentRowId = lastValidSegmentRowID;
    }

    public static class VectorSegmentBuilder
    extends SegmentBuilder {
        private final OnHeapGraph<Integer> graphIndex;

        public VectorSegmentBuilder(IndexTermType indexTermType, NamedMemoryLimiter limiter, IndexWriterConfig indexWriterConfig) {
            super(indexTermType, limiter);
            this.graphIndex = new OnHeapGraph(indexTermType.indexType(), indexWriterConfig, false);
        }

        @Override
        public boolean isEmpty() {
            return this.graphIndex.isEmpty();
        }

        @Override
        protected long addInternal(ByteBuffer term, int segmentRowId) {
            return this.graphIndex.add(term, segmentRowId, OnHeapGraph.InvalidVectorBehavior.IGNORE);
        }

        @Override
        protected SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
            return this.graphIndex.writeData(indexDescriptor, indexIdentifier, p -> p);
        }
    }

    public static class RAMStringSegmentBuilder
    extends SegmentBuilder {
        final RAMStringIndexer ramIndexer;
        final BytesRefBuilder stringBuffer = new BytesRefBuilder();

        public RAMStringSegmentBuilder(IndexTermType indexTermType, NamedMemoryLimiter limiter) {
            super(indexTermType, limiter);
            this.ramIndexer = new RAMStringIndexer();
            this.totalBytesAllocated = this.ramIndexer.estimatedBytesUsed();
        }

        @Override
        public boolean isEmpty() {
            return this.ramIndexer.isEmpty();
        }

        @Override
        protected long addInternal(ByteBuffer term, int segmentRowId) {
            this.copyBufferToBytesRef(term, this.stringBuffer);
            return this.ramIndexer.add(this.stringBuffer.get(), segmentRowId);
        }

        @Override
        protected SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
            try (LiteralIndexWriter writer = new LiteralIndexWriter(indexDescriptor, indexIdentifier);){
                SegmentMetadata.ComponentMetadataMap componentMetadataMap = writer.writeCompleteSegment(this.ramIndexer.getTermsWithPostings());
                return componentMetadataMap;
            }
        }

        private void copyBufferToBytesRef(ByteBuffer buffer, BytesRefBuilder stringBuffer) {
            int length = buffer.remaining();
            stringBuffer.clear();
            stringBuffer.grow(length);
            FastByteOperations.copy(buffer, buffer.position(), stringBuffer.bytes(), 0, length);
            stringBuffer.setLength(length);
        }
    }

    public static class BlockBalancedTreeSegmentBuilder
    extends SegmentBuilder {
        private final byte[] scratch;
        private final BlockBalancedTreeRamBuffer trieBuffer;

        public BlockBalancedTreeSegmentBuilder(IndexTermType indexTermType, NamedMemoryLimiter limiter) {
            super(indexTermType, limiter);
            this.scratch = new byte[indexTermType.fixedSizeOf()];
            this.trieBuffer = new BlockBalancedTreeRamBuffer(indexTermType.fixedSizeOf());
            this.totalBytesAllocated = this.trieBuffer.memoryUsed();
        }

        @Override
        public boolean isEmpty() {
            return this.trieBuffer.numRows() == 0;
        }

        @Override
        protected long addInternal(ByteBuffer term, int segmentRowId) {
            this.indexTermType.toComparableBytes(term, this.scratch);
            return this.trieBuffer.add(segmentRowId, this.scratch);
        }

        @Override
        protected SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
            NumericIndexWriter writer = new NumericIndexWriter(indexDescriptor, indexIdentifier, this.indexTermType.fixedSizeOf(), this.maxSegmentRowId);
            return writer.writeCompleteSegment(this.trieBuffer.iterator());
        }
    }
}

