/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SSTableRowIdKeyRangeIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Stopwatch timeToExhaust = Stopwatch.createStarted();
    private final QueryContext queryContext;
    private final PrimaryKeyMap primaryKeyMap;
    private final PostingList postingList;
    private boolean needsSkipping = false;
    private PrimaryKey skipToToken = null;

    private SSTableRowIdKeyRangeIterator(PrimaryKey min, PrimaryKey max, long count, PrimaryKeyMap primaryKeyMap, QueryContext queryContext, PostingList postingList) {
        super(min, max, count);
        this.primaryKeyMap = primaryKeyMap;
        this.queryContext = queryContext;
        this.postingList = postingList;
    }

    public static KeyRangeIterator create(PrimaryKeyMap primaryKeyMap, QueryContext queryContext, PostingList postingList) {
        if (postingList.size() <= 0L) {
            return KeyRangeIterator.empty();
        }
        PrimaryKey min = primaryKeyMap.primaryKeyFromRowId(postingList.minimum());
        PrimaryKey max = primaryKeyMap.primaryKeyFromRowId(postingList.maximum());
        return new SSTableRowIdKeyRangeIterator(min, max, postingList.size(), primaryKeyMap, queryContext, postingList);
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        if (this.skipToToken != null && this.skipToToken.compareTo(nextKey) >= 0) {
            return;
        }
        this.skipToToken = nextKey;
        this.needsSkipping = true;
    }

    @Override
    protected PrimaryKey computeNext() {
        try {
            this.queryContext.checkpoint();
            if (this.exhausted()) {
                return (PrimaryKey)this.endOfData();
            }
            long rowId = this.getNextRowId();
            if (rowId == Long.MAX_VALUE) {
                return (PrimaryKey)this.endOfData();
            }
            return this.primaryKeyMap.primaryKeyFromRowId(rowId);
        }
        catch (Throwable t) {
            if (!(t instanceof QueryCancelledException)) {
                logger.error("Unable to provide next token!", t);
            }
            throw Throwables.cleaned(t);
        }
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            long exhaustedInMills = this.timeToExhaust.stop().elapsed(TimeUnit.MILLISECONDS);
            logger.trace("PostinListRangeIterator exhausted after {} ms", (Object)exhaustedInMills);
        }
        FileUtils.closeQuietly(Arrays.asList(this.postingList, this.primaryKeyMap));
    }

    private boolean exhausted() {
        return this.needsSkipping && this.skipToToken.compareTo(this.getMaximum()) > 0;
    }

    private long getNextRowId() throws IOException {
        long sstableRowId;
        if (this.needsSkipping) {
            long targetRowID = this.primaryKeyMap.rowIdFromPrimaryKey(this.skipToToken);
            if (targetRowID < 0L) {
                return Long.MAX_VALUE;
            }
            sstableRowId = this.postingList.advance(targetRowID);
            this.needsSkipping = false;
        } else {
            sstableRowId = this.postingList.nextPosting();
        }
        return sstableRowId;
    }
}

