/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.TargetParser;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndexBuilder;
import org.apache.cassandra.index.sai.StorageAttachedIndexBuildingSupport;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.v1.IndexWriterConfig;
import org.apache.cassandra.index.sai.memory.MemtableIndexManager;
import org.apache.cassandra.index.sai.metrics.ColumnQueryMetrics;
import org.apache.cassandra.index.sai.metrics.IndexMetrics;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.view.IndexViewManager;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAttachedIndex
implements Index {
    public static final String NAME = "sai";
    public static final String VECTOR_USAGE_WARNING = "SAI ANN indexes on vector columns are experimental and are not recommended for production use.\nThey don't yet support SELECT queries with:\n * Consistency level higher than ONE/LOCAL_ONE.\n * Paging.\n * No LIMIT clauses.\n * PER PARTITION LIMIT clauses.\n * GROUP BY clauses.\n * Aggregation functions.\n * Filters on columns without a SAI index.";
    public static final String VECTOR_NON_FLOAT_ERROR = "SAI ANN indexes are only allowed on vector columns with float elements";
    public static final String VECTOR_1_DIMENSION_COSINE_ERROR = "Cosine similarity is not supported for single-dimension vectors";
    public static final String VECTOR_MULTIPLE_DATA_DIRECTORY_ERROR = "SAI ANN indexes are not allowed on multiple data directories";
    @VisibleForTesting
    public static final String ANALYSIS_ON_KEY_COLUMNS_MESSAGE = "Analysis options are not supported on primary key columns, but found ";
    public static final String ANN_LIMIT_ERROR = "Use of ANN OF in an ORDER BY clause requires a LIMIT that is not greater than %s. LIMIT was %s";
    private static final Logger logger = LoggerFactory.getLogger(StorageAttachedIndex.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    public static final long MAX_STRING_TERM_SIZE = CassandraRelevantProperties.SAI_MAX_STRING_TERM_SIZE.getSizeInBytes();
    public static final long MAX_FROZEN_TERM_SIZE = CassandraRelevantProperties.SAI_MAX_FROZEN_TERM_SIZE.getSizeInBytes();
    public static final long MAX_VECTOR_TERM_SIZE = CassandraRelevantProperties.SAI_MAX_VECTOR_TERM_SIZE.getSizeInBytes();
    public static final String TERM_OVERSIZE_MESSAGE = "Can't add term of column %s to index for key: %s, term size %s max allowed size %s, use analyzed = true (if not yet set) for that column.";
    private static final StorageAttachedIndexBuildingSupport INDEX_BUILDER_SUPPORT = new StorageAttachedIndexBuildingSupport();
    private static final Set<String> VALID_OPTIONS = ImmutableSet.of((Object)"target", (Object)"class_name", (Object)"maximum_node_connections", (Object)"construction_beam_width", (Object)"similarity_function", (Object)"optimize_for", (Object[])new String[]{"case_sensitive", "normalize", "ascii"});
    public static final Set<CQL3Type> SUPPORTED_TYPES = ImmutableSet.of((Object)CQL3Type.Native.ASCII, (Object)CQL3Type.Native.BIGINT, (Object)CQL3Type.Native.DATE, (Object)CQL3Type.Native.DOUBLE, (Object)CQL3Type.Native.FLOAT, (Object)CQL3Type.Native.INT, (Object[])new CQL3Type[]{CQL3Type.Native.SMALLINT, CQL3Type.Native.TEXT, CQL3Type.Native.TIME, CQL3Type.Native.TIMESTAMP, CQL3Type.Native.TIMEUUID, CQL3Type.Native.TINYINT, CQL3Type.Native.UUID, CQL3Type.Native.VARCHAR, CQL3Type.Native.INET, CQL3Type.Native.VARINT, CQL3Type.Native.DECIMAL, CQL3Type.Native.BOOLEAN});
    private static final Set<Class<? extends IPartitioner>> ILLEGAL_PARTITIONERS = ImmutableSet.of(OrderPreservingPartitioner.class, LocalPartitioner.class, ByteOrderedPartitioner.class, RandomPartitioner.class);
    private final ColumnFamilyStore baseCfs;
    private final IndexMetadata indexMetadata;
    private final IndexTermType indexTermType;
    private final IndexIdentifier indexIdentifier;
    private final IndexViewManager viewManager;
    private final ColumnQueryMetrics columnQueryMetrics;
    private final IndexWriterConfig indexWriterConfig;
    @Nullable
    private final AbstractAnalyzer.AnalyzerFactory analyzerFactory;
    private final PrimaryKey.Factory primaryKeyFactory;
    private final MemtableIndexManager memtableIndexManager;
    private final IndexMetrics indexMetrics;
    private final long maxTermSize;
    private volatile boolean initBuildStarted = false;
    private volatile boolean valid = true;

    public StorageAttachedIndex(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
        this.baseCfs = baseCfs;
        this.indexMetadata = indexMetadata;
        TableMetadata tableMetadata = baseCfs.metadata();
        Pair<ColumnMetadata, IndexTarget.Type> target = TargetParser.parse(tableMetadata, indexMetadata);
        this.indexTermType = IndexTermType.create((ColumnMetadata)target.left, tableMetadata.partitionKeyColumns(), (IndexTarget.Type)((Object)target.right));
        this.indexIdentifier = new IndexIdentifier(baseCfs.getKeyspaceName(), baseCfs.getTableName(), indexMetadata.name);
        this.primaryKeyFactory = new PrimaryKey.Factory(tableMetadata.partitioner, tableMetadata.comparator);
        this.indexWriterConfig = IndexWriterConfig.fromOptions(indexMetadata.name, this.indexTermType, indexMetadata.options);
        this.viewManager = new IndexViewManager(this);
        this.columnQueryMetrics = this.indexTermType.isLiteral() ? new ColumnQueryMetrics.TrieIndexMetrics(this.indexIdentifier) : new ColumnQueryMetrics.BalancedTreeIndexMetrics(this.indexIdentifier);
        this.analyzerFactory = AbstractAnalyzer.fromOptions(this.indexTermType, indexMetadata.options);
        this.memtableIndexManager = new MemtableIndexManager(this);
        this.indexMetrics = new IndexMetrics(this, this.memtableIndexManager);
        this.maxTermSize = this.indexTermType.isVector() ? MAX_VECTOR_TERM_SIZE : (this.indexTermType.isFrozen() ? MAX_FROZEN_TERM_SIZE : MAX_STRING_TERM_SIZE);
    }

    public static Map<String, String> validateOptions(Map<String, String> options, TableMetadata metadata) {
        HashMap<String, String> unknown = new HashMap<String, String>(2);
        for (Map.Entry<String, String> option : options.entrySet()) {
            if (VALID_OPTIONS.contains(option.getKey())) continue;
            unknown.put(option.getKey(), option.getValue());
        }
        if (!unknown.isEmpty()) {
            return unknown;
        }
        if (ILLEGAL_PARTITIONERS.contains(metadata.partitioner.getClass())) {
            throw new InvalidRequestException("Storage-attached index does not support the following IPartitioner implementations: " + ILLEGAL_PARTITIONERS);
        }
        String targetColumn = options.get("target");
        if (targetColumn == null) {
            throw new InvalidRequestException("Missing target column");
        }
        if (targetColumn.split(",").length > 1) {
            throw new InvalidRequestException("A storage-attached index cannot be created over multiple columns: " + targetColumn);
        }
        Pair<ColumnMetadata, IndexTarget.Type> target = TargetParser.parse(metadata, targetColumn);
        if (target == null) {
            throw new InvalidRequestException("Failed to retrieve target column for: " + targetColumn);
        }
        if (metadata.indexes.stream().filter(index -> index.getIndexClassName().equals(StorageAttachedIndex.class.getName())).map(index -> TargetParser.parse(metadata, index.options.get("target"))).filter(Objects::nonNull).filter(t -> t.equals(target)).count() > 1L) {
            throw new InvalidRequestException("Cannot create more than one storage-attached index on the same column: " + target.left);
        }
        Map<String, String> analysisOptions = AbstractAnalyzer.getAnalyzerOptions(options);
        if (((ColumnMetadata)target.left).isPrimaryKeyColumn() && !analysisOptions.isEmpty()) {
            throw new InvalidRequestException(ANALYSIS_ON_KEY_COLUMNS_MESSAGE + new CqlBuilder().append(analysisOptions));
        }
        IndexTermType indexTermType = IndexTermType.create((ColumnMetadata)target.left, metadata.partitionKeyColumns(), (IndexTarget.Type)((Object)target.right));
        AbstractAnalyzer.fromOptions(indexTermType, analysisOptions);
        IndexWriterConfig config = IndexWriterConfig.fromOptions(null, indexTermType, options);
        if (indexTermType.isComposite()) {
            for (IndexTermType subType : indexTermType.subTypes()) {
                if (SUPPORTED_TYPES.contains(subType.asCQL3Type()) || subType.isFrozen()) continue;
                throw new InvalidRequestException("Unsupported type: " + subType.asCQL3Type());
            }
        } else {
            if (!SUPPORTED_TYPES.contains(indexTermType.asCQL3Type()) && !indexTermType.isFrozen()) {
                throw new InvalidRequestException("Unsupported type: " + indexTermType.asCQL3Type());
            }
            if (indexTermType.isVector()) {
                if (!(indexTermType.vectorElementType() instanceof FloatType)) {
                    throw new InvalidRequestException(VECTOR_NON_FLOAT_ERROR);
                }
                if (indexTermType.vectorDimension() == 1 && config.getSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                    throw new InvalidRequestException(VECTOR_1_DIMENSION_COSINE_ERROR);
                }
                if (DatabaseDescriptor.getRawConfig().data_file_directories.length > 1) {
                    throw new InvalidRequestException(VECTOR_MULTIPLE_DATA_DIRECTORY_ERROR);
                }
                ClientWarn.instance.warn(VECTOR_USAGE_WARNING);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void register(IndexRegistry registry) {
        registry.registerIndex(this, StorageAttachedIndexGroup.GROUP_KEY, () -> new StorageAttachedIndexGroup(this.baseCfs));
    }

    @Override
    public void unregister(IndexRegistry registry) {
        registry.unregisterIndex(this, StorageAttachedIndexGroup.GROUP_KEY);
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public Callable<?> getInitializationTask() {
        IndexValidation validation = StorageService.instance.isStarting() ? IndexValidation.HEADER_FOOTER : IndexValidation.NONE;
        return () -> this.startInitialBuild(this.baseCfs, validation).get();
    }

    @Override
    public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
        return null;
    }

    @Override
    public Callable<?> getBlockingFlushTask() {
        return null;
    }

    @Override
    public Callable<?> getInvalidateTask() {
        return () -> {
            this.valid = false;
            Set<Component> toRemove = this.getComponents();
            for (SSTableIndex sstableIndex : this.view().getIndexes()) {
                sstableIndex.getSSTable().unregisterComponents(toRemove, this.baseCfs.getTracker());
            }
            this.viewManager.invalidate();
            if (this.analyzerFactory != null) {
                this.analyzerFactory.close();
            }
            this.columnQueryMetrics.release();
            this.memtableIndexManager.invalidate();
            this.indexMetrics.release();
            return null;
        };
    }

    @Override
    public Callable<?> getPreJoinTask(boolean hadBootstrap) {
        return this::startPreJoinTask;
    }

    @Override
    public Callable<?> getTruncateTask(long truncatedAt) {
        return () -> {
            logger.info(this.indexIdentifier.logMessage("Making index queryable during table truncation"));
            this.baseCfs.indexManager.makeIndexQueryable(this, Index.Status.BUILD_SUCCEEDED);
            return null;
        };
    }

    @Override
    public boolean shouldBuildBlocking() {
        return true;
    }

    @Override
    public boolean isSSTableAttached() {
        return true;
    }

    @Override
    public Optional<ColumnFamilyStore> getBackingTable() {
        return Optional.empty();
    }

    @Override
    public boolean dependsOn(ColumnMetadata column) {
        return this.indexTermType.dependsOn(column);
    }

    @Override
    public boolean supportsExpression(ColumnMetadata column, Operator operator) {
        return this.dependsOn(column) && this.indexTermType.supports(operator);
    }

    @Override
    public boolean filtersMultipleContains() {
        return false;
    }

    @Override
    public AbstractType<?> customExpressionValueType() {
        return null;
    }

    @Override
    public RowFilter getPostIndexQueryFilter(RowFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<ByteBuffer> getPostQueryOrdering(Restriction restriction, QueryOptions options) {
        assert (restriction instanceof SingleColumnRestriction.AnnRestriction);
        Preconditions.checkState((boolean)this.indexTermType.isVector());
        SingleColumnRestriction.AnnRestriction annRestriction = (SingleColumnRestriction.AnnRestriction)restriction;
        VectorSimilarityFunction function = this.indexWriterConfig.getSimilarityFunction();
        float[] target = this.indexTermType.decomposeVector(annRestriction.value(options).duplicate());
        return (leftBuf, rightBuf) -> {
            float[] left = this.indexTermType.decomposeVector(leftBuf.duplicate());
            double scoreLeft = function.compare(left, target);
            float[] right = this.indexTermType.decomposeVector(rightBuf.duplicate());
            double scoreRight = function.compare(right, target);
            return Double.compare(scoreRight, scoreLeft);
        };
    }

    @Override
    public void validate(ReadCommand command) throws InvalidRequestException {
        if (!this.indexTermType.isVector()) {
            return;
        }
        if (command.limits().count() > IndexWriterConfig.MAX_TOP_K) {
            throw new InvalidRequestException(String.format(ANN_LIMIT_ERROR, IndexWriterConfig.MAX_TOP_K, command.limits().count()));
        }
    }

    @Override
    public long getEstimatedResultRows() {
        throw new UnsupportedOperationException("Use StorageAttachedIndexQueryPlan#getEstimatedResultRows() instead.");
    }

    @Override
    public boolean isQueryable(Index.Status status) {
        return status == Index.Status.BUILD_SUCCEEDED || status == Index.Status.UNKNOWN;
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
        DecoratedKey key = update.partitionKey();
        for (Row row : update) {
            this.validateMaxTermSizeForRow(key, row, true);
        }
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker) {
        throw new UnsupportedOperationException("Storage-attached index flush observers should never be created directly.");
    }

    @Override
    public Set<Component> getComponents() {
        return Version.LATEST.onDiskFormat().perColumnIndexComponents(this.indexTermType).stream().map(c -> Version.LATEST.makePerIndexComponent((IndexComponent)((Object)c), this.indexIdentifier)).collect(Collectors.toSet());
    }

    @Override
    public Index.Indexer indexerFor(DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext writeContext, IndexTransaction.Type transactionType, Memtable memtable) {
        if (transactionType == IndexTransaction.Type.UPDATE) {
            return new UpdateIndexer(key, memtable, writeContext);
        }
        return null;
    }

    @Override
    public Index.IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    @VisibleForTesting
    public static List<List<SSTableReader>> groupBySize(List<SSTableReader> toRebuild, int parallelism) {
        ArrayList<List<SSTableReader>> groups = new ArrayList<List<SSTableReader>>();
        toRebuild.sort(Comparator.comparingLong(SSTableReader::onDiskLength).reversed());
        Iterator<SSTableReader> sortedSSTables = toRebuild.iterator();
        double dataPerCompactor = (double)toRebuild.stream().mapToLong(SSTableReader::onDiskLength).sum() * 1.0 / (double)parallelism;
        while (sortedSSTables.hasNext()) {
            long sum = 0L;
            ArrayList<SSTableReader> current = new ArrayList<SSTableReader>();
            while (sortedSSTables.hasNext() && (double)sum < dataPerCompactor) {
                SSTableReader sstable = sortedSSTables.next();
                sum += sstable.onDiskLength();
                current.add(sstable);
            }
            assert (!current.isEmpty());
            groups.add(current);
        }
        return groups;
    }

    public Collection<SSTableContext> onSSTableChanged(Collection<SSTableReader> oldSSTables, Collection<SSTableContext> newSSTables, IndexValidation validation) {
        return this.viewManager.update(oldSSTables, newSSTables, validation);
    }

    public void drop(Collection<SSTableReader> sstablesToRebuild) {
        this.viewManager.drop(sstablesToRebuild);
    }

    public MemtableIndexManager memtableIndexManager() {
        return this.memtableIndexManager;
    }

    public View view() {
        return this.viewManager.view();
    }

    public IndexTermType termType() {
        return this.indexTermType;
    }

    public IndexIdentifier identifier() {
        return this.indexIdentifier;
    }

    public PrimaryKey.Factory keyFactory() {
        return this.primaryKeyFactory;
    }

    @VisibleForTesting
    public ColumnFamilyStore baseCfs() {
        return this.baseCfs;
    }

    public IndexWriterConfig indexWriterConfig() {
        return this.indexWriterConfig;
    }

    public boolean hasAnalyzer() {
        return this.analyzerFactory != null;
    }

    public AbstractAnalyzer analyzer() {
        assert (this.analyzerFactory != null) : "Index does not support string analysis";
        return this.analyzerFactory.create();
    }

    public IndexMetrics indexMetrics() {
        return this.indexMetrics;
    }

    public ColumnQueryMetrics columnQueryMetrics() {
        return this.columnQueryMetrics;
    }

    public boolean isInitBuildStarted() {
        return this.initBuildStarted;
    }

    public BooleanSupplier isIndexValid() {
        return () -> this.valid;
    }

    public boolean hasClustering() {
        return this.baseCfs.getComparator().size() > 0;
    }

    public long cellCount() {
        return this.view().getIndexes().stream().mapToLong(SSTableIndex::getRowCount).sum();
    }

    public int openPerColumnIndexFiles() {
        return this.viewManager.view().size() * Version.LATEST.onDiskFormat().openFilesPerColumnIndex();
    }

    public long diskUsage() {
        return this.view().getIndexes().stream().mapToLong(SSTableIndex::sizeOfPerColumnComponents).sum();
    }

    public long indexFileCacheSize() {
        return this.view().getIndexes().stream().mapToLong(SSTableIndex::indexFileCacheSize).sum();
    }

    public void makeIndexNonQueryable() {
        this.baseCfs.indexManager.makeIndexNonQueryable(this, Index.Status.BUILD_FAILED);
        logger.warn(this.indexIdentifier.logMessage("Storage-attached index is no longer queryable. Please restart this node to repair it."));
    }

    public void validateMaxTermSizeForRow(DecoratedKey key, Row row, boolean sendClientWarning) {
        AbstractAnalyzer analyzer;
        AbstractAnalyzer abstractAnalyzer = analyzer = this.hasAnalyzer() ? this.analyzer() : null;
        if (this.indexTermType.isNonFrozenCollection()) {
            Iterator<ByteBuffer> bufferIterator = this.indexTermType.valuesOf(row, FBUtilities.nowInSeconds());
            while (bufferIterator != null && bufferIterator.hasNext()) {
                this.validateMaxTermSizeForCell(analyzer, key, bufferIterator.next(), sendClientWarning);
            }
        } else {
            ByteBuffer value = this.indexTermType.valueOf(key, row, FBUtilities.nowInSeconds());
            this.validateMaxTermSizeForCell(analyzer, key, value, sendClientWarning);
        }
    }

    private void validateMaxTermSizeForCell(AbstractAnalyzer analyzer, DecoratedKey key, @Nullable ByteBuffer cellBuffer, boolean sendClientWarning) {
        if (cellBuffer == null || cellBuffer.remaining() == 0) {
            return;
        }
        if ((long)cellBuffer.remaining() <= this.maxTermSize) {
            return;
        }
        if (analyzer != null) {
            analyzer.reset(cellBuffer.duplicate());
            while (analyzer.hasNext()) {
                this.validateMaxTermSize(key, analyzer.next(), sendClientWarning);
            }
        } else {
            this.validateMaxTermSize(key, cellBuffer.duplicate(), sendClientWarning);
        }
    }

    public boolean validateMaxTermSize(DecoratedKey key, ByteBuffer term, boolean sendClientWarning) {
        if ((long)term.remaining() > this.maxTermSize) {
            String message = this.indexIdentifier.logMessage(String.format(TERM_OVERSIZE_MESSAGE, this.indexTermType.columnName(), key, FBUtilities.prettyPrintMemory(term.remaining()), FBUtilities.prettyPrintMemory(this.maxTermSize)));
            if (sendClientWarning) {
                ClientWarn.instance.warn(message);
            }
            noSpamLogger.warn(message, new Object[0]);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.indexIdentifier.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StorageAttachedIndex)) {
            return false;
        }
        StorageAttachedIndex other = (StorageAttachedIndex)obj;
        return Objects.equals(this.indexTermType, other.indexTermType) && Objects.equals(this.indexMetadata, other.indexMetadata) && Objects.equals(this.baseCfs.getComparator(), other.baseCfs.getComparator());
    }

    public int hashCode() {
        return Objects.hash(this.indexTermType, this.indexMetadata, this.baseCfs.getComparator());
    }

    private Future<?> startInitialBuild(ColumnFamilyStore baseCfs, IndexValidation validation) {
        if (baseCfs.indexManager.isIndexQueryable(this)) {
            logger.debug(this.indexIdentifier.logMessage("Skipping validation and building in initialization task, as pre-join has already made the storage-attached index queryable..."));
            this.initBuildStarted = true;
            return CompletableFuture.completedFuture(null);
        }
        logger.debug(this.indexIdentifier.logMessage("Stopping active compactions to make sure all sstables are indexed after initial build."));
        CompactionManager.instance.interruptCompactionFor(Collections.singleton(baseCfs.metadata()), ssTableReader -> true, true);
        if (!baseCfs.getTracker().getView().liveMemtables.isEmpty()) {
            baseCfs.forceBlockingFlush(ColumnFamilyStore.FlushReason.INDEX_BUILD_STARTED);
        }
        this.initBuildStarted = true;
        StorageAttachedIndexGroup indexGroup = StorageAttachedIndexGroup.getIndexGroup(baseCfs);
        assert (indexGroup != null) : "Index group does not exist for table " + baseCfs.keyspace + "." + baseCfs.name;
        List<SSTableReader> nonIndexed = this.findNonIndexedSSTables(baseCfs, indexGroup, validation);
        if (nonIndexed.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List<List<SSTableReader>> groups = StorageAttachedIndex.groupBySize(nonIndexed, DatabaseDescriptor.getConcurrentIndexBuilders());
        ArrayList futures = new ArrayList();
        for (List<SSTableReader> group : groups) {
            TreeMap<SSTableReader, Set<StorageAttachedIndex>> current = new TreeMap<SSTableReader, Set<StorageAttachedIndex>>(Comparator.comparing(s -> s.descriptor.id, SSTableIdFactory.COMPARATOR));
            group.forEach(sstable -> current.put((SSTableReader)sstable, Collections.singleton(this)));
            futures.add(CompactionManager.instance.submitIndexBuild(new StorageAttachedIndexBuilder(indexGroup, current, false, true)));
        }
        logger.info(this.indexIdentifier.logMessage("Submitting {} parallel initial index builds over {} total sstables..."), (Object)futures.size(), (Object)nonIndexed.size());
        return Futures.allAsList(futures);
    }

    private Future<?> startPreJoinTask() {
        try {
            if (this.baseCfs.indexManager.isIndexQueryable(this)) {
                logger.debug(this.indexIdentifier.logMessage("Skipping validation in pre-join task, as the initialization task has already made the index queryable..."));
                this.baseCfs.indexManager.makeIndexQueryable(this, Index.Status.BUILD_SUCCEEDED);
                return null;
            }
            StorageAttachedIndexGroup indexGroup = StorageAttachedIndexGroup.getIndexGroup(this.baseCfs);
            assert (indexGroup != null) : "Index group does not exist for table";
            List<SSTableReader> nonIndexed = this.findNonIndexedSSTables(this.baseCfs, indexGroup, IndexValidation.HEADER_FOOTER);
            if (nonIndexed.isEmpty()) {
                this.baseCfs.indexManager.makeIndexQueryable(this, Index.Status.BUILD_SUCCEEDED);
            }
        }
        catch (Throwable t) {
            logger.error(this.indexIdentifier.logMessage("Failed in pre-join task!"), t);
        }
        return null;
    }

    private synchronized List<SSTableReader> findNonIndexedSSTables(ColumnFamilyStore baseCfs, StorageAttachedIndexGroup group, IndexValidation validation) {
        Set<SSTableReader> sstables = baseCfs.getLiveSSTables();
        assert (group != null) : "Missing index group on " + baseCfs.name;
        group.onSSTableChanged(Collections.emptyList(), sstables, Collections.singleton(this), validation);
        ArrayList<SSTableReader> nonIndexed = new ArrayList<SSTableReader>();
        View view = this.viewManager.view();
        for (SSTableReader sstable : sstables) {
            if (view.containsSSTable(sstable) || sstable.isMarkedCompacted() || IndexDescriptor.create(sstable).isPerColumnIndexBuildComplete(this.indexIdentifier)) continue;
            nonIndexed.add(sstable);
        }
        return nonIndexed;
    }

    private class UpdateIndexer
    implements Index.Indexer {
        private final DecoratedKey key;
        private final Memtable memtable;
        private final WriteContext writeContext;

        UpdateIndexer(DecoratedKey key, Memtable memtable, WriteContext writeContext) {
            this.key = key;
            this.memtable = memtable;
            this.writeContext = writeContext;
        }

        @Override
        public void insertRow(Row row) {
            this.adjustMemtableSize(StorageAttachedIndex.this.memtableIndexManager.index(this.key, row, this.memtable), CassandraWriteContext.fromContext(this.writeContext).getGroup());
        }

        @Override
        public void updateRow(Row oldRow, Row newRow) {
            this.adjustMemtableSize(StorageAttachedIndex.this.memtableIndexManager.update(this.key, oldRow, newRow, this.memtable), CassandraWriteContext.fromContext(this.writeContext).getGroup());
        }

        void adjustMemtableSize(long additionalSpace, OpOrder.Group opGroup) {
            if (additionalSpace >= 0L) {
                this.memtable.markExtraOnHeapUsed(additionalSpace, opGroup);
            }
        }
    }
}

