/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.hints.HintsBuffer;
import org.apache.cassandra.hints.HintsBufferPool;
import org.apache.cassandra.hints.HintsCatalog;
import org.apache.cassandra.hints.HintsStore;
import org.apache.cassandra.hints.HintsWriter;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HintsWriteExecutor {
    private static final Logger logger = LoggerFactory.getLogger(HintsWriteExecutor.class);
    static final int WRITE_BUFFER_SIZE = 262144;
    private final HintsCatalog catalog;
    private final ByteBuffer writeBuffer;
    private final ExecutorPlus executor;

    HintsWriteExecutor(HintsCatalog catalog) {
        this.catalog = catalog;
        this.writeBuffer = ByteBuffer.allocateDirect(262144);
        this.executor = ExecutorFactory.Global.executorFactory().sequential("HintsWriteExecutor");
    }

    void shutdownBlocking() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    Future<?> flushBuffer(HintsBuffer buffer, HintsBufferPool bufferPool) {
        return this.executor.submit(new FlushBufferTask(buffer, bufferPool));
    }

    Future<?> flushBufferPool(HintsBufferPool bufferPool) {
        return this.executor.submit(new FlushBufferPoolTask(bufferPool));
    }

    Future<?> flushBufferPool(HintsBufferPool bufferPool, Iterable<HintsStore> stores) {
        return this.executor.submit(new PartiallyFlushBufferPoolTask(bufferPool, stores));
    }

    void fsyncWritersBlockingly(Iterable<HintsStore> stores) {
        try {
            this.executor.submit(new FsyncWritersTask(stores)).get();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    Future<?> closeWriter(HintsStore store) {
        return this.executor.submit(store::closeWriter);
    }

    Future<?> closeAllWriters() {
        return this.executor.submit(() -> this.catalog.stores().forEach(HintsStore::closeWriter));
    }

    private void flush(HintsBuffer buffer) {
        buffer.hostIds().forEach(hostId -> this.flush(buffer.consumingHintsIterator((UUID)hostId), this.catalog.get((UUID)hostId), buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flush(Iterator<ByteBuffer> iterator, HintsStore store, HintsBuffer buffer) {
        while (true) {
            if (iterator.hasNext()) {
                this.flushInternal(iterator, store);
            }
            if (!iterator.hasNext()) return;
            try {
                store.closeWriter();
                continue;
            }
            finally {
                buffer.clearEarliestHintForHostId(store.hostId);
                continue;
            }
            break;
        }
    }

    private void flushInternal(Iterator<ByteBuffer> iterator, HintsStore store) {
        long maxHintsFileSize = DatabaseDescriptor.getMaxHintsFileSize();
        HintsWriter writer = store.getOrOpenWriter();
        try (HintsWriter.Session session = writer.newSession(this.writeBuffer);){
            while (iterator.hasNext()) {
                session.append(iterator.next());
                if (session.position() < maxHintsFileSize) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, writer.descriptor().fileName());
        }
    }

    private final class FsyncWritersTask
    implements Runnable {
        private final Iterable<HintsStore> stores;

        FsyncWritersTask(Iterable<HintsStore> stores) {
            this.stores = stores;
        }

        @Override
        public void run() {
            this.stores.forEach(HintsStore::fsyncWriter);
            HintsWriteExecutor.this.catalog.fsyncDirectory();
        }
    }

    private final class PartiallyFlushBufferPoolTask
    implements Runnable {
        private final HintsBufferPool bufferPool;
        private final Iterable<HintsStore> stores;

        PartiallyFlushBufferPoolTask(HintsBufferPool bufferPool, Iterable<HintsStore> stores) {
            this.bufferPool = bufferPool;
            this.stores = stores;
        }

        @Override
        public void run() {
            HintsBuffer buffer = this.bufferPool.currentBuffer();
            buffer.waitForModifications();
            this.stores.forEach(store -> HintsWriteExecutor.this.flush(buffer.consumingHintsIterator(store.hostId), (HintsStore)store, buffer));
        }
    }

    private final class FlushBufferPoolTask
    implements Runnable {
        private final HintsBufferPool bufferPool;

        FlushBufferPoolTask(HintsBufferPool bufferPool) {
            this.bufferPool = bufferPool;
        }

        @Override
        public void run() {
            HintsBuffer buffer = this.bufferPool.currentBuffer();
            buffer.waitForModifications();
            try {
                HintsWriteExecutor.this.flush(buffer);
            }
            catch (FSError e) {
                logger.error("Unable to flush hint buffer: {}", (Object)e.getLocalizedMessage(), (Object)e);
                FileUtils.handleFSErrorAndPropagate(e);
            }
        }
    }

    private final class FlushBufferTask
    implements Runnable {
        private final HintsBuffer buffer;
        private final HintsBufferPool bufferPool;

        FlushBufferTask(HintsBuffer buffer, HintsBufferPool bufferPool) {
            this.buffer = buffer;
            this.bufferPool = bufferPool;
        }

        @Override
        public void run() {
            this.buffer.waitForModifications();
            try {
                HintsWriteExecutor.this.flush(this.buffer);
            }
            finally {
                HintsBuffer recycledBuffer = this.buffer.recycle();
                this.bufferPool.offer(recycledBuffer);
            }
        }
    }
}

