/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.MajorLeveledCompactionWriter;
import org.apache.cassandra.db.compaction.writers.MaxSSTableSizeWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class LeveledCompactionTask
extends CompactionTask {
    private final int level;
    private final long maxSSTableBytes;
    private final boolean majorCompaction;

    public LeveledCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int level, long gcBefore, long maxSSTableBytes, boolean majorCompaction) {
        super(cfs, txn, gcBefore);
        this.level = level;
        this.maxSSTableBytes = maxSSTableBytes;
        this.majorCompaction = majorCompaction;
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        if (this.majorCompaction) {
            return new MajorLeveledCompactionWriter(cfs, directories, txn, nonExpiredSSTables, this.maxSSTableBytes, false);
        }
        return new MaxSSTableSizeWriter(cfs, directories, txn, nonExpiredSSTables, this.maxSSTableBytes, this.getLevel(), false);
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        throw new UnsupportedOperationException("This is now handled in reduceScopeForLimitedSpace");
    }

    @Override
    protected int getLevel() {
        return this.level;
    }

    @Override
    public boolean reduceScopeForLimitedSpace(Set<SSTableReader> nonExpiredSSTables, long expectedSize) {
        if (this.transaction.originals().size() > 1 && this.level <= 1) {
            logger.warn("insufficient space to do L0 -> L{} compaction. {}MiB required, {} for compaction {}", new Object[]{this.level, Float.valueOf((float)expectedSize / 1024.0f / 1024.0f), this.transaction.originals().stream().map(sstable -> String.format("%s (level=%s, size=%s)", sstable, sstable.getSSTableLevel(), sstable.onDiskLength())).collect(Collectors.joining(",")), this.transaction.opId()});
            int l0SSTableCount = 0;
            SSTableReader largestL0SSTable = null;
            for (SSTableReader sstable2 : nonExpiredSSTables) {
                if (sstable2.getSSTableLevel() != 0) continue;
                ++l0SSTableCount;
                if (largestL0SSTable != null && sstable2.onDiskLength() <= largestL0SSTable.onDiskLength()) continue;
                largestL0SSTable = sstable2;
            }
            if (largestL0SSTable != null && l0SSTableCount > 1) {
                logger.info("Removing {} (level={}, size={}) from compaction {}", new Object[]{largestL0SSTable, largestL0SSTable.getSSTableLevel(), largestL0SSTable.onDiskLength(), this.transaction.opId()});
                this.transaction.cancel(largestL0SSTable);
                return true;
            }
        }
        return false;
    }
}

