/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.tracing.Tracing;

public class MutationVerbHandler
implements IVerbHandler<Mutation> {
    public static final MutationVerbHandler instance = new MutationVerbHandler();

    private void respond(Message<?> respondTo, InetAddressAndPort respondToAddress) {
        Tracing.trace("Enqueuing response to {}", (Object)respondToAddress);
        MessagingService.instance().send(respondTo.emptyResponse(), respondToAddress);
    }

    private void failed() {
        Tracing.trace("Payload application resulted in WriteTimeout, not replying");
    }

    @Override
    public void doVerb(Message<Mutation> message) {
        ((Mutation)message.payload).validateSize(MessagingService.current_version, 12);
        ForwardingInfo forwardTo = message.forwardTo();
        if (forwardTo != null) {
            MutationVerbHandler.forwardToLocalNodes(message, forwardTo);
        }
        InetAddressAndPort respondToAddress = message.respondTo();
        try {
            ((Mutation)message.payload).applyFuture().addCallback(o -> this.respond(message, respondToAddress), wto -> this.failed());
        }
        catch (WriteTimeoutException wto2) {
            this.failed();
        }
    }

    private static void forwardToLocalNodes(Message<Mutation> originalMessage, ForwardingInfo forwardTo) {
        Message.Builder<Mutation> builder = Message.builder(originalMessage).withParam(ParamType.RESPOND_TO, originalMessage.from()).withoutParam(ParamType.FORWARD_TO);
        Message<Mutation> message = builder.build();
        forwardTo.forEach((id, target) -> {
            Tracing.trace("Enqueuing forwarded write to {}", target);
            MessagingService.instance().send(message, (InetAddressAndPort)target);
        });
    }
}

