/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.functions.UserFunction;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class DropTypeStatement
extends AlterSchemaStatement {
    private final String typeName;
    private final boolean ifExists;

    public DropTypeStatement(String keyspaceName, String typeName, boolean ifExists) {
        super(keyspaceName);
        this.typeName = typeName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        UserType type;
        ByteBuffer name = ByteBufferUtil.bytes(this.typeName);
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        UserType userType = type = null == keyspace ? null : keyspace.types.getNullable(name);
        if (null == type) {
            if (this.ifExists) {
                return schema;
            }
            throw DropTypeStatement.ire("Type '%s.%s' doesn't exist", this.keyspaceName, this.typeName);
        }
        Iterable<UserFunction> functions = keyspace.userFunctions.referencingUserType(name);
        if (!Iterables.isEmpty(functions)) {
            throw DropTypeStatement.ire("Cannot drop user type '%s.%s' as it is still used by functions %s", this.keyspaceName, this.typeName, String.join((CharSequence)", ", Iterables.transform(functions, f -> f.name().toString())));
        }
        Iterable<UserType> types = keyspace.types.referencingUserType(name);
        if (!Iterables.isEmpty(types)) {
            throw DropTypeStatement.ire("Cannot drop user type '%s.%s' as it is still used by user types %s", this.keyspaceName, this.typeName, String.join((CharSequence)", ", Iterables.transform(types, UserType::getNameAsString)));
        }
        Iterable<TableMetadata> tables = keyspace.tables.referencingUserType(name);
        if (!Iterables.isEmpty(tables)) {
            throw DropTypeStatement.ire("Cannot drop user type '%s.%s' as it is still used by tables %s", this.keyspaceName, this.typeName, String.join((CharSequence)", ", Iterables.transform(tables, t -> t.name)));
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.types.without(type)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TYPE, this.keyspaceName, this.typeName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureAllTablesPermission(this.keyspaceName, Permission.DROP);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_TYPE, this.keyspaceName, this.typeName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.typeName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final UTName name;
        private final boolean ifExists;

        public Raw(UTName name, boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        @Override
        public DropTypeStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new DropTypeStatement(keyspaceName, this.name.getStringTypeName(), this.ifExists);
        }
    }
}

