/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.codahale.metrics.Counter;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.ConnectionStage;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection
extends Connection {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnection.class);
    private volatile IAuthenticator.SaslNegotiator saslNegotiator;
    private final ClientState clientState;
    private volatile ConnectionStage stage;
    public final Counter requests = new Counter();

    ServerConnection(Channel channel, ProtocolVersion version, Connection.Tracker tracker) {
        super(channel, version, tracker);
        this.clientState = ClientState.forExternalCalls(channel.remoteAddress());
        this.stage = ConnectionStage.ESTABLISHED;
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    ConnectionStage stage() {
        return this.stage;
    }

    QueryState validateNewMessage(Message.Type type, ProtocolVersion version) {
        switch (this.stage) {
            case ESTABLISHED: {
                if (type == Message.Type.STARTUP || type == Message.Type.OPTIONS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{type}));
            }
            case AUTHENTICATING: {
                if (type == Message.Type.AUTH_RESPONSE || type == Message.Type.CREDENTIALS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting %s", new Object[]{type, version == ProtocolVersion.V1 ? "CREDENTIALS" : "SASL_RESPONSE"}));
            }
            case READY: {
                if (type != Message.Type.STARTUP) break;
                throw new ProtocolException("Unexpected message STARTUP, the connection is already initialized");
            }
            default: {
                throw new AssertionError();
            }
        }
        return new QueryState(this.clientState);
    }

    void applyStateTransition(Message.Type requestType, Message.Type responseType) {
        switch (this.stage) {
            case ESTABLISHED: {
                if (requestType != Message.Type.STARTUP) break;
                if (responseType == Message.Type.AUTHENTICATE) {
                    this.stage = ConnectionStage.AUTHENTICATING;
                    break;
                }
                if (responseType != Message.Type.READY) break;
                this.stage = ConnectionStage.READY;
                break;
            }
            case AUTHENTICATING: {
                assert (requestType == Message.Type.AUTH_RESPONSE || requestType == Message.Type.CREDENTIALS);
                if (responseType != Message.Type.READY && responseType != Message.Type.AUTH_SUCCESS) break;
                this.stage = ConnectionStage.READY;
                this.saslNegotiator = null;
                break;
            }
            case READY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public IAuthenticator.SaslNegotiator getSaslNegotiator(QueryState queryState) {
        if (this.saslNegotiator == null) {
            this.saslNegotiator = DatabaseDescriptor.getAuthenticator().newSaslNegotiator(queryState.getClientAddress(), this.certificates());
        }
        return this.saslNegotiator;
    }

    private Certificate[] certificates() {
        SslHandler sslHandler = (SslHandler)this.channel().pipeline().get("ssl");
        Certificate[] certificates = null;
        if (sslHandler != null) {
            try {
                certificates = sslHandler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                logger.debug("Failed to get peer certificates for peer {}", (Object)this.channel().remoteAddress(), (Object)e);
            }
        }
        return certificates;
    }
}

