/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.Version;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Server;
import org.apache.cassandra.utils.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTransportService {
    private static final Logger logger = LoggerFactory.getLogger(NativeTransportService.class);
    private Collection<Server> servers = Collections.emptyList();
    private boolean initialized = false;
    private EventLoopGroup workerGroup;

    @VisibleForTesting
    synchronized void initialize() {
        Server regularPortServer;
        Server tlsPortServer;
        block8: {
            EncryptionOptions.TlsEncryptionPolicy encryptionPolicy;
            Server.Builder builder;
            int nativePort;
            block7: {
                if (this.initialized) {
                    return;
                }
                if (NativeTransportService.useEpoll()) {
                    this.workerGroup = new EpollEventLoopGroup();
                    logger.info("Netty using native Epoll event loop");
                } else {
                    this.workerGroup = new NioEventLoopGroup();
                    logger.info("Netty using Java NIO event loop");
                }
                nativePort = DatabaseDescriptor.getNativeTransportPort();
                int nativePortSSL = DatabaseDescriptor.getNativeTransportPortSSL();
                InetAddress nativeAddr = DatabaseDescriptor.getRpcAddress();
                builder = new Server.Builder().withEventLoopGroup(this.workerGroup).withHost(nativeAddr);
                encryptionPolicy = DatabaseDescriptor.getNativeProtocolEncryptionOptions().tlsEncryptionPolicy();
                tlsPortServer = null;
                if (nativePort == nativePortSSL) break block7;
                regularPortServer = builder.withTlsEncryptionPolicy(EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED).withPort(nativePort).build();
                switch (encryptionPolicy) {
                    case OPTIONAL: 
                    case ENCRYPTED: {
                        tlsPortServer = builder.withTlsEncryptionPolicy(encryptionPolicy).withPort(nativePortSSL).build();
                        break block8;
                    }
                    case UNENCRYPTED: {
                        throw new IllegalStateException("Encryption must be enabled in client_encryption_options for native_transport_port_ssl");
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized TLS encryption policy: " + encryptionPolicy);
                    }
                }
            }
            regularPortServer = builder.withTlsEncryptionPolicy(encryptionPolicy).withPort(nativePort).build();
        }
        this.servers = tlsPortServer == null ? Collections.singleton(regularPortServer) : Collections.unmodifiableList(Arrays.asList(regularPortServer, tlsPortServer));
        ClientMetrics.instance.init(this.servers);
        this.initialized = true;
    }

    public void start() {
        logger.info("Using Netty Version: {}", Version.identify().entrySet());
        this.initialize();
        this.servers.forEach(Server::start);
    }

    public void stop() {
        this.servers.forEach(Server::stop);
    }

    public void destroy() {
        this.stop();
        this.servers = Collections.emptyList();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(3L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
        }
        Dispatcher.shutdown();
    }

    public static boolean useEpoll() {
        boolean enableEpoll = CassandraRelevantProperties.NATIVE_EPOLL_ENABLED.getBoolean();
        if (enableEpoll && !Epoll.isAvailable() && NativeLibrary.osType == NativeLibrary.OSType.LINUX) {
            logger.warn("epoll not available", Epoll.unavailabilityCause());
        }
        return enableEpoll && Epoll.isAvailable();
    }

    public boolean isRunning() {
        for (Server server : this.servers) {
            if (!server.isRunning()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @VisibleForTesting
    Collection<Server> getServers() {
        return this.servers;
    }

    public void clearConnectionHistory() {
        for (Server server : this.servers) {
            server.clearConnectionHistory();
        }
    }
}

