/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.RepairRetrySpec;
import org.apache.cassandra.config.RetrySpec;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.Backoff;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepairMessage {
    private static final CassandraVersion SUPPORTS_RETRY = new CassandraVersion("5.0.0-alpha2.SNAPSHOT");
    private static final Map<Verb, CassandraVersion> VERB_TIMEOUT_VERSIONS;
    private static final Set<Verb> SUPPORTS_RETRY_WITHOUT_VERSION_CHECK;
    private static final Logger logger;
    @Nullable
    public final RepairJobDesc desc;

    protected RepairMessage(@Nullable RepairJobDesc desc) {
        this.desc = desc;
    }

    public TimeUUID parentRepairSession() {
        return this.desc.parentSessionId;
    }

    private static Backoff backoff(SharedContext ctx, Verb verb) {
        RetrySpec spec;
        RepairRetrySpec retrySpec = DatabaseDescriptor.getRepairRetrySpec();
        RetrySpec retrySpec2 = spec = verb == Verb.VALIDATION_RSP ? retrySpec.getMerkleTreeResponseSpec() : retrySpec;
        if (!spec.isEnabled()) {
            return Backoff.None.INSTANCE;
        }
        return new Backoff.ExponentialBackoff(spec.maxAttempts.value, spec.baseSleepTime.toMilliseconds(), spec.maxSleepTime.toMilliseconds(), ctx.random().get()::nextDouble);
    }

    public static Supplier<Boolean> notDone(Future<?> f) {
        return () -> !f.isDone();
    }

    private static Supplier<Boolean> always() {
        return () -> true;
    }

    public static <T> void sendMessageWithRetries(SharedContext ctx, Supplier<Boolean> allowRetry, RepairMessage request, Verb verb, InetAddressAndPort endpoint, RequestCallback<T> finalCallback) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), allowRetry, request, verb, endpoint, finalCallback, 0);
    }

    public static <T> void sendMessageWithRetries(SharedContext ctx, RepairMessage request, Verb verb, InetAddressAndPort endpoint, RequestCallback<T> finalCallback) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), RepairMessage.always(), request, verb, endpoint, finalCallback, 0);
    }

    public static void sendMessageWithRetries(SharedContext ctx, RepairMessage request, Verb verb, InetAddressAndPort endpoint) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), RepairMessage.always(), request, verb, endpoint, new RequestCallback<Object>(){

            @Override
            public void onResponse(Message<Object> msg) {
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
            }
        }, 0);
    }

    private static <T> void sendMessageWithRetries(final SharedContext ctx, final Backoff backoff, final Supplier<Boolean> allowRetry, final RepairMessage request, final Verb verb, final InetAddressAndPort endpoint, final RequestCallback<T> finalCallback, final int attempt) {
        RequestCallback callback = new RequestCallback<T>(){

            @Override
            public void onResponse(Message<T> msg) {
                finalCallback.onResponse(msg);
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
                ErrorHandling allowed = RepairMessage.errorHandlingSupported(ctx, endpoint, verb, request.parentRepairSession());
                switch (allowed) {
                    case NONE: {
                        logger.error("[#{}] {} failed on {}: {}", new Object[]{request.parentRepairSession(), verb, from, failureReason});
                        return;
                    }
                    case TIMEOUT: {
                        finalCallback.onFailure(from, failureReason);
                        return;
                    }
                    case RETRY: {
                        int maxAttempts = backoff.maxAttempts();
                        if (failureReason == RequestFailureReason.TIMEOUT && attempt < maxAttempts && ((Boolean)allowRetry.get()).booleanValue()) {
                            ctx.optionalTasks().schedule(() -> 2.lambda$onFailure$0(ctx, backoff, (Supplier)allowRetry, request, verb, endpoint, finalCallback, attempt), backoff.computeWaitTime(attempt), backoff.unit());
                            return;
                        }
                        finalCallback.onFailure(from, failureReason);
                        return;
                    }
                }
                throw new AssertionError((Object)("Unknown error handler: " + allowed));
            }

            @Override
            public boolean invokeOnFailure() {
                return true;
            }

            private static /* synthetic */ void lambda$onFailure$0(SharedContext ctx2, Backoff backoff2, Supplier allowRetry2, RepairMessage request2, Verb verb2, InetAddressAndPort endpoint2, RequestCallback finalCallback2, int attempt2) {
                RepairMessage.sendMessageWithRetries(ctx2, backoff2, allowRetry2, request2, verb2, endpoint2, finalCallback2, attempt2 + 1);
            }
        };
        ctx.messaging().sendWithCallback(Message.outWithFlag(verb, request, MessageFlag.CALL_BACK_ON_FAILURE), endpoint, callback);
    }

    public static void sendMessageWithFailureCB(SharedContext ctx, Supplier<Boolean> allowRetry, final RepairMessage request, final Verb verb, final InetAddressAndPort endpoint, final RepairFailureCallback failureCallback) {
        RequestCallback<Object> callback = new RequestCallback<Object>(){

            @Override
            public void onResponse(Message<Object> msg) {
                logger.info("[#{}] {} received by {}", new Object[]{request.parentRepairSession(), verb, endpoint});
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
                failureCallback.onFailure(RepairException.error(request.desc, PreviewKind.NONE, String.format("Got %s failure from %s: %s", new Object[]{verb, from, failureReason})));
            }

            @Override
            public boolean invokeOnFailure() {
                return true;
            }
        };
        RepairMessage.sendMessageWithRetries(ctx, allowRetry, request, verb, endpoint, callback);
    }

    private static ErrorHandling errorHandlingSupported(SharedContext ctx, InetAddressAndPort from, Verb verb, TimeUUID parentSessionId) {
        if (SUPPORTS_RETRY_WITHOUT_VERSION_CHECK.contains((Object)verb)) {
            return ErrorHandling.RETRY;
        }
        CassandraVersion remoteVersion = ctx.gossiper().getReleaseVersion(from);
        if (remoteVersion == null) {
            if (VERB_TIMEOUT_VERSIONS.containsKey((Object)verb)) {
                logger.warn("[#{}] Not failing repair due to remote host {} not supporting repair message timeouts (version is unknown)", (Object)parentSessionId, (Object)from);
                return ErrorHandling.NONE;
            }
            return ErrorHandling.TIMEOUT;
        }
        if (remoteVersion.compareTo(SUPPORTS_RETRY) >= 0) {
            return ErrorHandling.RETRY;
        }
        CassandraVersion timeoutVersion = VERB_TIMEOUT_VERSIONS.get((Object)verb);
        if (timeoutVersion == null || remoteVersion.compareTo(timeoutVersion) >= 0) {
            return ErrorHandling.TIMEOUT;
        }
        return ErrorHandling.NONE;
    }

    static {
        CassandraVersion timeoutVersion = new CassandraVersion("4.0.7-SNAPSHOT");
        EnumMap<Verb, CassandraVersion> map = new EnumMap<Verb, CassandraVersion>(Verb.class);
        map.put(Verb.VALIDATION_REQ, timeoutVersion);
        map.put(Verb.SYNC_REQ, timeoutVersion);
        map.put(Verb.VALIDATION_RSP, SUPPORTS_RETRY);
        map.put(Verb.SYNC_RSP, SUPPORTS_RETRY);
        VERB_TIMEOUT_VERSIONS = Collections.unmodifiableMap(map);
        SUPPORTS_RETRY_WITHOUT_VERSION_CHECK = Collections.unmodifiableSet(EnumSet.of(Verb.CLEANUP_MSG));
        logger = LoggerFactory.getLogger(RepairMessage.class);
    }

    public static interface RepairFailureCallback {
        public void onFailure(Exception var1);
    }

    private static enum ErrorHandling {
        NONE,
        TIMEOUT,
        RETRY;

    }
}

