/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class FinalizeCommit
extends RepairMessage {
    public final TimeUUID sessionID;
    public static final IVersionedSerializer<FinalizeCommit> serializer = new IVersionedSerializer<FinalizeCommit>(){

        @Override
        public void serialize(FinalizeCommit msg, DataOutputPlus out, int version) throws IOException {
            msg.sessionID.serialize(out);
        }

        @Override
        public FinalizeCommit deserialize(DataInputPlus in, int version) throws IOException {
            return new FinalizeCommit(TimeUUID.deserialize(in));
        }

        @Override
        public long serializedSize(FinalizeCommit msg, int version) {
            return TimeUUID.sizeInBytes();
        }
    };

    public FinalizeCommit(TimeUUID sessionID) {
        super(null);
        assert (sessionID != null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizeCommit that = (FinalizeCommit)o;
        return this.sessionID.equals(that.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "FinalizeCommit{sessionID=" + this.sessionID + "}";
    }
}

