/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.Random;
import java.util.function.Supplier;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ScheduledExecutorPlus;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.ICompactionManager;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.IGossiper;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessageDelivery;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.IValidationManager;
import org.apache.cassandra.repair.StreamExecutor;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationManager;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;

public interface SharedContext {
    public InetAddressAndPort broadcastAddressAndPort();

    public Supplier<Random> random();

    public Clock clock();

    public ExecutorFactory executorFactory();

    public MBeanWrapper mbean();

    public ScheduledExecutorPlus optionalTasks();

    public MessageDelivery messaging();

    public IFailureDetector failureDetector();

    public IEndpointSnitch snitch();

    public IGossiper gossiper();

    public ICompactionManager compactionManager();

    public ActiveRepairService repair();

    public IValidationManager validationManager();

    public TableRepairManager repairManager(ColumnFamilyStore var1);

    public StreamExecutor streamExecutor();

    public static class Global
    implements SharedContext {
        public static final Global instance = new Global();

        @Override
        public InetAddressAndPort broadcastAddressAndPort() {
            return FBUtilities.getBroadcastAddressAndPort();
        }

        @Override
        public Supplier<Random> random() {
            return Random::new;
        }

        @Override
        public Clock clock() {
            return Clock.Global.clock();
        }

        @Override
        public ExecutorFactory executorFactory() {
            return ExecutorFactory.Global.executorFactory();
        }

        @Override
        public MBeanWrapper mbean() {
            return MBeanWrapper.instance;
        }

        @Override
        public ScheduledExecutorPlus optionalTasks() {
            return ScheduledExecutors.optionalTasks;
        }

        @Override
        public MessageDelivery messaging() {
            return MessagingService.instance();
        }

        @Override
        public IFailureDetector failureDetector() {
            return FailureDetector.instance;
        }

        @Override
        public IEndpointSnitch snitch() {
            return DatabaseDescriptor.getEndpointSnitch();
        }

        @Override
        public IGossiper gossiper() {
            return Gossiper.instance;
        }

        @Override
        public ICompactionManager compactionManager() {
            return CompactionManager.instance;
        }

        @Override
        public ActiveRepairService repair() {
            return ActiveRepairService.instance();
        }

        @Override
        public IValidationManager validationManager() {
            return ValidationManager.instance;
        }

        @Override
        public TableRepairManager repairManager(ColumnFamilyStore store) {
            return store.getRepairManager();
        }

        @Override
        public StreamExecutor streamExecutor() {
            return StreamPlan::execute;
        }
    }
}

