/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSErrorHandler;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final long ONE_KIB = 1024L;
    public static final long ONE_MIB = 0x100000L;
    public static final long ONE_GIB = 0x40000000L;
    public static final long ONE_TIB = 0x10000000000L;
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private static final AtomicReference<Optional<FSErrorHandler>> fsErrorHandler = new AtomicReference(Optional.empty());
    private static final Class clsDirectBuffer;
    private static final MethodHandle mhDirectBufferCleaner;
    private static final MethodHandle mhCleanerClean;
    private static final File tempDir;
    private static final AtomicLong tempFileNum;

    public static File getTempDir() {
        return tempDir;
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        long num;
        String fileName;
        File candidate;
        while (!(candidate = new File(directory, fileName = prefix + (num = tempFileNum.getAndIncrement()) + suffix)).createFileIfNotExists()) {
        }
        return candidate;
    }

    public static File createTempFile(String prefix, String suffix) {
        return FileUtils.createTempFile(prefix, suffix, tempDir);
    }

    public static File createDeletableTempFile(String prefix, String suffix) {
        File f = FileUtils.createTempFile(prefix, suffix, FileUtils.getTempDir());
        f.deleteOnExit();
        return f;
    }

    public static void createHardLink(String from, String to) {
        FileUtils.createHardLink(new File(from), new File(to));
    }

    public static void createHardLink(File from, File to) {
        if (to.exists()) {
            throw new RuntimeException("Tried to create duplicate hard link to " + to);
        }
        if (!from.exists()) {
            throw new RuntimeException("Tried to hard link to file that does not exist " + from);
        }
        try {
            Files.createLink(to.toPath(), from.toPath());
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, to);
        }
    }

    public static void createHardLinkWithConfirm(String from, String to) {
        FileUtils.createHardLinkWithConfirm(new File(from), new File(to));
    }

    public static void createHardLinkWithConfirm(File from, File to) {
        try {
            FileUtils.createHardLink(from, to);
        }
        catch (FSWriteError ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Unable to hardlink from %s to %s", from, to), t);
        }
    }

    public static void createHardLinkWithoutConfirm(String from, String to) {
        FileUtils.createHardLinkWithoutConfirm(new File(from), new File(to));
    }

    public static void createHardLinkWithoutConfirm(File from, File to) {
        block2: {
            try {
                FileUtils.createHardLink(from, to);
            }
            catch (FSWriteError fse) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("Could not hardlink file " + from + " to " + to, (Throwable)fse);
            }
        }
    }

    public static void copyWithOutConfirm(String from, String to) {
        FileUtils.copyWithOutConfirm(new File(from), new File(to));
    }

    public static void copyWithOutConfirm(File from, File to) {
        block2: {
            try {
                Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("Could not copy file" + from + " to " + to, (Throwable)e);
            }
        }
    }

    public static void copyWithConfirm(String from, String to) {
        FileUtils.copyWithConfirm(new File(from), new File(to));
    }

    public static void copyWithConfirm(File from, File to) {
        assert (from.exists());
        if (logger.isTraceEnabled()) {
            logger.trace("Copying {} to {}", (Object)from.path(), (Object)to.path());
        }
        try {
            Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, "Could not copy file" + from + " to " + to);
        }
    }

    public static void truncate(String path, long size) {
        File file = new File(path);
        try (FileChannel channel = file.newReadWriteChannel();){
            channel.truncate(size);
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, file.toPath(), true);
        }
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger.warn("Failed closing {}", (Object)c, (Object)e);
        }
    }

    public static void closeQuietly(AutoCloseable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger.warn("Failed closing {}", (Object)c, (Object)e);
        }
    }

    public static void close(Closeable ... cs) throws IOException {
        FileUtils.close(Arrays.asList(cs));
    }

    public static void close(Iterable<? extends Closeable> cs) throws IOException {
        Throwable e = null;
        for (Closeable closeable : cs) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable ex) {
                if (e == null) {
                    e = ex;
                } else {
                    e.addSuppressed(ex);
                }
                logger.warn("Failed closing stream {}", (Object)closeable, (Object)ex);
            }
        }
        Throwables.maybeFail(e, IOException.class);
    }

    public static void closeQuietly(Iterable<? extends AutoCloseable> cs) {
        for (AutoCloseable autoCloseable : cs) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Exception ex) {
                logger.warn("Failed closing {}", (Object)autoCloseable, (Object)ex);
            }
        }
    }

    public static String getCanonicalPath(String filename) {
        return new File(filename).canonicalPath();
    }

    public static String getCanonicalPath(File file) {
        return file.canonicalPath();
    }

    public static boolean isContained(File folder, File file) {
        return folder.isAncestorOf(file);
    }

    public static void clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        try {
            Object cleaner = mhDirectBufferCleaner.bindTo(buffer).invoke();
            if (cleaner != null) {
                mhCleanerClean.bindTo(cleaner).invoke();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static long parseFileSize(String value) {
        if (!value.matches("\\d+(\\.\\d+)? (GiB|KiB|MiB|TiB|bytes)")) {
            throw new IllegalArgumentException(String.format("value %s is not a valid human-readable file size", value));
        }
        if (value.endsWith(" TiB")) {
            long result = Math.round(Double.valueOf(value.replace(" TiB", "")) * 1.099511627776E12);
            return result;
        }
        if (value.endsWith(" GiB")) {
            long result = Math.round(Double.valueOf(value.replace(" GiB", "")) * 1.073741824E9);
            return result;
        }
        if (value.endsWith(" KiB")) {
            long result = Math.round(Double.valueOf(value.replace(" KiB", "")) * 1024.0);
            return result;
        }
        if (value.endsWith(" MiB")) {
            long result = Math.round(Double.valueOf(value.replace(" MiB", "")) * 1048576.0);
            return result;
        }
        if (value.endsWith(" bytes")) {
            long result = Math.round(Double.valueOf(value.replace(" bytes", "")));
            return result;
        }
        throw new IllegalStateException(String.format("FileUtils.parseFileSize() reached an illegal state parsing %s", value));
    }

    public static String stringifyFileSize(double value) {
        if (value >= 1.099511627776E12) {
            double d = value / 1.099511627776E12;
            String val = df.format(d);
            return val + " TiB";
        }
        if (value >= 1.073741824E9) {
            double d = value / 1.073741824E9;
            String val = df.format(d);
            return val + " GiB";
        }
        if (value >= 1048576.0) {
            double d = value / 1048576.0;
            String val = df.format(d);
            return val + " MiB";
        }
        if (value >= 1024.0) {
            double d = value / 1024.0;
            String val = df.format(d);
            return val + " KiB";
        }
        String val = df.format(value);
        return val + " bytes";
    }

    public static void handleCorruptSSTable(CorruptSSTableException e) {
        fsErrorHandler.get().ifPresent(handler -> handler.handleCorruptSSTable(e));
    }

    public static void handleFSError(FSError e) {
        fsErrorHandler.get().ifPresent(handler -> handler.handleFSError(e));
    }

    public static void handleStartupFSError(Throwable t) {
        fsErrorHandler.get().ifPresent(handler -> handler.handleStartupFSError(t));
    }

    public static void handleFSErrorAndPropagate(FSError e) {
        JVMStabilityInspector.inspectThrowable(e);
        throw e;
    }

    public static long folderSize(File folder) {
        if (!folder.exists()) {
            return 0L;
        }
        final long[] sizeArr = new long[]{0L};
        try {
            Files.walkFileTree(folder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    sizeArr[0] = sizeArr[0] + attrs.size();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                    if (e instanceof NoSuchFileException) {
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException e) {
            logger.error("Error while getting {} folder size. {}", (Object)folder, (Object)e.getMessage());
        }
        return sizeArr[0];
    }

    public static void append(File file, String ... lines) {
        if (file.exists()) {
            FileUtils.write(file, Arrays.asList(lines), StandardOpenOption.APPEND);
        } else {
            FileUtils.write(file, Arrays.asList(lines), StandardOpenOption.CREATE);
        }
    }

    public static void appendAndSync(File file, String ... lines) {
        if (file.exists()) {
            FileUtils.write(file, Arrays.asList(lines), StandardOpenOption.APPEND, StandardOpenOption.SYNC);
        } else {
            FileUtils.write(file, Arrays.asList(lines), StandardOpenOption.CREATE, StandardOpenOption.SYNC);
        }
    }

    public static void replace(File file, String ... lines) {
        FileUtils.write(file, Arrays.asList(lines), StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void write(File file, List<String> lines, StandardOpenOption ... options) {
        EnumSet<StandardOpenOption> optionsSet = EnumSet.noneOf(StandardOpenOption.class);
        for (StandardOpenOption option : options) {
            optionsSet.add(option);
        }
        if (optionsSet.isEmpty()) {
            optionsSet.add(StandardOpenOption.CREATE);
            optionsSet.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        boolean sync = optionsSet.remove(StandardOpenOption.SYNC);
        boolean dsync = optionsSet.remove(StandardOpenOption.DSYNC);
        optionsSet.add(StandardOpenOption.WRITE);
        Path filePath = file.toPath();
        try (FileChannel fc = filePath.getFileSystem().provider().newFileChannel(filePath, optionsSet, new FileAttribute[0]);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(fc), CHARSET.newEncoder()));){
            for (CharSequence charSequence : lines) {
                writer.append(charSequence);
                writer.newLine();
            }
            if (sync) {
                SyncUtil.force(fc, true);
            } else if (dsync) {
                SyncUtil.force(fc, false);
            }
        }
        catch (ClosedChannelException cce) {
            throw new RuntimeException(cce);
        }
        catch (IOException ex) {
            throw new FSWriteError((Throwable)ex, file);
        }
    }

    public static List<String> readLines(File file) {
        try {
            return Files.readAllLines(file.toPath(), CHARSET);
        }
        catch (IOException ex) {
            if (ex instanceof NoSuchFileException) {
                return Collections.emptyList();
            }
            throw new RuntimeException(ex);
        }
    }

    public static void setFSErrorHandler(FSErrorHandler handler) {
        fsErrorHandler.getAndSet(Optional.ofNullable(handler));
    }

    @Deprecated(since="4.1")
    public static void createDirectory(String directory) {
        FileUtils.createDirectory(new File(directory));
    }

    @Deprecated(since="4.1")
    public static void createDirectory(File directory) {
        PathUtils.createDirectoriesIfNotExists(directory.toPath());
    }

    @Deprecated(since="4.1")
    public static boolean delete(String file) {
        return new File(file).tryDelete();
    }

    @Deprecated(since="4.1")
    public static void delete(File ... files) {
        for (File file : files) {
            file.tryDelete();
        }
    }

    @Deprecated(since="4.1")
    public static void deleteRecursiveWithThrottle(File dir, RateLimiter rateLimiter) {
        dir.deleteRecursive(rateLimiter);
    }

    @Deprecated(since="4.1")
    public static void deleteRecursive(File dir) {
        dir.deleteRecursive();
    }

    @Deprecated(since="4.1")
    public static void deleteRecursiveOnExit(File dir) {
        dir.deleteRecursiveOnExit();
    }

    @Deprecated(since="4.1")
    public static boolean isSubDirectory(File parent, File child) {
        return parent.isAncestorOf(child);
    }

    @Deprecated(since="4.1")
    public static Throwable deleteWithConfirm(File file, Throwable accumulate) {
        return file.delete(accumulate, null);
    }

    @Deprecated(since="4.1")
    public static Throwable deleteWithConfirm(File file, Throwable accumulate, RateLimiter rateLimiter) {
        return file.delete(accumulate, rateLimiter);
    }

    @Deprecated(since="4.1")
    public static void deleteWithConfirm(String file) {
        FileUtils.deleteWithConfirm(new File(file));
    }

    @Deprecated(since="4.1")
    public static void deleteWithConfirm(File file) {
        file.delete();
    }

    @Deprecated(since="4.1")
    public static void renameWithOutConfirm(String from, String to) {
        new File(from).tryMove(new File(to));
    }

    @Deprecated(since="4.1")
    public static void renameWithConfirm(String from, String to) {
        FileUtils.renameWithConfirm(new File(from), new File(to));
    }

    @Deprecated(since="4.1")
    public static void renameWithConfirm(File from, File to) {
        from.move(to);
    }

    private FileUtils() {
    }

    public static void moveRecursively(Path source, Path target) throws IOException {
        logger.info("Moving {} to {}", (Object)source, (Object)target);
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
            for (File f : new File(source).tryList()) {
                String fileName = f.name();
                FileUtils.moveRecursively(source.resolve(fileName), target.resolve(fileName));
            }
            FileUtils.deleteDirectoryIfEmpty(source);
        } else if (Files.exists(target, new LinkOption[0])) {
            logger.warn("Cannot move the file {} to {} as the target file already exists.", (Object)source, (Object)target);
        } else {
            Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES);
            Files.delete(source);
        }
    }

    public static void deleteDirectoryIfEmpty(Path path) throws IOException {
        Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (Object)String.format("%s is not a directory", path));
        try {
            logger.info("Deleting directory {}", (Object)path);
            Files.delete(path);
        }
        catch (DirectoryNotEmptyException e) {
            try (Stream<Path> paths = Files.list(path);){
                String content = paths.map(p -> p.getFileName().toString()).collect(Collectors.joining(", "));
                logger.warn("Cannot delete the directory {} as it is not empty. (Content: {})", (Object)path, (Object)content);
            }
        }
    }

    static {
        try {
            clsDirectBuffer = Class.forName("sun.nio.ch.DirectBuffer");
            Method mDirectBufferCleaner = clsDirectBuffer.getMethod("cleaner", new Class[0]);
            mhDirectBufferCleaner = MethodHandles.lookup().unreflect(mDirectBufferCleaner);
            Method mCleanerClean = mDirectBufferCleaner.getReturnType().getMethod("clean", new Class[0]);
            mhCleanerClean = MethodHandles.lookup().unreflect(mCleanerClean);
            ByteBuffer buf = ByteBuffer.allocateDirect(1);
            FileUtils.clean(buf);
        }
        catch (IllegalAccessException e) {
            logger.error("FATAL: Cassandra is unable to access required classes. This usually means it has been run without the aid of the standard startup scripts or the scripts have been edited. If this was intentional, and you are attempting to use Java 11+ you may need to add the --add-exports and --add-opens jvm options from either jvm11-server.options or jvm11-client.options", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            logger.error("FATAL: Cannot initialize optimized memory deallocator.", t);
            JVMStabilityInspector.inspectThrowable(t);
            throw new RuntimeException(t);
        }
        tempDir = new File(CassandraRelevantProperties.JAVA_IO_TMPDIR.getString());
        tempFileNum = new AtomicLong();
    }
}

