/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.postings;

import java.io.IOException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.postings.PostingList;

public class RangePostingList
implements PostingList {
    private final PostingList wrapped;
    private final long rowIdOffset;
    private final long minimum;
    private final long maximum;
    private final long count;
    private final QueryContext queryContext;

    public RangePostingList(PostingList wrapped, long rowIdOffset, long minimum, long maximum, long count, QueryContext queryContext) {
        this.wrapped = wrapped;
        this.rowIdOffset = rowIdOffset;
        this.minimum = minimum;
        this.maximum = maximum;
        this.count = count;
        this.queryContext = queryContext;
    }

    @Override
    public long minimum() {
        return this.minimum;
    }

    @Override
    public long maximum() {
        return this.maximum;
    }

    @Override
    public long nextPosting() throws IOException {
        this.queryContext.checkpoint();
        return this.nextSSTableRowId(this.wrapped.nextPosting());
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        this.queryContext.checkpoint();
        long segmentRowId = targetRowID - this.rowIdOffset;
        assert (segmentRowId >= 0L);
        return this.nextSSTableRowId(this.wrapped.advance(segmentRowId));
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    private long nextSSTableRowId(long segmentRowId) {
        return segmentRowId == Long.MAX_VALUE ? Long.MAX_VALUE : segmentRowId + this.rowIdOffset;
    }
}

