/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.memory.ByteSliceReader;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.mutable.MutableValueInt;

@NotThreadSafe
class RAMPostingSlices {
    static final int DEFAULT_TERM_DICT_SIZE = 1024;
    private final ByteBlockPool postingsPool;
    private int[] postingStarts = new int[1024];
    private int[] postingUptos = new int[1024];
    private int[] sizes = new int[1024];

    RAMPostingSlices(Counter memoryUsage) {
        this.postingsPool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(memoryUsage));
    }

    PostingList postingList(final int termID, final ByteSliceReader reader) {
        this.initReader(reader, termID);
        final MutableValueInt lastSegmentRowId = new MutableValueInt();
        return new PostingList(){

            @Override
            public long nextPosting() throws IOException {
                if (reader.eof()) {
                    return Long.MAX_VALUE;
                }
                lastSegmentRowId.value += reader.readVInt();
                return lastSegmentRowId.value;
            }

            @Override
            public long size() {
                return RAMPostingSlices.this.sizes[termID];
            }

            @Override
            public long advance(long targetRowID) {
                throw new UnsupportedOperationException();
            }
        };
    }

    void initReader(ByteSliceReader reader, int termID) {
        int upto = this.postingUptos[termID];
        reader.init(this.postingsPool, this.postingStarts[termID], upto);
    }

    void createNewSlice(int termID) {
        if (termID >= this.postingStarts.length - 1) {
            this.postingStarts = ArrayUtil.grow((int[])this.postingStarts, (int)(termID + 1));
            this.postingUptos = ArrayUtil.grow((int[])this.postingUptos, (int)(termID + 1));
            this.sizes = ArrayUtil.grow((int[])this.sizes, (int)(termID + 1));
        }
        if (32768 - this.postingsPool.byteUpto < ByteBlockPool.FIRST_LEVEL_SIZE) {
            this.postingsPool.nextBuffer();
        }
        int upto = this.postingsPool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
        this.postingStarts[termID] = upto + this.postingsPool.byteOffset;
        this.postingUptos[termID] = upto + this.postingsPool.byteOffset;
    }

    void writeVInt(int termID, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(termID, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte(termID, (byte)i);
        int n = termID;
        this.sizes[n] = this.sizes[n] + 1;
    }

    private void writeByte(int termID, byte b) {
        int upto = this.postingUptos[termID];
        byte[] block = this.postingsPool.buffers[upto >> 15];
        assert (block != null);
        int offset = upto & Short.MAX_VALUE;
        if (block[offset] != 0) {
            offset = this.postingsPool.allocSlice(block, offset);
            block = this.postingsPool.buffer;
            this.postingUptos[termID] = offset + this.postingsPool.byteOffset;
        }
        block[offset] = b;
        int n = termID;
        this.postingUptos[n] = this.postingUptos[n] + 1;
    }
}

