/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.memory.MemoryIndex;
import org.apache.cassandra.index.sai.memory.MemtableOrdering;
import org.apache.cassandra.index.sai.memory.TrieMemoryIndex;
import org.apache.cassandra.index.sai.memory.VectorMemoryIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.utils.PrimaryKeys;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public class MemtableIndex
implements MemtableOrdering {
    private final MemoryIndex index;
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder estimatedMemoryUsed = new LongAdder();

    public MemtableIndex(IndexContext indexContext) {
        this.index = indexContext.isVector() ? new VectorMemoryIndex(indexContext) : new TrieMemoryIndex(indexContext);
    }

    public long writeCount() {
        return this.writeCount.sum();
    }

    public long estimatedMemoryUsed() {
        return this.estimatedMemoryUsed.sum();
    }

    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    public ByteBuffer getMinTerm() {
        return this.index.getMinTerm();
    }

    public ByteBuffer getMaxTerm() {
        return this.index.getMaxTerm();
    }

    public long index(DecoratedKey key, Clustering<?> clustering, ByteBuffer value) {
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        long ram = this.index.add(key, clustering, value);
        this.writeCount.increment();
        this.estimatedMemoryUsed.add(ram);
        return ram;
    }

    public long update(DecoratedKey key, Clustering<?> clustering, ByteBuffer oldValue, ByteBuffer newValue) {
        return this.index.update(key, clustering, oldValue, newValue);
    }

    public KeyRangeIterator search(QueryContext queryContext, Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        return this.index.search(queryContext, expression, keyRange);
    }

    public Iterator<Pair<ByteComparable, PrimaryKeys>> iterator() {
        return this.index.iterator();
    }

    public SegmentMetadata.ComponentMetadataMap writeDirect(IndexDescriptor indexDescriptor, IndexContext indexContext, Function<PrimaryKey, Integer> postingTransformer) throws IOException {
        return this.index.writeDirect(indexDescriptor, indexContext, postingTransformer);
    }

    @Override
    public KeyRangeIterator limitToTopResults(List<PrimaryKey> primaryKeys, Expression expression, int limit) {
        return this.index.limitToTopResults(primaryKeys, expression, limit);
    }
}

