/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;

public class KeyRangeConcatIterator
extends KeyRangeIterator {
    public static final String MUST_BE_SORTED_ERROR = "RangeIterator must be sorted, previous max: %s, next min: %s";
    private final PriorityQueue<KeyRangeIterator> ranges;
    private final List<KeyRangeIterator> toRelease;

    protected KeyRangeConcatIterator(KeyRangeIterator.Builder.Statistics statistics, PriorityQueue<KeyRangeIterator> ranges) {
        super(statistics);
        this.ranges = ranges;
        this.toRelease = new ArrayList<KeyRangeIterator>(ranges);
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        while (!this.ranges.isEmpty() && this.ranges.peek().getCurrent().compareTo(nextKey) < 0) {
            KeyRangeIterator head = this.ranges.poll();
            if (head.getMaximum().compareTo(nextKey) < 0) continue;
            head.skipTo(nextKey);
            this.ranges.add(head);
            break;
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.toRelease);
    }

    @Override
    protected PrimaryKey computeNext() {
        while (!this.ranges.isEmpty()) {
            KeyRangeIterator current = this.ranges.poll();
            if (!current.hasNext()) continue;
            PrimaryKey next = (PrimaryKey)current.next();
            if (current.hasNext()) {
                this.ranges.add(current);
            }
            return next;
        }
        return (PrimaryKey)this.endOfData();
    }

    public static Builder builder(int size) {
        return new Builder(size);
    }

    private static class ConcatStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private ConcatStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            if (range.getCount() > 0L) {
                if (this.count == 0L) {
                    this.min = range.getMinimum();
                } else if (this.count > 0L && this.max.compareTo(range.getMinimum()) > 0) {
                    throw new IllegalArgumentException(String.format(KeyRangeConcatIterator.MUST_BE_SORTED_ERROR, this.max, range.getMinimum()));
                }
                this.max = range.getMaximum();
                this.count += range.getCount();
            }
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        private final PriorityQueue<KeyRangeIterator> ranges;

        Builder(int size) {
            super(new ConcatStatistics());
            this.ranges = new PriorityQueue<KeyRangeIterator>(size, Comparator.comparing(KeyRangeIterator::getCurrent));
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getCount() > 0L) {
                this.ranges.add(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            this.statistics.update(range);
            return this;
        }

        @Override
        public int rangeCount() {
            return this.ranges.size();
        }

        @Override
        public void cleanup() {
            FileUtils.closeQuietly(this.ranges);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            if (this.rangeCount() == 1) {
                return this.ranges.poll();
            }
            return new KeyRangeConcatIterator(this.statistics, this.ranges);
        }
    }
}

