/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.PerColumnIndexFiles;
import org.apache.cassandra.index.sai.disk.v1.segment.IndexSegmentSearcher;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentOrdering;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;

public class Segment
implements SegmentOrdering,
Closeable {
    private final Token.KeyBound minKeyBound;
    private final Token.KeyBound maxKeyBound;
    final PrimaryKeyMap.Factory primaryKeyMapFactory;
    public final SegmentMetadata metadata;
    private final IndexSegmentSearcher index;

    public Segment(IndexContext indexContext, SSTableContext sstableContext, PerColumnIndexFiles indexFiles, SegmentMetadata metadata) throws IOException {
        this.minKeyBound = metadata.minKey.token().minKeyBound();
        this.maxKeyBound = metadata.maxKey.token().maxKeyBound();
        this.primaryKeyMapFactory = sstableContext.primaryKeyMapFactory;
        this.metadata = metadata;
        this.index = IndexSegmentSearcher.open(this.primaryKeyMapFactory, indexFiles, metadata, indexContext);
    }

    @VisibleForTesting
    public Segment(Token minKey, Token maxKey) {
        this.primaryKeyMapFactory = null;
        this.metadata = null;
        this.minKeyBound = minKey.minKeyBound();
        this.maxKeyBound = maxKey.maxKeyBound();
        this.index = null;
    }

    public boolean intersects(AbstractBounds<PartitionPosition> keyRange) {
        if (keyRange instanceof Range && ((Range)keyRange).isWrapAround()) {
            return keyRange.contains(this.minKeyBound) || keyRange.contains(this.maxKeyBound);
        }
        int cmp = ((PartitionPosition)keyRange.right).compareTo(this.minKeyBound);
        if (!((PartitionPosition)keyRange.right).isMinimum() && (!keyRange.inclusiveRight() && cmp == 0 || cmp < 0)) {
            return false;
        }
        cmp = ((PartitionPosition)keyRange.left).compareTo(this.maxKeyBound);
        return (keyRange.isStartInclusive() || cmp != 0) && cmp <= 0;
    }

    public long indexFileCacheSize() {
        return this.index == null ? 0L : this.index.indexFileCacheSize();
    }

    public KeyRangeIterator search(Expression expression, AbstractBounds<PartitionPosition> keyRange, QueryContext context) throws IOException {
        return this.index.search(expression, keyRange, context);
    }

    @Override
    public KeyRangeIterator limitToTopKResults(QueryContext context, List<PrimaryKey> primaryKeys, Expression expression) throws IOException {
        return this.index.limitToTopKResults(context, primaryKeys, expression);
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.index);
    }

    public String toString() {
        return String.format("Segment{metadata=%s}", this.metadata);
    }
}

