/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.keystore;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bitpack.MonotonicBlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

@NotThreadSafe
public class KeyLookup {
    public static final String INDEX_OUT_OF_BOUNDS = "The target point id [%d] cannot be less than 0 or greater than or equal to the key count [%d]";
    private final FileHandle keysFileHandle;
    private final KeyLookupMeta keyLookupMeta;
    private final LongArray.Factory keyBlockOffsetsFactory;

    public KeyLookup(@Nonnull FileHandle keysFileHandle, @Nonnull FileHandle keysBlockOffsets, @Nonnull KeyLookupMeta keyLookupMeta, @Nonnull NumericValuesMeta keyBlockOffsetsMeta) throws IOException {
        this.keysFileHandle = keysFileHandle;
        this.keyLookupMeta = keyLookupMeta;
        this.keyBlockOffsetsFactory = new MonotonicBlockPackedReader(keysBlockOffsets, keyBlockOffsetsMeta);
    }

    @Nonnull
    public Cursor openCursor() throws IOException {
        return new Cursor(this.keysFileHandle, this.keyBlockOffsetsFactory);
    }

    @NotThreadSafe
    public class Cursor
    implements AutoCloseable {
        private final IndexInputReader keysInput;
        private final int blockShift;
        private final int blockMask;
        private final boolean clustering;
        private final long keysFilePointer;
        private final LongArray blockOffsets;
        private final BytesRef currentKey;
        private final BytesRef nextBlockKey;
        private long currentPointId;
        private long currentBlockIndex;

        Cursor(FileHandle keysFileHandle, LongArray.Factory blockOffsetsFactory) throws IOException {
            this.keysInput = IndexInputReader.create(keysFileHandle);
            SAICodecUtils.validate(this.keysInput);
            this.blockShift = this.keysInput.readVInt();
            this.blockMask = (1 << this.blockShift) - 1;
            this.clustering = this.keysInput.readByte() == 1;
            this.keysFilePointer = this.keysInput.getFilePointer();
            this.blockOffsets = new LongArray.DeferredLongArray(blockOffsetsFactory::open);
            this.currentKey = new BytesRef(KeyLookup.this.keyLookupMeta.maxKeyLength);
            this.nextBlockKey = new BytesRef(KeyLookup.this.keyLookupMeta.maxKeyLength);
            this.keysInput.seek(this.keysFilePointer);
            this.readKey(this.currentPointId, this.currentKey);
        }

        @Nonnull
        public ByteSource seekToPointId(long pointId) {
            long blockIndex;
            if (pointId < 0L || pointId >= KeyLookup.this.keyLookupMeta.keyCount) {
                throw new IndexOutOfBoundsException(String.format(KeyLookup.INDEX_OUT_OF_BOUNDS, pointId, KeyLookup.this.keyLookupMeta.keyCount));
            }
            if (pointId != this.currentPointId && ((blockIndex = pointId >>> this.blockShift) != this.currentBlockIndex || pointId < this.currentPointId)) {
                this.currentBlockIndex = blockIndex;
                this.resetToCurrentBlock();
            }
            while (this.currentPointId < pointId) {
                ++this.currentPointId;
                this.readCurrentKey();
                this.updateCurrentBlockIndex(this.currentPointId);
            }
            return ByteSource.fixedLength(this.currentKey.bytes, this.currentKey.offset, this.currentKey.length);
        }

        public long clusteredSeekToKey(ByteComparable key, long startingPointId, long endingPointId) {
            assert (this.clustering) : "Cannot do a clustered seek to a key on non-clustered keys";
            BytesRef skipKey = this.asBytesRef(key);
            this.updateCurrentBlockIndex(startingPointId);
            this.resetToCurrentBlock();
            if (this.compareKeys(this.currentKey, skipKey) == 0) {
                return startingPointId;
            }
            if (this.notInCurrentBlock(startingPointId, skipKey)) {
                long splitPointId = startingPointId;
                for (long split = endingPointId - startingPointId >>> this.blockShift; split > 0L; split /= 2L) {
                    int cmp;
                    this.updateCurrentBlockIndex(Math.min((splitPointId >>> this.blockShift) + split, this.blockOffsets.length() - 1L));
                    this.resetToCurrentBlock();
                    if (this.currentPointId >= endingPointId) {
                        this.updateCurrentBlockIndex(endingPointId - 1L);
                        this.resetToCurrentBlock();
                    }
                    if ((cmp = this.compareKeys(this.currentKey, skipKey)) == 0) {
                        return this.currentPointId;
                    }
                    if (cmp >= 0) continue;
                    splitPointId = this.currentPointId;
                }
                while (this.currentBlockIndex > 0L && this.compareKeys(this.currentKey, skipKey) > 0) {
                    --this.currentBlockIndex;
                    this.resetToCurrentBlock();
                }
            }
            while (this.currentPointId < startingPointId) {
                ++this.currentPointId;
                this.readCurrentKey();
                this.updateCurrentBlockIndex(this.currentPointId);
            }
            while (this.currentPointId < endingPointId) {
                if (this.compareKeys(this.currentKey, skipKey) >= 0) {
                    return this.currentPointId;
                }
                ++this.currentPointId;
                if (this.currentPointId == KeyLookup.this.keyLookupMeta.keyCount) {
                    return -1L;
                }
                this.readCurrentKey();
                this.updateCurrentBlockIndex(this.currentPointId);
            }
            return endingPointId < KeyLookup.this.keyLookupMeta.keyCount ? endingPointId : -1L;
        }

        @VisibleForTesting
        public void reset() throws IOException {
            this.currentPointId = 0L;
            this.currentBlockIndex = 0L;
            this.keysInput.seek(this.keysFilePointer);
            this.readCurrentKey();
        }

        @Override
        public void close() {
            this.keysInput.close();
        }

        private void updateCurrentBlockIndex(long pointId) {
            this.currentBlockIndex = pointId >>> this.blockShift;
        }

        private boolean notInCurrentBlock(long pointId, BytesRef key) {
            if (this.inLastBlock(pointId)) {
                return false;
            }
            long blockIndex = (pointId >>> this.blockShift) + 1L;
            long currentFp = this.keysInput.getFilePointer();
            this.keysInput.seek(this.blockOffsets.get(blockIndex) + this.keysFilePointer);
            this.readKey(blockIndex << this.blockShift, this.nextBlockKey);
            this.keysInput.seek(currentFp);
            return this.compareKeys(key, this.nextBlockKey) >= 0;
        }

        private boolean inLastBlock(long pointId) {
            return pointId >>> this.blockShift == this.blockOffsets.length() - 1L;
        }

        private void resetToCurrentBlock() {
            this.keysInput.seek(this.blockOffsets.get(this.currentBlockIndex) + this.keysFilePointer);
            this.currentPointId = this.currentBlockIndex << this.blockShift;
            this.readCurrentKey();
        }

        private void readCurrentKey() {
            this.readKey(this.currentPointId, this.currentKey);
        }

        private void readKey(long pointId, BytesRef key) {
            try {
                int suffixLength;
                int prefixLength;
                if ((pointId & (long)this.blockMask) == 0L) {
                    prefixLength = 0;
                    suffixLength = this.keysInput.readVInt();
                } else {
                    int compressedLengths = Byte.toUnsignedInt(this.keysInput.readByte());
                    prefixLength = compressedLengths & 0xF;
                    suffixLength = compressedLengths >>> 4;
                    if (prefixLength == 15) {
                        prefixLength += this.keysInput.readVInt();
                    }
                    if (suffixLength == 15) {
                        suffixLength += this.keysInput.readVInt();
                    }
                }
                assert (prefixLength + suffixLength <= KeyLookup.this.keyLookupMeta.maxKeyLength);
                if (prefixLength + suffixLength > 0) {
                    key.length = prefixLength + suffixLength;
                    this.keysInput.readBytes(key.bytes, prefixLength, suffixLength);
                }
            }
            catch (IOException e) {
                throw Throwables.cleaned(e);
            }
        }

        private int compareKeys(BytesRef left, BytesRef right) {
            return FastByteOperations.compareUnsigned(left.bytes, left.offset, left.offset + left.length, right.bytes, right.offset, right.offset + right.length);
        }

        private BytesRef asBytesRef(ByteComparable source) {
            int val;
            BytesRefBuilder builder = new BytesRefBuilder();
            ByteSource byteSource = source.asComparableBytes(ByteComparable.Version.OSS50);
            while ((val = byteSource.next()) != -1) {
                builder.append((byte)val);
            }
            return builder.get();
        }
    }
}

