/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PerColumnIndexWriter;
import org.apache.cassandra.index.sai.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.RowMapping;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.format.OnDiskFormat;
import org.apache.cassandra.index.sai.disk.v1.MemtableIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.SSTableComponentsWriter;
import org.apache.cassandra.index.sai.disk.v1.SSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.SkinnyPrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.V1SSTableIndex;
import org.apache.cassandra.index.sai.disk.v1.WidePrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentBuilder;
import org.apache.cassandra.index.sai.utils.NamedMemoryLimiter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1OnDiskFormat
implements OnDiskFormat {
    private static final Logger logger = LoggerFactory.getLogger(V1OnDiskFormat.class);
    @VisibleForTesting
    public static final Set<IndexComponent> SKINNY_PER_SSTABLE_COMPONENTS = EnumSet.of(IndexComponent.GROUP_COMPLETION_MARKER, new IndexComponent[]{IndexComponent.GROUP_META, IndexComponent.TOKEN_VALUES, IndexComponent.PARTITION_SIZES, IndexComponent.PARTITION_KEY_BLOCKS, IndexComponent.PARTITION_KEY_BLOCK_OFFSETS});
    @VisibleForTesting
    public static final Set<IndexComponent> WIDE_PER_SSTABLE_COMPONENTS = EnumSet.of(IndexComponent.GROUP_COMPLETION_MARKER, new IndexComponent[]{IndexComponent.GROUP_META, IndexComponent.TOKEN_VALUES, IndexComponent.PARTITION_SIZES, IndexComponent.PARTITION_KEY_BLOCKS, IndexComponent.PARTITION_KEY_BLOCK_OFFSETS, IndexComponent.CLUSTERING_KEY_BLOCKS, IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS});
    @VisibleForTesting
    public static final Set<IndexComponent> LITERAL_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.TERMS_DATA, IndexComponent.POSTING_LISTS);
    @VisibleForTesting
    public static final Set<IndexComponent> NUMERIC_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.BALANCED_TREE, IndexComponent.POSTING_LISTS);
    @VisibleForTesting
    public static final Set<IndexComponent> VECTOR_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.COMPRESSED_VECTORS, IndexComponent.TERMS_DATA, IndexComponent.POSTING_LISTS);
    public static final long SEGMENT_BUILD_MEMORY_LIMIT = DatabaseDescriptor.getSAISegmentWriteBufferSpace().toBytes();
    public static final NamedMemoryLimiter SEGMENT_BUILD_MEMORY_LIMITER = new NamedMemoryLimiter(SEGMENT_BUILD_MEMORY_LIMIT, "Storage Attached Index Segment Builder");
    public static final V1OnDiskFormat instance;

    protected V1OnDiskFormat() {
    }

    @Override
    public PrimaryKeyMap.Factory newPrimaryKeyMapFactory(IndexDescriptor indexDescriptor, SSTableReader sstable) {
        return indexDescriptor.hasClustering() ? new WidePrimaryKeyMap.Factory(indexDescriptor, sstable) : new SkinnyPrimaryKeyMap.Factory(indexDescriptor, sstable);
    }

    @Override
    public SSTableIndex newSSTableIndex(SSTableContext sstableContext, IndexContext indexContext) {
        return new V1SSTableIndex(sstableContext, indexContext);
    }

    @Override
    public PerSSTableIndexWriter newPerSSTableIndexWriter(IndexDescriptor indexDescriptor) throws IOException {
        return new SSTableComponentsWriter(indexDescriptor);
    }

    @Override
    public PerColumnIndexWriter newPerColumnIndexWriter(StorageAttachedIndex index, IndexDescriptor indexDescriptor, LifecycleNewTracker tracker, RowMapping rowMapping) {
        if (tracker.opType() != OperationType.FLUSH || !index.isInitBuildStarted()) {
            NamedMemoryLimiter limiter = SEGMENT_BUILD_MEMORY_LIMITER;
            logger.info(index.getIndexContext().logMessage("Starting a compaction index build. Global segment memory usage: {}"), (Object)FBUtilities.prettyPrintMemory(limiter.currentBytesUsed()));
            return new SSTableIndexWriter(indexDescriptor, index.getIndexContext(), limiter, index.isIndexValid());
        }
        return new MemtableIndexWriter(index.getIndexContext().getMemtableIndexManager().getPendingMemtableIndex(tracker), indexDescriptor, index.getIndexContext(), rowMapping);
    }

    @Override
    public boolean isPerSSTableIndexBuildComplete(IndexDescriptor indexDescriptor) {
        return indexDescriptor.hasComponent(IndexComponent.GROUP_COMPLETION_MARKER);
    }

    @Override
    public boolean isPerColumnIndexBuildComplete(IndexDescriptor indexDescriptor, IndexContext indexContext) {
        return indexDescriptor.hasComponent(IndexComponent.GROUP_COMPLETION_MARKER) && indexDescriptor.hasComponent(IndexComponent.COLUMN_COMPLETION_MARKER, indexContext);
    }

    @Override
    public void validatePerSSTableIndexComponents(IndexDescriptor indexDescriptor, boolean checksum) {
        for (IndexComponent indexComponent : this.perSSTableIndexComponents(indexDescriptor.hasClustering())) {
            if (!this.isNotBuildCompletionMarker(indexComponent)) continue;
            try {
                IndexInput input = indexDescriptor.openPerSSTableInput(indexComponent);
                try {
                    if (checksum) {
                        SAICodecUtils.validateChecksum(input);
                        continue;
                    }
                    SAICodecUtils.validate(input);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (Exception e) {
                logger.warn(indexDescriptor.logMessage("{} failed for index component {} on SSTable {}."), new Object[]{checksum ? "Checksum validation" : "Validation", indexComponent, indexDescriptor.sstableDescriptor});
                V1OnDiskFormat.rethrowIOException(e);
            }
        }
    }

    @Override
    public void validatePerColumnIndexComponents(IndexDescriptor indexDescriptor, IndexContext indexContext, boolean checksum) {
        for (IndexComponent indexComponent : this.perColumnIndexComponents(indexContext)) {
            if (!this.isNotBuildCompletionMarker(indexComponent)) continue;
            try {
                IndexInput input = indexDescriptor.openPerIndexInput(indexComponent, indexContext);
                try {
                    if (checksum) {
                        SAICodecUtils.validateChecksum(input);
                        continue;
                    }
                    SAICodecUtils.validate(input);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (Exception e) {
                logger.warn(indexDescriptor.logMessage("{} failed for index component {} on SSTable {}"), new Object[]{checksum ? "Checksum validation" : "Validation", indexComponent, indexDescriptor.sstableDescriptor});
                V1OnDiskFormat.rethrowIOException(e);
            }
        }
    }

    private static void rethrowIOException(Exception e) {
        if (e instanceof IOException) {
            throw new UncheckedIOException((IOException)e);
        }
        if (e.getCause() instanceof IOException) {
            throw new UncheckedIOException((IOException)e.getCause());
        }
        throw Throwables.unchecked(e);
    }

    @Override
    public Set<IndexComponent> perSSTableIndexComponents(boolean hasClustering) {
        return hasClustering ? WIDE_PER_SSTABLE_COMPONENTS : SKINNY_PER_SSTABLE_COMPONENTS;
    }

    @Override
    public Set<IndexComponent> perColumnIndexComponents(IndexContext indexContext) {
        return indexContext.isVector() ? VECTOR_COMPONENTS : (indexContext.isLiteral() ? LITERAL_COMPONENTS : NUMERIC_COMPONENTS);
    }

    @Override
    public int openFilesPerSSTableIndex(boolean hasClustering) {
        return hasClustering ? 6 : 4;
    }

    @Override
    public int openFilesPerColumnIndex(IndexContext indexContext) {
        return 2;
    }

    protected boolean isNotBuildCompletionMarker(IndexComponent indexComponent) {
        return indexComponent != IndexComponent.GROUP_COMPLETION_MARKER && indexComponent != IndexComponent.COLUMN_COMPLETION_MARKER;
    }

    static {
        CassandraMetricsRegistry.MetricName bufferSpaceUsed = DefaultNameFactory.createMetricName("StorageAttachedIndex", "SegmentBufferSpaceUsedBytes", null);
        CassandraMetricsRegistry.Metrics.register(bufferSpaceUsed, SEGMENT_BUILD_MEMORY_LIMITER::currentBytesUsed);
        CassandraMetricsRegistry.MetricName bufferSpaceLimit = DefaultNameFactory.createMetricName("StorageAttachedIndex", "SegmentBufferSpaceLimitBytes", null);
        CassandraMetricsRegistry.Metrics.register(bufferSpaceLimit, () -> SEGMENT_BUILD_MEMORY_LIMIT);
        CassandraMetricsRegistry.MetricName buildsInProgress = DefaultNameFactory.createMetricName("StorageAttachedIndex", "ColumnIndexBuildsInProgress", null);
        CassandraMetricsRegistry.Metrics.register(buildsInProgress, SegmentBuilder::getActiveBuilderCount);
        instance = new V1OnDiskFormat();
    }
}

