/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.MetadataSource;
import org.apache.cassandra.index.sai.disk.v1.bitpack.BlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.MonotonicBlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookup;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;

@NotThreadSafe
public class SkinnyPrimaryKeyMap
implements PrimaryKeyMap {
    protected final LongArray tokenArray;
    protected final LongArray partitionArray;
    protected final KeyLookup.Cursor partitionKeyCursor;
    protected final PrimaryKey.Factory primaryKeyFactory;

    protected SkinnyPrimaryKeyMap(LongArray tokenArray, LongArray partitionArray, KeyLookup.Cursor partitionKeyCursor, PrimaryKey.Factory primaryKeyFactory) {
        this.tokenArray = tokenArray;
        this.partitionArray = partitionArray;
        this.partitionKeyCursor = partitionKeyCursor;
        this.primaryKeyFactory = primaryKeyFactory;
    }

    @Override
    public PrimaryKey primaryKeyFromRowId(long sstableRowId) {
        return this.primaryKeyFactory.create(this.readPartitionKey(sstableRowId));
    }

    @Override
    public long rowIdFromPrimaryKey(PrimaryKey primaryKey) {
        long rowId = this.tokenArray.indexOf(primaryKey.token().getLongValue());
        if (primaryKey.kind() == PrimaryKey.Kind.TOKEN || rowId < 0L || rowId + 1L == this.tokenArray.length() || this.tokenArray.get(rowId) != primaryKey.token().getLongValue()) {
            return rowId;
        }
        return this.tokenCollisionDetection(primaryKey, rowId);
    }

    @Override
    public long ceiling(Token token) {
        return this.tokenArray.indexOf(token.getLongValue());
    }

    @Override
    public long floor(Token token) {
        if (token.isMinimum()) {
            return Long.MIN_VALUE;
        }
        long rowId = this.tokenArray.indexOf(token.getLongValue());
        return rowId < 0L ? rowId : rowId;
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(Arrays.asList(this.partitionKeyCursor, this.tokenArray, this.partitionArray));
    }

    protected long tokenCollisionDetection(PrimaryKey primaryKey, long rowId) {
        while (rowId + 1L < this.tokenArray.length() && primaryKey.token().getLongValue() == this.tokenArray.get(rowId + 1L)) {
            if (this.readPartitionKey(rowId).compareTo(primaryKey.partitionKey()) >= 0) {
                return rowId;
            }
            ++rowId;
        }
        return rowId;
    }

    protected DecoratedKey readPartitionKey(long sstableRowId) {
        return this.primaryKeyFactory.partitionKeyFromComparableBytes(this.partitionKeyCursor.seekToPointId(this.partitionArray.get(sstableRowId)));
    }

    @ThreadSafe
    public static class Factory
    implements PrimaryKeyMap.Factory {
        protected final MetadataSource metadataSource;
        protected final LongArray.Factory tokenReaderFactory;
        protected final LongArray.Factory partitionReaderFactory;
        protected final KeyLookup partitionKeyReader;
        protected final PrimaryKey.Factory primaryKeyFactory;
        private final FileHandle tokensFile;
        private final FileHandle partitionsFile;
        private final FileHandle partitionKeyBlockOffsetsFile;
        private final FileHandle partitionKeyBlocksFile;

        public Factory(IndexDescriptor indexDescriptor, SSTableReader sstable) {
            this.tokensFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.TOKEN_VALUES, this::close);
            this.partitionsFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_SIZES, this::close);
            this.partitionKeyBlockOffsetsFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_KEY_BLOCK_OFFSETS, this::close);
            this.partitionKeyBlocksFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_KEY_BLOCKS, this::close);
            try {
                this.metadataSource = MetadataSource.loadGroupMetadata(indexDescriptor);
                NumericValuesMeta tokensMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.TOKEN_VALUES)));
                this.tokenReaderFactory = new BlockPackedReader(this.tokensFile, tokensMeta);
                NumericValuesMeta partitionsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_SIZES)));
                this.partitionReaderFactory = new MonotonicBlockPackedReader(this.partitionsFile, partitionsMeta);
                NumericValuesMeta partitionKeyBlockOffsetsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_KEY_BLOCK_OFFSETS)));
                KeyLookupMeta partitionKeysMeta = new KeyLookupMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_KEY_BLOCKS)));
                this.partitionKeyReader = new KeyLookup(this.partitionKeyBlocksFile, this.partitionKeyBlockOffsetsFile, partitionKeysMeta, partitionKeyBlockOffsetsMeta);
                this.primaryKeyFactory = indexDescriptor.primaryKeyFactory;
            }
            catch (Throwable t) {
                throw Throwables.unchecked(t);
            }
        }

        @Override
        public PrimaryKeyMap newPerSSTablePrimaryKeyMap() throws IOException {
            LongArray.DeferredLongArray rowIdToToken = new LongArray.DeferredLongArray(this.tokenReaderFactory::open);
            LongArray.DeferredLongArray rowIdToPartitionId = new LongArray.DeferredLongArray(this.partitionReaderFactory::open);
            return new SkinnyPrimaryKeyMap(rowIdToToken, rowIdToPartitionId, this.partitionKeyReader.openCursor(), this.primaryKeyFactory);
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(Arrays.asList(this.tokensFile, this.partitionsFile, this.partitionKeyBlocksFile, this.partitionKeyBlockOffsetsFile));
        }
    }
}

